/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix;

import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworkIF;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public final class BsdNetworkIF
extends AbstractNetworkIF {
    private static final Logger LOG = LoggerFactory.getLogger(BsdNetworkIF.class);
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long timeStamp;

    /*
     * WARNING - void declaration
     */
    public BsdNetworkIF(NetworkInterface netint) throws InstantiationException {
        super((NetworkInterface)var1_1);
        void var1_1;
        this.updateAttributes();
    }

    /*
     * WARNING - void declaration
     */
    public static List<NetworkIF> getNetworks(boolean includeLocalInterfaces) {
        void var1_2;
        boolean bl;
        ArrayList<BsdNetworkIF> ifList = new ArrayList<BsdNetworkIF>();
        for (NetworkInterface ni : BsdNetworkIF.getNetworkInterfaces(bl)) {
            try {
                ifList.add(new BsdNetworkIF(ni));
            }
            catch (InstantiationException e) {
                void var2_4;
                LOG.debug("Network Interface Instantiation failed: {}", (Object)var2_4.getMessage());
            }
        }
        return var1_2;
    }

    @Override
    public final long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public final long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public final long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public final long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public final long getInErrors() {
        return this.inErrors;
    }

    @Override
    public final long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public final long getInDrops() {
        return this.inDrops;
    }

    @Override
    public final long getCollisions() {
        return this.collisions;
    }

    @Override
    public final long getSpeed() {
        return 0L;
    }

    @Override
    public final long getTimeStamp() {
        return this.timeStamp;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean updateAttributes() {
        void var1_1;
        String stats = ExecutingCommand.getAnswerAt("netstat -bI " + this.getName(), 1);
        this.timeStamp = System.currentTimeMillis();
        String[] split = ParseUtil.whitespaces.split(stats);
        if (split.length < 12) {
            return false;
        }
        this.bytesSent = ParseUtil.parseUnsignedLongOrDefault(split[10], 0L);
        this.bytesRecv = ParseUtil.parseUnsignedLongOrDefault(split[7], 0L);
        this.packetsSent = ParseUtil.parseUnsignedLongOrDefault(split[8], 0L);
        this.packetsRecv = ParseUtil.parseUnsignedLongOrDefault(split[4], 0L);
        this.outErrors = ParseUtil.parseUnsignedLongOrDefault(split[9], 0L);
        this.inErrors = ParseUtil.parseUnsignedLongOrDefault(split[5], 0L);
        this.collisions = ParseUtil.parseUnsignedLongOrDefault(split[11], 0L);
        this.inDrops = ParseUtil.parseUnsignedLongOrDefault((String)var1_1[6], 0L);
        return true;
    }
}

