/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.mac.net.NetStat;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworkIF;
import oshi.jna.platform.mac.SystemConfiguration;

@ThreadSafe
public final class MacNetworkIF
extends AbstractNetworkIF {
    private static final Logger LOG = LoggerFactory.getLogger(MacNetworkIF.class);
    private int ifType;
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long speed;
    private long timeStamp;

    /*
     * WARNING - void declaration
     */
    public MacNetworkIF(NetworkInterface netint, Map<Integer, NetStat.IFdata> data) throws InstantiationException {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        super((NetworkInterface)v0, MacNetworkIF.queryIfDisplayName((NetworkInterface)v0));
        this.updateNetworkStats((Map<Integer, NetStat.IFdata>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static String queryIfDisplayName(NetworkInterface netint) {
        Object object;
        Object name2 = netint.getName();
        CoreFoundation.CFArrayRef ifArray = SystemConfiguration.INSTANCE.SCNetworkInterfaceCopyAll();
        if (ifArray != null) {
            try {
                int count = ifArray.getCount();
                for (int i = 0; i < count; ++i) {
                    Pointer pNetIf = ifArray.getValueAtIndex(i);
                    SystemConfiguration.SCNetworkInterfaceRef scNetIf = new SystemConfiguration.SCNetworkInterfaceRef(pNetIf);
                    CoreFoundation.CFStringRef cfName = SystemConfiguration.INSTANCE.SCNetworkInterfaceGetBSDName(scNetIf);
                    if (cfName == null || !((String)name2).equals(cfName.stringValue())) continue;
                    name2 = SystemConfiguration.INSTANCE.SCNetworkInterfaceGetLocalizedDisplayName(scNetIf);
                    name2 = name2.stringValue();
                }
            }
            catch (Throwable name2) {
                void var1_2;
                var1_2.release();
                throw name2;
            }
            {
                ifArray.release();
                return name2;
            }
            ifArray.release();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static List<NetworkIF> getNetworks(boolean includeLocalInterfaces) {
        void var2_3;
        boolean bl;
        Map<Integer, NetStat.IFdata> data = NetStat.queryIFdata(-1);
        ArrayList<MacNetworkIF> ifList = new ArrayList<MacNetworkIF>();
        for (NetworkInterface ni : MacNetworkIF.getNetworkInterfaces(bl)) {
            try {
                ifList.add(new MacNetworkIF(ni, data));
            }
            catch (InstantiationException e) {
                void var3_5;
                LOG.debug("Network Interface Instantiation failed: {}", (Object)var3_5.getMessage());
            }
        }
        return var2_3;
    }

    @Override
    public final int getIfType() {
        return this.ifType;
    }

    @Override
    public final long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public final long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public final long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public final long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public final long getInErrors() {
        return this.inErrors;
    }

    @Override
    public final long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public final long getInDrops() {
        return this.inDrops;
    }

    @Override
    public final long getCollisions() {
        return this.collisions;
    }

    @Override
    public final long getSpeed() {
        return this.speed;
    }

    @Override
    public final long getTimeStamp() {
        return this.timeStamp;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean updateAttributes() {
        void var1_1;
        int index = this.queryNetworkInterface().getIndex();
        return this.updateNetworkStats(NetStat.queryIFdata((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateNetworkStats(Map<Integer, NetStat.IFdata> data) {
        int index = this.queryNetworkInterface().getIndex();
        if (data.containsKey(index)) {
            void var1_1;
            void var2_2;
            NetStat.IFdata ifData = data.get((int)var2_2);
            this.ifType = ifData.getIfType();
            this.bytesSent = ifData.getOBytes();
            this.bytesRecv = ifData.getIBytes();
            this.packetsSent = ifData.getOPackets();
            this.packetsRecv = ifData.getIPackets();
            this.outErrors = ifData.getOErrors();
            this.inErrors = ifData.getIErrors();
            this.collisions = ifData.getCollisions();
            this.inDrops = ifData.getIDrops();
            this.speed = ifData.getSpeed();
            this.timeStamp = var1_1.getTimeStamp();
            return true;
        }
        return false;
    }
}

