/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.GraphicsCard;
import oshi.hardware.common.AbstractGraphicsCard;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@Immutable
final class MacGraphicsCard
extends AbstractGraphicsCard {
    /*
     * WARNING - void declaration
     */
    MacGraphicsCard(String name, String deviceId, String vendor, String versionInfo, long vram) {
        super((String)var1_1, (String)var2_2, (String)var3_3, versionInfo, vram);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<GraphicsCard> getGraphicsCards() {
        void var0;
        void var3_3;
        void var2_2;
        Iterator iterator;
        ArrayList<MacGraphicsCard> cardList = new ArrayList<MacGraphicsCard>();
        List<String> sp = ExecutingCommand.runNative("system_profiler SPDisplaysDataType");
        String name = "unknown";
        String deviceId = "unknown";
        String vendor = "unknown";
        ArrayList<String> versionInfoList = new ArrayList<String>();
        long vram = 0L;
        int cardNum = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            String[] split = line.trim().split(":", 2);
            if (split.length != 2) continue;
            String prefix = split[0].toLowerCase();
            if (prefix.equals("chipset model")) {
                if (cardNum++ > 0) {
                    cardList.add(new MacGraphicsCard(name, deviceId, vendor, versionInfoList.isEmpty() ? "unknown" : String.join((CharSequence)", ", versionInfoList), vram));
                    versionInfoList.clear();
                }
                name = split[1].trim();
                continue;
            }
            if (prefix.equals("device id")) {
                deviceId = split[1].trim();
                continue;
            }
            if (prefix.equals("vendor")) {
                vendor = split[1].trim();
                continue;
            }
            if (prefix.contains("version") || prefix.contains("revision")) {
                versionInfoList.add(line.trim());
                continue;
            }
            if (!prefix.startsWith("vram")) continue;
            vram = ParseUtil.parseDecimalMemorySizeToBinary(split[1].trim());
        }
        cardList.add(new MacGraphicsCard((String)var2_2, (String)var3_3, vendor, versionInfoList.isEmpty() ? "unknown" : String.join((CharSequence)", ", versionInfoList), vram));
        return var0;
    }
}

