/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.VirtualMemory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.hardware.platform.mac.MacVirtualMemory;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.mac.SysctlUtil;

@ThreadSafe
final class MacGlobalMemory
extends AbstractGlobalMemory {
    private static final Logger LOG = LoggerFactory.getLogger(MacGlobalMemory.class);
    private final Supplier<Long> available = Memoizer.memoize(this::queryVmStats, Memoizer.defaultExpiration());
    private final Supplier<Long> total = Memoizer.memoize(MacGlobalMemory::queryPhysMem);
    private final Supplier<Long> pageSize = Memoizer.memoize(MacGlobalMemory::queryPageSize);
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    MacGlobalMemory() {
    }

    @Override
    public final long getAvailable() {
        return this.available.get();
    }

    @Override
    public final long getTotal() {
        return this.total.get();
    }

    @Override
    public final long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public final VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<PhysicalMemory> getPhysicalMemory() {
        void var1_1;
        Iterator iterator;
        ArrayList<PhysicalMemory> pmList = new ArrayList<PhysicalMemory>();
        List<String> sp = ExecutingCommand.runNative("system_profiler SPMemoryDataType");
        int bank = 0;
        String bankLabel = "unknown";
        long capacity = 0L;
        long speed = 0L;
        String manufacturer = "unknown";
        String memoryType = "unknown";
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void colon2;
            String[] split;
            String line = (String)iterator.next();
            if (line.trim().startsWith("BANK")) {
                int colon2;
                if (bank++ > 0) {
                    pmList.add(new PhysicalMemory(bankLabel, capacity, speed, manufacturer, memoryType));
                }
                if ((colon2 = (bankLabel = line.trim()).lastIndexOf(58)) <= 0) continue;
                bankLabel = bankLabel.substring(0, colon2 - 1);
                continue;
            }
            if (bank > 0 && (split = colon2.trim().split(":")).length == 2) {
                switch (split[0]) {
                    case "Size": {
                        capacity = ParseUtil.parseDecimalMemorySizeToBinary(split[1].trim());
                        break;
                    }
                    case "Type": {
                        memoryType = split[1].trim();
                        break;
                    }
                    case "Speed": {
                        speed = ParseUtil.parseHertz(split[1]);
                        break;
                    }
                    case "Manufacturer": {
                        manufacturer = split[1].trim();
                    }
                }
            }
        }
        pmList.add(new PhysicalMemory(bankLabel, capacity, speed, manufacturer, memoryType));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private long queryVmStats() {
        void var1_1;
        SystemB.VMStatistics vmStats = new SystemB.VMStatistics();
        SystemB systemB = SystemB.INSTANCE;
        if (0 != systemB.host_statistics(systemB.mach_host_self(), 2, (Structure)vmStats, new IntByReference(vmStats.size() / SystemB.INT_SIZE))) {
            LOG.error("Failed to get host VM info. Error code: {}", (Object)Native.getLastError());
            return 0L;
        }
        return (long)(vmStats.free_count + var1_1.inactive_count) * this.getPageSize();
    }

    private static long queryPhysMem() {
        return SysctlUtil.sysctl("hw.memsize", 0L);
    }

    /*
     * WARNING - void declaration
     */
    private static long queryPageSize() {
        LongByReference pPageSize = new LongByReference();
        SystemB systemB = SystemB.INSTANCE;
        if (0 == systemB.host_page_size(systemB.mach_host_self(), pPageSize)) {
            void var0;
            return var0.getValue();
        }
        LOG.error("Failed to get host page size. Error code: {}", (Object)Native.getLastError());
        return 4098L;
    }

    private VirtualMemory createVirtualMemory() {
        return new MacVirtualMemory(this);
    }
}

