/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Native;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.mac.MacBaseboard;
import oshi.hardware.platform.mac.MacFirmware;
import oshi.util.Memoizer;
import oshi.util.Util;
import oshi.util.tuples.Quartet;

@Immutable
final class MacComputerSystem
extends AbstractComputerSystem {
    private final Supplier<Quartet<String, String, String, String>> manufacturerModelSerialUUID = Memoizer.memoize(MacComputerSystem::platformExpert);

    MacComputerSystem() {
    }

    @Override
    public final String getManufacturer() {
        return this.manufacturerModelSerialUUID.get().getA();
    }

    @Override
    public final String getModel() {
        return this.manufacturerModelSerialUUID.get().getB();
    }

    @Override
    public final String getSerialNumber() {
        return this.manufacturerModelSerialUUID.get().getC();
    }

    @Override
    public final String getHardwareUUID() {
        return this.manufacturerModelSerialUUID.get().getD();
    }

    @Override
    public final Firmware createFirmware() {
        return new MacFirmware();
    }

    @Override
    public final Baseboard createBaseboard() {
        return new MacBaseboard();
    }

    /*
     * WARNING - void declaration
     */
    private static Quartet<String, String, String, String> platformExpert() {
        void var3_3;
        void var1_1;
        void var0;
        String string;
        String manufacturer = null;
        String model = null;
        Object serialNumber = null;
        String uuid = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService((String)"IOPlatformExpertDevice");
        if (platformExpert != null) {
            byte[] data = platformExpert.getByteArrayProperty("manufacturer");
            if (data != null) {
                manufacturer = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            if ((data = platformExpert.getByteArrayProperty("model")) != null) {
                model = Native.toString((byte[])string, (Charset)StandardCharsets.UTF_8);
            }
            string = platformExpert.getStringProperty("IOPlatformSerialNumber");
            uuid = platformExpert.getStringProperty("IOPlatformUUID");
            platformExpert.release();
        }
        return new Quartet<String, String, String, String>((String)(Util.isBlank(manufacturer) ? "Apple Inc." : var0), (String)(Util.isBlank(model) ? "unknown" : var1_1), Util.isBlank(string) ? "unknown" : string, (String)(Util.isBlank(uuid) ? "unknown" : var3_3));
    }
}

