/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Native;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.common.AbstractBaseboard;
import oshi.util.Memoizer;
import oshi.util.Util;
import oshi.util.tuples.Quartet;

@Immutable
final class MacBaseboard
extends AbstractBaseboard {
    private final Supplier<Quartet<String, String, String, String>> manufModelVersSerial = Memoizer.memoize(MacBaseboard::queryPlatform);

    MacBaseboard() {
    }

    @Override
    public final String getManufacturer() {
        return this.manufModelVersSerial.get().getA();
    }

    @Override
    public final String getModel() {
        return this.manufModelVersSerial.get().getB();
    }

    @Override
    public final String getVersion() {
        return this.manufModelVersSerial.get().getC();
    }

    @Override
    public final String getSerialNumber() {
        return this.manufModelVersSerial.get().getD();
    }

    /*
     * WARNING - void declaration
     */
    private static Quartet<String, String, String, String> queryPlatform() {
        void var3_3;
        void var2_2;
        void var1_1;
        void var0;
        String manufacturer = null;
        String model = null;
        String version = null;
        String serialNumber = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService((String)"IOPlatformExpertDevice");
        if (platformExpert != null) {
            byte[] data = platformExpert.getByteArrayProperty("manufacturer");
            if (data != null) {
                manufacturer = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            if ((data = platformExpert.getByteArrayProperty("board-id")) != null) {
                model = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            if (Util.isBlank(model) && (data = platformExpert.getByteArrayProperty("model-number")) != null) {
                model = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            if ((data = platformExpert.getByteArrayProperty("version")) != null) {
                version = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            if ((data = platformExpert.getByteArrayProperty("mlb-serial-number")) != null) {
                serialNumber = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            if (Util.isBlank(serialNumber)) {
                serialNumber = platformExpert.getStringProperty("IOPlatformSerialNumber");
            }
            platformExpert.release();
        }
        return new Quartet<String, String, String, String>((String)(Util.isBlank(manufacturer) ? "Apple Inc." : var0), (String)(Util.isBlank(model) ? "unknown" : var1_1), (String)(Util.isBlank(version) ? "unknown" : var2_2), (String)(Util.isBlank(serialNumber) ? "unknown" : var3_3));
    }
}

