/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.common.AbstractVirtualMemory;
import oshi.hardware.platform.linux.LinuxGlobalMemory;
import oshi.util.FileUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
final class LinuxVirtualMemory
extends AbstractVirtualMemory {
    private final LinuxGlobalMemory global;
    private final Supplier<Triplet<Long, Long, Long>> usedTotalCommitLim = Memoizer.memoize(LinuxVirtualMemory::queryMemInfo, Memoizer.defaultExpiration());
    private final Supplier<Pair<Long, Long>> inOut = Memoizer.memoize(LinuxVirtualMemory::queryVmStat, Memoizer.defaultExpiration());

    /*
     * WARNING - void declaration
     */
    LinuxVirtualMemory(LinuxGlobalMemory linuxGlobalMemory) {
        void var1_1;
        this.global = var1_1;
    }

    @Override
    public final long getSwapUsed() {
        return this.usedTotalCommitLim.get().getA();
    }

    @Override
    public final long getSwapTotal() {
        return this.usedTotalCommitLim.get().getB();
    }

    @Override
    public final long getVirtualMax() {
        return this.usedTotalCommitLim.get().getC();
    }

    @Override
    public final long getVirtualInUse() {
        return this.global.getTotal() - this.global.getAvailable() + this.getSwapUsed();
    }

    @Override
    public final long getSwapPagesIn() {
        return this.inOut.get().getA();
    }

    @Override
    public final long getSwapPagesOut() {
        return this.inOut.get().getB();
    }

    /*
     * WARNING - void declaration
     */
    private static Triplet<Long, Long, Long> queryMemInfo() {
        void var2_1;
        void var0;
        long swapFree = 0L;
        long swapTotal = 0L;
        long commitLimit = 0L;
        Object object = FileUtil.readFile(ProcPath.MEMINFO);
        object = object.iterator();
        while (object.hasNext()) {
            String checkLine = (String)object.next();
            String[] memorySplit = ParseUtil.whitespaces.split(checkLine);
            if (memorySplit.length > 1) {
                switch (memorySplit[0]) {
                    case "SwapTotal:": {
                        swapTotal = LinuxVirtualMemory.parseMeminfo(memorySplit);
                        break;
                    }
                    case "SwapFree:": {
                        swapFree = LinuxVirtualMemory.parseMeminfo(memorySplit);
                        break;
                    }
                    case "CommitLimit:": {
                        commitLimit = LinuxVirtualMemory.parseMeminfo(memorySplit);
                    }
                }
            }
        }
        return new Triplet<Long, Long, Long>(swapTotal - var0, (long)var2_1, commitLimit);
    }

    /*
     * WARNING - void declaration
     */
    private static Pair<Long, Long> queryVmStat() {
        void var2_1;
        void var0;
        long swapPagesIn = 0L;
        long swapPagesOut = 0L;
        Object object = FileUtil.readFile(ProcPath.VMSTAT);
        object = object.iterator();
        while (object.hasNext()) {
            String checkLine = (String)object.next();
            String[] memorySplit = ParseUtil.whitespaces.split(checkLine);
            if (memorySplit.length > 1) {
                switch (memorySplit[0]) {
                    case "pswpin": {
                        swapPagesIn = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
                        break;
                    }
                    case "pswpout": {
                        swapPagesOut = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
                    }
                }
            }
        }
        return new Pair<Long, Long>((long)var0, (long)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    private static long parseMeminfo(String[] memorySplit) {
        void var1_1;
        String[] stringArray;
        if (memorySplit.length < 2) {
            return 0L;
        }
        long memory = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
        if (memorySplit.length > 2 && "kB".equals(stringArray[2])) {
            memory <<= 10;
        }
        return (long)var1_1;
    }
}

