/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.SoundCard;
import oshi.hardware.common.AbstractSoundCard;
import oshi.util.FileUtil;
import oshi.util.platform.linux.ProcPath;

@Immutable
final class LinuxSoundCard
extends AbstractSoundCard {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxSoundCard.class);
    private static final String CARD_FOLDER = "card";
    private static final String CARDS_FILE = "cards";
    private static final String ID_FILE = "id";

    /*
     * WARNING - void declaration
     */
    LinuxSoundCard(String kernelVersion, String name, String codec) {
        super((String)var1_1, (String)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static List<File> getCardFolders() {
        void var1_1;
        File cardsDirectory = new File(ProcPath.ASOUND);
        ArrayList<void> cardFolders = new ArrayList<void>();
        File[] allContents = cardsDirectory.listFiles();
        if (allContents != null) {
            void var0;
            for (void card : var0) {
                if (!card.getName().startsWith(CARD_FOLDER) || !card.isDirectory()) continue;
                cardFolders.add(card);
            }
        } else {
            LOG.warn("No Audio Cards Found");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String getSoundCardVersion() {
        void var0;
        String driverVersion = FileUtil.getStringFromFile(ProcPath.ASOUND + "version");
        if (driverVersion.isEmpty()) {
            return "not available";
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static String getCardCodec(File cardDir) {
        void var1_1;
        String cardCodec = "";
        File[] cardFiles = cardDir.listFiles();
        if (cardFiles != null) {
            File[] fileArray;
            block0: for (File file : fileArray) {
                if (!file.getName().startsWith("codec")) continue;
                if (!file.isDirectory()) {
                    cardCodec = FileUtil.getKeyValueMapFromFile(file.getPath(), ":").get("Codec");
                    continue;
                }
                File[] codecs = file.listFiles();
                if (codecs == null) continue;
                File[] fileArray2 = codecs;
                int n = codecs.length;
                for (int i = 0; i < n; ++i) {
                    File codec = fileArray2[i];
                    if (codec.isDirectory() || !codec.getName().contains("#")) continue;
                    cardCodec = codec.getName().substring(0, codec.getName().indexOf(35));
                    continue block0;
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String getCardName(File file) {
        void var1_1;
        Iterator iterator;
        String cardName = "Not Found..";
        Map<String, String> cardNamePairs = FileUtil.getKeyValueMapFromFile(ProcPath.ASOUND + "/cards", ":");
        String cardId = FileUtil.getStringFromFile(file.getPath() + "/id");
        for (Map.Entry entry : iterator.entrySet()) {
            void var3_3;
            if (!((String)entry.getKey()).contains(cardId)) continue;
            cardName = (String)var3_3.getValue();
            return cardName;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<SoundCard> getSoundCards() {
        void var0;
        ArrayList<LinuxSoundCard> soundCards = new ArrayList<LinuxSoundCard>();
        for (File cardFile : LinuxSoundCard.getCardFolders()) {
            void var2_2;
            soundCards.add(new LinuxSoundCard(LinuxSoundCard.getSoundCardVersion(), LinuxSoundCard.getCardName(cardFile), LinuxSoundCard.getCardCodec((File)var2_2)));
        }
        return var0;
    }
}

