/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import com.sun.jna.platform.linux.Udev;
import java.io.File;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworkIF;
import oshi.util.FileUtil;
import oshi.util.Util;

@ThreadSafe
public final class LinuxNetworkIF
extends AbstractNetworkIF {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxNetworkIF.class);
    private int ifType;
    private boolean connectorPresent;
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long speed;
    private long timeStamp;
    private String ifAlias;
    private NetworkIF.IfOperStatus ifOperStatus;

    /*
     * WARNING - void declaration
     */
    public LinuxNetworkIF(NetworkInterface netint) throws InstantiationException {
        void var1_1;
        void v0 = var1_1;
        super((NetworkInterface)v0, LinuxNetworkIF.queryIfModel((NetworkInterface)v0));
        this.updateAttributes();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private static String queryIfModel(NetworkInterface netint) {
        Object object;
        Object name2222222222 = netint.getName();
        Udev.UdevContext udev = Udev.INSTANCE.udev_new();
        if (udev != null) {
            block7: {
                Udev.UdevDevice device;
                block8: {
                    String devModel;
                    block9: {
                        void var3_5;
                        device = udev.deviceNewFromSyspath("/sys/class/net/" + (String)name2222222222);
                        if (device == null) break block7;
                        String devVendor = device.getPropertyValue("ID_VENDOR_FROM_DATABASE");
                        devModel = device.getPropertyValue("ID_MODEL_FROM_DATABASE");
                        if (Util.isBlank(devModel)) break block8;
                        if (Util.isBlank(devVendor)) break block9;
                        name2222222222 = (String)var3_5 + " " + devModel;
                        device.unref();
                        udev.unref();
                        return name2222222222;
                    }
                    try {
                        name2222222222 = devModel;
                        device.unref();
                    }
                    catch (Throwable name2222222222) {
                        void var1_3;
                        var1_3.unref();
                        throw name2222222222;
                    }
                    udev.unref();
                    return name2222222222;
                }
                device.unref();
                break block7;
                {
                    catch (Throwable name2222222222) {
                        void var2_4;
                        var2_4.unref();
                        throw name2222222222;
                    }
                }
            }
            udev.unref();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static List<NetworkIF> getNetworks(boolean includeLocalInterfaces) {
        void var1_2;
        boolean bl;
        ArrayList<LinuxNetworkIF> ifList = new ArrayList<LinuxNetworkIF>();
        for (NetworkInterface ni : LinuxNetworkIF.getNetworkInterfaces(bl)) {
            try {
                ifList.add(new LinuxNetworkIF(ni));
            }
            catch (InstantiationException e) {
                void var2_4;
                LOG.debug("Network Interface Instantiation failed: {}", (Object)var2_4.getMessage());
            }
        }
        return var1_2;
    }

    @Override
    public final int getIfType() {
        return this.ifType;
    }

    @Override
    public final boolean isConnectorPresent() {
        return this.connectorPresent;
    }

    @Override
    public final long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public final long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public final long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public final long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public final long getInErrors() {
        return this.inErrors;
    }

    @Override
    public final long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public final long getInDrops() {
        return this.inDrops;
    }

    @Override
    public final long getCollisions() {
        return this.collisions;
    }

    @Override
    public final long getSpeed() {
        return this.speed;
    }

    @Override
    public final long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public final String getIfAlias() {
        return this.ifAlias;
    }

    @Override
    public final NetworkIF.IfOperStatus getIfOperStatus() {
        return this.ifOperStatus;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean updateAttributes() {
        void var3_3;
        void var2_2;
        File file;
        try {
            file = new File(String.format("/sys/class/net/%s/statistics", this.getName()));
            if (!file.isDirectory()) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        String ifTypePath = String.format("/sys/class/net/%s/type", this.getName());
        String carrierPath = String.format("/sys/class/net/%s/carrier", this.getName());
        String txBytesPath = String.format("/sys/class/net/%s/statistics/tx_bytes", this.getName());
        String rxBytesPath = String.format("/sys/class/net/%s/statistics/rx_bytes", this.getName());
        String txPacketsPath = String.format("/sys/class/net/%s/statistics/tx_packets", this.getName());
        String rxPacketsPath = String.format("/sys/class/net/%s/statistics/rx_packets", this.getName());
        String txErrorsPath = String.format("/sys/class/net/%s/statistics/tx_errors", this.getName());
        String rxErrorsPath = String.format("/sys/class/net/%s/statistics/rx_errors", this.getName());
        String collisionsPath = String.format("/sys/class/net/%s/statistics/collisions", this.getName());
        String rxDropsPath = String.format("/sys/class/net/%s/statistics/rx_dropped", this.getName());
        String ifSpeed = String.format("/sys/class/net/%s/speed", this.getName());
        String ifAliasPath = String.format("/sys/class/net/%s/ifalias", this.getName());
        String ifOperStatusPath = String.format("/sys/class/net/%s/operstate", this.getName());
        this.timeStamp = System.currentTimeMillis();
        this.ifType = FileUtil.getIntFromFile((String)((Object)file));
        this.connectorPresent = FileUtil.getIntFromFile((String)var2_2) > 0;
        this.bytesSent = FileUtil.getUnsignedLongFromFile((String)var3_3);
        this.bytesRecv = FileUtil.getUnsignedLongFromFile(rxBytesPath);
        this.packetsSent = FileUtil.getUnsignedLongFromFile(txPacketsPath);
        this.packetsRecv = FileUtil.getUnsignedLongFromFile(rxPacketsPath);
        this.outErrors = FileUtil.getUnsignedLongFromFile(txErrorsPath);
        this.inErrors = FileUtil.getUnsignedLongFromFile(rxErrorsPath);
        this.collisions = FileUtil.getUnsignedLongFromFile(collisionsPath);
        this.inDrops = FileUtil.getUnsignedLongFromFile(rxDropsPath);
        long speedMiB = FileUtil.getUnsignedLongFromFile(ifSpeed);
        this.speed = speedMiB < 0L ? 0L : speedMiB << 20;
        this.ifAlias = FileUtil.getStringFromFile(ifAliasPath);
        this.ifOperStatus = LinuxNetworkIF.parseIfOperStatus(FileUtil.getStringFromFile(ifOperStatusPath));
        return true;
    }

    private static NetworkIF.IfOperStatus parseIfOperStatus(String operState) {
        switch (operState) {
            case "up": {
                return NetworkIF.IfOperStatus.UP;
            }
            case "down": {
                return NetworkIF.IfOperStatus.DOWN;
            }
            case "testing": {
                return NetworkIF.IfOperStatus.TESTING;
            }
            case "dormant": {
                return NetworkIF.IfOperStatus.DORMANT;
            }
            case "notpresent": {
                return NetworkIF.IfOperStatus.NOT_PRESENT;
            }
            case "lowerlayerdown": {
                return NetworkIF.IfOperStatus.LOWER_LAYER_DOWN;
            }
        }
        return NetworkIF.IfOperStatus.UNKNOWN;
    }
}

