/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import com.sun.jna.platform.linux.Udev;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.hardware.common.AbstractHWDiskStore;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;

@ThreadSafe
public final class LinuxHWDiskStore
extends AbstractHWDiskStore {
    private static final String BLOCK = "block";
    private static final String DISK = "disk";
    private static final String PARTITION = "partition";
    private static final String STAT = "stat";
    private static final String SIZE = "size";
    private static final String MINOR = "MINOR";
    private static final String MAJOR = "MAJOR";
    private static final String ID_FS_TYPE = "ID_FS_TYPE";
    private static final String ID_FS_UUID = "ID_FS_UUID";
    private static final String ID_MODEL = "ID_MODEL";
    private static final String ID_SERIAL_SHORT = "ID_SERIAL_SHORT";
    private static final String DM_UUID = "DM_UUID";
    private static final String DM_VG_NAME = "DM_VG_NAME";
    private static final String DM_LV_NAME = "DM_LV_NAME";
    private static final String LOGICAL_VOLUME_GROUP = "Logical Volume Group";
    private static final String DEV_LOCATION = "/dev/";
    private static final String DEV_MAPPER = "/dev/mapper/";
    private static final int SECTORSIZE = 512;
    private static final int[] UDEV_STAT_ORDERS = new int[UdevStat.values().length];
    private static final int UDEV_STAT_LENGTH;
    private long reads = 0L;
    private long readBytes = 0L;
    private long writes = 0L;
    private long writeBytes = 0L;
    private long currentQueueLength = 0L;
    private long transferTime = 0L;
    private long timeStamp = 0L;
    private List<HWPartition> partitionList = new ArrayList<HWPartition>();

    /*
     * WARNING - void declaration
     */
    private LinuxHWDiskStore(String name, String model, String serial, long size) {
        super((String)var1_1, (String)var2_2, (String)var3_3, size);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public final long getReads() {
        return this.reads;
    }

    @Override
    public final long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public final long getWrites() {
        return this.writes;
    }

    @Override
    public final long getWriteBytes() {
        return this.writeBytes;
    }

    @Override
    public final long getCurrentQueueLength() {
        return this.currentQueueLength;
    }

    @Override
    public final long getTransferTime() {
        return this.transferTime;
    }

    @Override
    public final long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public final List<HWPartition> getPartitions() {
        return this.partitionList;
    }

    public static List<HWDiskStore> getDisks() {
        return LinuxHWDiskStore.getDisks(null);
    }

    /*
     * WARNING - void declaration
     */
    private static List<HWDiskStore> getDisks(LinuxHWDiskStore storeToUpdate) {
        void var2_5;
        AbstractHWDiskStore store = null;
        ArrayList<AbstractHWDiskStore> result = new ArrayList<AbstractHWDiskStore>();
        Map<String, String> mountsMap = LinuxHWDiskStore.readMountsMap();
        Udev.UdevContext udev = Udev.INSTANCE.udev_new();
        try {
            Udev.UdevEnumerate enumerate = udev.enumerateNew();
            try {
                void var6_10;
                enumerate.addMatchSubsystem(BLOCK);
                enumerate.scanDevices();
                Udev.UdevListEntry udevListEntry = enumerate.getListEntry();
                while (var6_10 != null) {
                    block18: {
                        String syspath = var6_10.getName();
                        Udev.UdevDevice device = udev.deviceNewFromSyspath(syspath);
                        if (device != null) {
                            try {
                                Udev.UdevDevice parent;
                                String devnode = device.getDevnode();
                                if (devnode == null || devnode.startsWith("/dev/loop") || devnode.startsWith("/dev/ram")) break block18;
                                if (DISK.equals(device.getDevtype())) {
                                    String lvName;
                                    String devModel = device.getPropertyValue(ID_MODEL);
                                    String devSerial = device.getPropertyValue(ID_SERIAL_SHORT);
                                    long devSize = ParseUtil.parseLongOrDefault(device.getSysattrValue(SIZE), 0L) << 9;
                                    if (devnode.startsWith("/dev/dm")) {
                                        devModel = LOGICAL_VOLUME_GROUP;
                                        devSerial = device.getPropertyValue(DM_UUID);
                                        store = new LinuxHWDiskStore(devnode, devModel, devSerial == null ? "unknown" : devSerial, devSize);
                                        String vgName = device.getPropertyValue(DM_VG_NAME);
                                        lvName = device.getPropertyValue(DM_LV_NAME);
                                        ((LinuxHWDiskStore)store).partitionList.add(new HWPartition(LinuxHWDiskStore.getPartitionNameForDmDevice(vgName, lvName), device.getSysname(), device.getPropertyValue(ID_FS_TYPE) == null ? PARTITION : device.getPropertyValue(ID_FS_TYPE), device.getPropertyValue(ID_FS_UUID) == null ? "" : device.getPropertyValue(ID_FS_UUID), ParseUtil.parseLongOrDefault(device.getSysattrValue(SIZE), 0L) << 9, ParseUtil.parseIntOrDefault(device.getPropertyValue(MAJOR), 0), ParseUtil.parseIntOrDefault(device.getPropertyValue(MINOR), 0), LinuxHWDiskStore.getMountPointOfDmDevice(vgName, lvName)));
                                    } else {
                                        void var8_15;
                                        store = new LinuxHWDiskStore((String)var8_15, lvName == null ? "unknown" : lvName, devSerial == null ? "unknown" : devSerial, devSize);
                                    }
                                    if (storeToUpdate == null) {
                                        LinuxHWDiskStore.computeDiskStats((LinuxHWDiskStore)store, device.getSysattrValue(STAT));
                                        result.add(store);
                                        break block18;
                                    }
                                    if (!store.getName().equals(storeToUpdate.getName()) || !store.getModel().equals(storeToUpdate.getModel()) || !store.getSerial().equals(storeToUpdate.getSerial()) || store.getSize() != storeToUpdate.getSize()) break block18;
                                    LinuxHWDiskStore.computeDiskStats(storeToUpdate, device.getSysattrValue(STAT));
                                    result.add(storeToUpdate);
                                    break;
                                }
                                if (storeToUpdate == null && store != null && PARTITION.equals(device.getDevtype()) && (parent = device.getParentWithSubsystemDevtype(BLOCK, DISK)) != null && store.getName().equals(parent.getDevnode())) {
                                    String name = device.getDevnode();
                                    ((LinuxHWDiskStore)store).partitionList.add(new HWPartition(name, device.getSysname(), device.getPropertyValue(ID_FS_TYPE) == null ? PARTITION : device.getPropertyValue(ID_FS_TYPE), device.getPropertyValue(ID_FS_UUID) == null ? "" : device.getPropertyValue(ID_FS_UUID), ParseUtil.parseLongOrDefault(device.getSysattrValue(SIZE), 0L) << 9, ParseUtil.parseIntOrDefault(device.getPropertyValue(MAJOR), 0), ParseUtil.parseIntOrDefault(device.getPropertyValue(MINOR), 0), mountsMap.getOrDefault(name, LinuxHWDiskStore.getDependentNamesFromHoldersDirectory(device.getSysname()))));
                                }
                            }
                            finally {
                                device.unref();
                            }
                        }
                    }
                    Udev.UdevListEntry udevListEntry2 = var6_10.getNext();
                }
            }
            finally {
                enumerate.unref();
            }
        }
        finally {
            udev.unref();
        }
        for (HWDiskStore hWDiskStore : result) {
            ((LinuxHWDiskStore)((HWDiskStore)var5_8.next())).partitionList = Collections.unmodifiableList(hWDiskStore.getPartitions().stream().sorted(Comparator.comparing(HWPartition::getName)).collect(Collectors.toList()));
        }
        return var2_5;
    }

    @Override
    public final boolean updateAttributes() {
        return !LinuxHWDiskStore.getDisks(this).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> readMountsMap() {
        void var0;
        HashMap<String, void> mountsMap = new HashMap<String, void>();
        Object object = FileUtil.readFile(ProcPath.MOUNTS);
        object = object.iterator();
        while (object.hasNext()) {
            void var2_2;
            String mount = (String)object.next();
            String[] split = ParseUtil.whitespaces.split(mount);
            if (split.length < 2 || !split[0].startsWith(DEV_LOCATION)) continue;
            mountsMap.put(split[0], var2_2[1]);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static void computeDiskStats(LinuxHWDiskStore store, String devstat) {
        void var1_1;
        long[] devstatArray = ParseUtil.parseStringToLongArray(devstat, UDEV_STAT_ORDERS, UDEV_STAT_LENGTH, ' ');
        store.timeStamp = System.currentTimeMillis();
        store.reads = devstatArray[UdevStat.READS.ordinal()];
        store.readBytes = devstatArray[UdevStat.READ_BYTES.ordinal()] << 9;
        store.writes = devstatArray[UdevStat.WRITES.ordinal()];
        store.writeBytes = devstatArray[UdevStat.WRITE_BYTES.ordinal()] << 9;
        store.currentQueueLength = devstatArray[UdevStat.QUEUE_LENGTH.ordinal()];
        var0.transferTime = var1_1[UdevStat.ACTIVE_MS.ordinal()];
    }

    /*
     * WARNING - void declaration
     */
    private static String getPartitionNameForDmDevice(String vgName, String lvName) {
        void var1_1;
        String string;
        return DEV_LOCATION + string + '/' + (String)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String getMountPointOfDmDevice(String vgName, String lvName) {
        void var1_1;
        String string;
        return DEV_MAPPER + string + '-' + (String)var1_1;
    }

    private static String getDependentNamesFromHoldersDirectory(String sysPath) {
        File[] holders = ((File)(sysPath = new File((String)sysPath + "/holders"))).listFiles();
        if (holders != null) {
            File[] fileArray;
            return Arrays.stream(fileArray).map(File::getName).collect(Collectors.joining(" "));
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    static {
        UdevStat[] udevStatArray = UdevStat.values();
        int n = udevStatArray.length;
        for (int i = 0; i < n; ++i) {
            void var3_3;
            UdevStat stat = udevStatArray[i];
            LinuxHWDiskStore.UDEV_STAT_ORDERS[stat.ordinal()] = var3_3.getOrder();
        }
        String stat = FileUtil.getStringFromFile(ProcPath.DISKSTATS);
        int statLength = 11;
        if (!stat.isEmpty()) {
            statLength = ParseUtil.countStringToLongArray((String)udevStatArray, ' ');
        }
        UDEV_STAT_LENGTH = n;
    }

    static enum UdevStat {
        READS(0),
        READ_BYTES(2),
        WRITES(4),
        WRITE_BYTES(6),
        QUEUE_LENGTH(8),
        ACTIVE_MS(9);

        private int order;

        public final int getOrder() {
            return this.order;
        }

        /*
         * WARNING - void declaration
         */
        private UdevStat(int order) {
            void var3_3;
            this.order = var3_3;
        }
    }
}

