/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.VirtualMemory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.hardware.platform.linux.LinuxVirtualMemory;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;
import oshi.util.tuples.Pair;

@ThreadSafe
public final class LinuxGlobalMemory
extends AbstractGlobalMemory {
    public static final long PAGE_SIZE = ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("getconf PAGE_SIZE"), 4096L);
    private final Supplier<Pair<Long, Long>> availTotal = Memoizer.memoize(LinuxGlobalMemory::readMemInfo, Memoizer.defaultExpiration());
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    @Override
    public final long getAvailable() {
        return this.availTotal.get().getA();
    }

    @Override
    public final long getTotal() {
        return this.availTotal.get().getB();
    }

    @Override
    public final long getPageSize() {
        return PAGE_SIZE;
    }

    @Override
    public final VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    /*
     * WARNING - void declaration
     */
    private static Pair<Long, Long> readMemInfo() {
        void var2_1;
        void var0;
        long memFree = 0L;
        long activeFile = 0L;
        long inactiveFile = 0L;
        long sReclaimable = 0L;
        long memTotal = 0L;
        Object object = FileUtil.readFile(ProcPath.MEMINFO);
        object = object.iterator();
        while (object.hasNext()) {
            String checkLine = (String)object.next();
            String[] memorySplit = ParseUtil.whitespaces.split(checkLine, 2);
            if (memorySplit.length > 1) {
                switch (memorySplit[0]) {
                    case "MemTotal:": {
                        memTotal = ParseUtil.parseDecimalMemorySizeToBinary(memorySplit[1]);
                        break;
                    }
                    case "MemAvailable:": {
                        long memAvailable = ParseUtil.parseDecimalMemorySizeToBinary(memorySplit[1]);
                        return new Pair<Long, Long>(memAvailable, memTotal);
                    }
                    case "MemFree:": {
                        memFree = ParseUtil.parseDecimalMemorySizeToBinary(memorySplit[1]);
                        break;
                    }
                    case "Active(file):": {
                        activeFile = ParseUtil.parseDecimalMemorySizeToBinary(memorySplit[1]);
                        break;
                    }
                    case "Inactive(file):": {
                        inactiveFile = ParseUtil.parseDecimalMemorySizeToBinary(memorySplit[1]);
                        break;
                    }
                    case "SReclaimable:": {
                        sReclaimable = ParseUtil.parseDecimalMemorySizeToBinary(memorySplit[1]);
                    }
                }
            }
        }
        return new Pair<Long, Long>((long)(var0 + var2_1 + inactiveFile + sReclaimable), memTotal);
    }

    private VirtualMemory createVirtualMemory() {
        return new LinuxVirtualMemory(this);
    }
}

