/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.function.Supplier;
import oshi.annotation.concurrent.Immutable;
import oshi.driver.linux.Sysfs;
import oshi.driver.linux.proc.CpuInfo;
import oshi.hardware.common.AbstractBaseboard;
import oshi.util.Memoizer;
import oshi.util.tuples.Quartet;

@Immutable
final class LinuxBaseboard
extends AbstractBaseboard {
    private final Supplier<String> manufacturer = Memoizer.memoize(this::queryManufacturer);
    private final Supplier<String> model = Memoizer.memoize(this::queryModel);
    private final Supplier<String> version = Memoizer.memoize(this::queryVersion);
    private final Supplier<String> serialNumber = Memoizer.memoize(this::querySerialNumber);
    private final Supplier<Quartet<String, String, String, String>> manufacturerModelVersionSerial = Memoizer.memoize(CpuInfo::queryBoardInfo);

    LinuxBaseboard() {
    }

    @Override
    public final String getManufacturer() {
        return this.manufacturer.get();
    }

    @Override
    public final String getModel() {
        return this.model.get();
    }

    @Override
    public final String getVersion() {
        return this.version.get();
    }

    @Override
    public final String getSerialNumber() {
        return this.serialNumber.get();
    }

    /*
     * WARNING - void declaration
     */
    private String queryManufacturer() {
        void var1_1;
        String result = Sysfs.queryBoardVendor();
        if (result == null && (result = this.manufacturerModelVersionSerial.get().getA()) == null) {
            return "unknown";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String queryModel() {
        void var1_1;
        String result = Sysfs.queryBoardModel();
        if (result == null && (result = this.manufacturerModelVersionSerial.get().getB()) == null) {
            return "unknown";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String queryVersion() {
        void var1_1;
        String result = Sysfs.queryBoardVersion();
        if (result == null && (result = this.manufacturerModelVersionSerial.get().getC()) == null) {
            return "unknown";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String querySerialNumber() {
        void var1_1;
        String result = Sysfs.queryBoardSerial();
        if (result == null && (result = this.manufacturerModelVersionSerial.get().getD()) == null) {
            return "unknown";
        }
        return var1_1;
    }
}

