/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import java.util.Collections;
import java.util.List;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.UsbDevice;

@Immutable
public abstract class AbstractUsbDevice
implements UsbDevice {
    private final String name;
    private final String vendor;
    private final String vendorId;
    private final String productId;
    private final String serialNumber;
    private final String uniqueDeviceId;
    private final List<UsbDevice> connectedDevices;

    /*
     * WARNING - void declaration
     */
    protected AbstractUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, String uniqueDeviceId, List<UsbDevice> connectedDevices) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.vendor = var2_2;
        this.vendorId = var3_3;
        this.productId = productId;
        this.serialNumber = serialNumber;
        this.uniqueDeviceId = uniqueDeviceId;
        this.connectedDevices = Collections.unmodifiableList(connectedDevices);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public String getVendorId() {
        return this.vendorId;
    }

    @Override
    public String getProductId() {
        return this.productId;
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public String getUniqueDeviceId() {
        return this.uniqueDeviceId;
    }

    @Override
    public List<UsbDevice> getConnectedDevices() {
        return this.connectedDevices;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(UsbDevice usb) {
        void var1_1;
        return this.getName().compareTo(var1_1.getName());
    }

    public String toString() {
        return AbstractUsbDevice.indentUsb(this, 1);
    }

    /*
     * WARNING - void declaration
     */
    private static String indentUsb(UsbDevice usbDevice, int indent) {
        void var2_2;
        Object object;
        String indentFmt = indent > 4 ? String.format("%%%ds|-- ", indent - 4) : String.format("%%%ds", indent);
        StringBuilder sb = new StringBuilder(String.format(indentFmt, ""));
        sb.append(usbDevice.getName());
        if (!usbDevice.getVendor().isEmpty()) {
            sb.append(" (").append(usbDevice.getVendor()).append(')');
        }
        if (!usbDevice.getSerialNumber().isEmpty()) {
            sb.append(" [s/n: ").append(usbDevice.getSerialNumber()).append(']');
        }
        for (UsbDevice connected : object.getConnectedDevices()) {
            void var3_3;
            sb.append('\n').append(AbstractUsbDevice.indentUsb((UsbDevice)var3_3, indent + 4));
        }
        return var2_2.toString();
    }
}

