/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.CentralProcessor;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;

@ThreadSafe
public abstract class AbstractCentralProcessor
implements CentralProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCentralProcessor.class);
    private final Supplier<CentralProcessor.ProcessorIdentifier> cpuid = Memoizer.memoize(this::queryProcessorId);
    private final Supplier<Long> maxFreq = Memoizer.memoize(this::queryMaxFreq, Memoizer.defaultExpiration());
    private final Supplier<long[]> currentFreq = Memoizer.memoize(this::queryCurrentFreq, Memoizer.defaultExpiration());
    private final Supplier<Long> contextSwitches = Memoizer.memoize(this::queryContextSwitches, Memoizer.defaultExpiration());
    private final Supplier<Long> interrupts = Memoizer.memoize(this::queryInterrupts, Memoizer.defaultExpiration());
    private final Supplier<long[]> systemCpuLoadTicks = Memoizer.memoize(this::querySystemCpuLoadTicks, Memoizer.defaultExpiration());
    private final Supplier<long[][]> processorCpuLoadTicks = Memoizer.memoize(this::queryProcessorCpuLoadTicks, Memoizer.defaultExpiration());
    private final int physicalPackageCount;
    private final int physicalProcessorCount;
    private final int logicalProcessorCount;
    private final List<CentralProcessor.LogicalProcessor> logicalProcessors = Collections.unmodifiableList(this.initProcessorCounts());

    /*
     * WARNING - void declaration
     */
    protected AbstractCentralProcessor() {
        void var2_2;
        void var1_1;
        HashSet<String> physProcPkgs = new HashSet<String>();
        HashSet<Integer> physPkgs = new HashSet<Integer>();
        for (CentralProcessor.LogicalProcessor logProc : this.logicalProcessors) {
            int pkg = logProc.getPhysicalPackageNumber();
            physProcPkgs.add(logProc.getPhysicalProcessorNumber() + ":" + pkg);
            physPkgs.add(pkg);
        }
        this.logicalProcessorCount = this.logicalProcessors.size();
        this.physicalProcessorCount = var1_1.size();
        this.physicalPackageCount = var2_2.size();
    }

    protected abstract List<CentralProcessor.LogicalProcessor> initProcessorCounts();

    protected abstract CentralProcessor.ProcessorIdentifier queryProcessorId();

    @Override
    public CentralProcessor.ProcessorIdentifier getProcessorIdentifier() {
        return this.cpuid.get();
    }

    @Override
    public long getMaxFreq() {
        return this.maxFreq.get();
    }

    protected abstract long queryMaxFreq();

    /*
     * WARNING - void declaration
     */
    @Override
    public long[] getCurrentFreq() {
        void var2_2;
        void var1_1;
        long[] freq = this.currentFreq.get();
        if (freq.length == this.getLogicalProcessorCount()) {
            return freq;
        }
        long[] freqs = new long[this.getLogicalProcessorCount()];
        Arrays.fill(freqs, (long)var1_1[0]);
        return var2_2;
    }

    protected abstract long[] queryCurrentFreq();

    @Override
    public long getContextSwitches() {
        return this.contextSwitches.get();
    }

    protected abstract long queryContextSwitches();

    @Override
    public long getInterrupts() {
        return this.interrupts.get();
    }

    protected abstract long queryInterrupts();

    @Override
    public List<CentralProcessor.LogicalProcessor> getLogicalProcessors() {
        return this.logicalProcessors;
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        return this.systemCpuLoadTicks.get();
    }

    protected abstract long[] querySystemCpuLoadTicks();

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        return this.processorCpuLoadTicks.get();
    }

    protected abstract long[][] queryProcessorCpuLoadTicks();

    /*
     * WARNING - void declaration
     */
    @Override
    public double getSystemCpuLoadBetweenTicks(long[] oldTicks) {
        void var1_1;
        void var2_2;
        if (oldTicks.length != CentralProcessor.TickType.values().length) {
            throw new IllegalArgumentException("Tick array " + oldTicks.length + " should have " + CentralProcessor.TickType.values().length + " elements");
        }
        long[] ticks = this.getSystemCpuLoadTicks();
        long total = 0L;
        for (int i = 0; i < ticks.length; ++i) {
            total += ticks[i] - oldTicks[i];
        }
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] + var2_2[CentralProcessor.TickType.IOWAIT.getIndex()] - oldTicks[CentralProcessor.TickType.IDLE.getIndex()] - var1_1[CentralProcessor.TickType.IOWAIT.getIndex()];
        LOG.trace("Total ticks: {}  Idle ticks: {}", (Object)total, (Object)idle);
        if (total > 0L && idle >= 0L) {
            void var3_3;
            return (double)(total - idle) / (double)var3_3;
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] getProcessorCpuLoadBetweenTicks(long[][] oldTicks) {
        void var3_3;
        if (oldTicks.length != this.logicalProcessorCount || oldTicks[0].length != CentralProcessor.TickType.values().length) {
            throw new IllegalArgumentException("Tick array " + oldTicks.length + " should have " + this.logicalProcessorCount + " arrays, each of which has " + CentralProcessor.TickType.values().length + " elements");
        }
        long[][] ticks = this.getProcessorCpuLoadTicks();
        double[] load = new double[this.logicalProcessorCount];
        for (int cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
            long total = 0L;
            for (int i = 0; i < ticks[cpu].length; ++i) {
                total += ticks[cpu][i] - oldTicks[cpu][i];
            }
            long idle = ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] + ticks[cpu][CentralProcessor.TickType.IOWAIT.getIndex()] - oldTicks[cpu][CentralProcessor.TickType.IDLE.getIndex()] - oldTicks[cpu][CentralProcessor.TickType.IOWAIT.getIndex()];
            LOG.trace("CPU: {}  Total ticks: {}  Idle ticks: {}", new Object[]{cpu, total, idle});
            load[cpu] = total > 0L && idle >= 0L ? (double)(total - idle) / (double)total : 0.0;
        }
        return var3_3;
    }

    @Override
    public int getLogicalProcessorCount() {
        return this.logicalProcessorCount;
    }

    @Override
    public int getPhysicalProcessorCount() {
        return this.physicalProcessorCount;
    }

    @Override
    public int getPhysicalPackageCount() {
        return this.physicalPackageCount;
    }

    /*
     * WARNING - void declaration
     */
    protected static String createProcessorID(String stepping, String model, String family, String[] flags) {
        void var2_3;
        void var1_1;
        long steppingL = ParseUtil.parseLongOrDefault(stepping, 0L);
        long modelL = ParseUtil.parseLongOrDefault((String)var1_1, 0L);
        long familyL = ParseUtil.parseLongOrDefault((String)var2_3, 0L);
        long l = 0L | steppingL & 0xFL;
        l |= (modelL & 0xFL) << 4;
        l |= (modelL & 0xF0L) << 16;
        long processorIdBytes = (l |= (familyL & 0xFL) << 8) | (familyL & 0xF0L) << 20;
        block64: for (String string : string) {
            int n = -1;
            switch (string.hashCode()) {
                case 101611: {
                    if (!string.equals("fpu")) break;
                    n = 0;
                    break;
                }
                case 116878: {
                    if (!string.equals("vme")) break;
                    n = 1;
                    break;
                }
                case 3201: {
                    if (!string.equals("de")) break;
                    n = 2;
                    break;
                }
                case 111298: {
                    if (!string.equals("pse")) break;
                    n = 3;
                    break;
                }
                case 115140: {
                    if (!string.equals("tsc")) break;
                    n = 4;
                    break;
                }
                case 108428: {
                    if (!string.equals("msr")) break;
                    n = 5;
                    break;
                }
                case 110740: {
                    if (!string.equals("pae")) break;
                    n = 6;
                    break;
                }
                case 107919: {
                    if (!string.equals("mce")) break;
                    n = 7;
                    break;
                }
                case 98915: {
                    if (!string.equals("cx8")) break;
                    n = 8;
                    break;
                }
                case 3000713: {
                    if (!string.equals("apic")) break;
                    n = 9;
                    break;
                }
                case 113758: {
                    if (!string.equals("sep")) break;
                    n = 10;
                    break;
                }
                case 3362343: {
                    if (!string.equals("mtrr")) break;
                    n = 11;
                    break;
                }
                case 110926: {
                    if (!string.equals("pge")) break;
                    n = 12;
                    break;
                }
                case 107915: {
                    if (!string.equals("mca")) break;
                    n = 13;
                    break;
                }
                case 3057617: {
                    if (!string.equals("cmov")) break;
                    n = 14;
                    break;
                }
                case 110755: {
                    if (!string.equals("pat")) break;
                    n = 15;
                    break;
                }
                case -979243698: {
                    if (!string.equals("pse-36")) break;
                    n = 16;
                    break;
                }
                case 111307: {
                    if (!string.equals("psn")) break;
                    n = 17;
                    break;
                }
                case 94747698: {
                    if (!string.equals("clfsh")) break;
                    n = 18;
                    break;
                }
                case 3215: {
                    if (!string.equals("ds")) break;
                    n = 19;
                    break;
                }
                case 2988443: {
                    if (!string.equals("acpi")) break;
                    n = 20;
                    break;
                }
                case 108248: {
                    if (!string.equals("mmx")) break;
                    n = 21;
                    break;
                }
                case 3157681: {
                    if (!string.equals("fxsr")) break;
                    n = 22;
                    break;
                }
                case 114181: {
                    if (!string.equals("sse")) break;
                    n = 23;
                    break;
                }
                case 3539661: {
                    if (!string.equals("sse2")) break;
                    n = 24;
                    break;
                }
                case 3680: {
                    if (!string.equals("ss")) break;
                    n = 25;
                    break;
                }
                case 103656: {
                    if (!string.equals("htt")) break;
                    n = 26;
                    break;
                }
                case 3705: {
                    if (!string.equals("tm")) break;
                    n = 27;
                    break;
                }
                case 3222998: {
                    if (!string.equals("ia64")) break;
                    n = 28;
                    break;
                }
                case 110771: {
                    if (!string.equals("pbe")) break;
                    n = 29;
                }
            }
            switch (n) {
                case 0: {
                    processorIdBytes |= 0x100000000L;
                    continue block64;
                }
                case 1: {
                    processorIdBytes |= 0x200000000L;
                    continue block64;
                }
                case 2: {
                    processorIdBytes |= 0x400000000L;
                    continue block64;
                }
                case 3: {
                    processorIdBytes |= 0x800000000L;
                    continue block64;
                }
                case 4: {
                    processorIdBytes |= 0x1000000000L;
                    continue block64;
                }
                case 5: {
                    processorIdBytes |= 0x2000000000L;
                    continue block64;
                }
                case 6: {
                    processorIdBytes |= 0x4000000000L;
                    continue block64;
                }
                case 7: {
                    processorIdBytes |= 0x8000000000L;
                    continue block64;
                }
                case 8: {
                    processorIdBytes |= 0x10000000000L;
                    continue block64;
                }
                case 9: {
                    processorIdBytes |= 0x20000000000L;
                    continue block64;
                }
                case 10: {
                    processorIdBytes |= 0x80000000000L;
                    continue block64;
                }
                case 11: {
                    processorIdBytes |= 0x100000000000L;
                    continue block64;
                }
                case 12: {
                    processorIdBytes |= 0x200000000000L;
                    continue block64;
                }
                case 13: {
                    processorIdBytes |= 0x400000000000L;
                    continue block64;
                }
                case 14: {
                    processorIdBytes |= 0x800000000000L;
                    continue block64;
                }
                case 15: {
                    processorIdBytes |= 0x1000000000000L;
                    continue block64;
                }
                case 16: {
                    processorIdBytes |= 0x2000000000000L;
                    continue block64;
                }
                case 17: {
                    processorIdBytes |= 0x4000000000000L;
                    continue block64;
                }
                case 18: {
                    processorIdBytes |= 0x8000000000000L;
                    continue block64;
                }
                case 19: {
                    processorIdBytes |= 0x20000000000000L;
                    continue block64;
                }
                case 20: {
                    processorIdBytes |= 0x40000000000000L;
                    continue block64;
                }
                case 21: {
                    processorIdBytes |= 0x80000000000000L;
                    continue block64;
                }
                case 22: {
                    processorIdBytes |= 0x100000000000000L;
                    continue block64;
                }
                case 23: {
                    processorIdBytes |= 0x200000000000000L;
                    continue block64;
                }
                case 24: {
                    processorIdBytes |= 0x400000000000000L;
                    continue block64;
                }
                case 25: {
                    processorIdBytes |= 0x800000000000000L;
                    continue block64;
                }
                case 26: {
                    processorIdBytes |= 0x1000000000000000L;
                    continue block64;
                }
                case 27: {
                    processorIdBytes |= 0x2000000000000000L;
                    continue block64;
                }
                case 28: {
                    processorIdBytes |= 0x4000000000000000L;
                    continue block64;
                }
                case 29: {
                    processorIdBytes |= Long.MIN_VALUE;
                }
            }
        }
        return String.format("%016X", processorIdBytes);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder(this.getProcessorIdentifier().getName());
        sb.append("\n ").append(this.getPhysicalPackageCount()).append(" physical CPU package(s)");
        sb.append("\n ").append(this.getPhysicalProcessorCount()).append(" physical CPU core(s)");
        sb.append("\n ").append(this.getLogicalProcessorCount()).append(" logical CPU(s)");
        sb.append('\n').append("Identifier: ").append(this.getProcessorIdentifier().getIdentifier());
        sb.append('\n').append("ProcessorID: ").append(this.getProcessorIdentifier().getProcessorID());
        sb.append('\n').append("Microarchitecture: ").append(this.getProcessorIdentifier().getMicroarchitecture());
        return var1_1.toString();
    }
}

