/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows.registry;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.Wtsapi32;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.Immutable;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.wmi.Win32Process;
import oshi.util.platform.windows.WmiUtil;

@ThreadSafe
public final class ProcessWtsData {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessWtsData.class);
    private static final boolean IS_WINDOWS7_OR_GREATER = VersionHelpers.IsWindows7OrGreater();

    private ProcessWtsData() {
    }

    public static Map<Integer, WtsInfo> queryProcessWtsMap(Collection<Integer> pids) {
        Collection<Integer> collection;
        if (IS_WINDOWS7_OR_GREATER) {
            return ProcessWtsData.queryProcessWtsMapFromWTS(pids);
        }
        return ProcessWtsData.queryProcessWtsMapFromPerfMon(collection);
    }

    /*
     * WARNING - void declaration
     */
    private static Map<Integer, WtsInfo> queryProcessWtsMapFromWTS(Collection<Integer> pids) {
        void var1_1;
        void var2_2;
        void var3_3;
        HashMap<Integer, WtsInfo> wtsMap = new HashMap<Integer, WtsInfo>();
        PointerByReference ppProcessInfo = new PointerByReference();
        IntByReference pCount = new IntByReference(0);
        if (!Wtsapi32.INSTANCE.WTSEnumerateProcessesEx(Wtsapi32.WTS_CURRENT_SERVER_HANDLE, new IntByReference(1), -2, ppProcessInfo, pCount)) {
            LOG.error("Failed to enumerate Processes. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return wtsMap;
        }
        Pointer pProcessInfo = ppProcessInfo.getValue();
        Wtsapi32.WTS_PROCESS_INFO_EX wTS_PROCESS_INFO_EX = new Wtsapi32.WTS_PROCESS_INFO_EX(pProcessInfo);
        Wtsapi32.WTS_PROCESS_INFO_EX[] processInfo = (Wtsapi32.WTS_PROCESS_INFO_EX[])wTS_PROCESS_INFO_EX.toArray(pCount.getValue());
        for (int i = 0; i < processInfo.length; ++i) {
            if (pids != null && !pids.contains(processInfo[i].ProcessId)) continue;
            wtsMap.put(processInfo[i].ProcessId, new WtsInfo(processInfo[i].pProcessName, "", processInfo[i].NumberOfThreads, (long)processInfo[i].PagefileUsage & 0xFFFFFFFFL, processInfo[i].KernelTime.getValue() / 10000L, processInfo[i].UserTime.getValue() / 10000L, processInfo[i].HandleCount));
        }
        if (!Wtsapi32.INSTANCE.WTSFreeMemoryEx(1, (Pointer)var3_3, var2_2.getValue())) {
            LOG.warn("Failed to Free Memory for Processes. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<Integer, WtsInfo> queryProcessWtsMapFromPerfMon(Collection<Integer> pids) {
        void var1_1;
        HashMap<Integer, WtsInfo> wtsMap = new HashMap<Integer, WtsInfo>();
        Collection<Integer> processWmiResult = Win32Process.queryProcesses(pids);
        for (int i = 0; i < processWmiResult.getResultCount(); ++i) {
            wtsMap.put(WmiUtil.getUint32(processWmiResult, Win32Process.ProcessXPProperty.PROCESSID, i), new WtsInfo(WmiUtil.getString(processWmiResult, Win32Process.ProcessXPProperty.NAME, i), WmiUtil.getString(processWmiResult, Win32Process.ProcessXPProperty.EXECUTABLEPATH, i), WmiUtil.getUint32(processWmiResult, Win32Process.ProcessXPProperty.THREADCOUNT, i), 1024L * ((long)WmiUtil.getUint32(processWmiResult, Win32Process.ProcessXPProperty.PAGEFILEUSAGE, i) & 0xFFFFFFFFL), WmiUtil.getUint64(processWmiResult, Win32Process.ProcessXPProperty.KERNELMODETIME, i) / 10000L, WmiUtil.getUint64(processWmiResult, Win32Process.ProcessXPProperty.USERMODETIME, i) / 10000L, WmiUtil.getUint32(processWmiResult, Win32Process.ProcessXPProperty.HANDLECOUNT, i)));
        }
        return var1_1;
    }

    @Immutable
    public static class WtsInfo {
        private final String name;
        private final String path;
        private final int threadCount;
        private final long virtualSize;
        private final long kernelTime;
        private final long userTime;
        private final long openFiles;

        /*
         * WARNING - void declaration
         */
        public WtsInfo(String name, String path, int threadCount, long virtualSize, long kernelTime, long userTime, long openFiles) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.path = var2_2;
            this.threadCount = var3_3;
            this.virtualSize = virtualSize;
            this.kernelTime = kernelTime;
            this.userTime = userTime;
            this.openFiles = openFiles;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public int getThreadCount() {
            return this.threadCount;
        }

        public long getVirtualSize() {
            return this.virtualSize;
        }

        public long getKernelTime() {
            return this.kernelTime;
        }

        public long getUserTime() {
            return this.userTime;
        }

        public long getOpenFiles() {
            return this.openFiles;
        }
    }
}

