/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.solaris;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.LibCAPI;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.solaris.SolarisLibc;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Quartet;

@ThreadSafe
public final class PsInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PsInfo.class);
    private static final boolean IS_LITTLE_ENDIAN = "little".equals(System.getProperty("sun.cpu.endian"));
    private static final SolarisLibc LIBC = SolarisLibc.INSTANCE;
    private static final long PAGE_SIZE = ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("pagesize"), 4096L);
    private static Map<LwpsInfoT, Integer> lwpsInfoOffsets = PsInfo.initLwpsOffsets();
    private static Map<PsInfoT, Integer> psInfoOffsets = PsInfo.initPsOffsets();

    private PsInfo() {
    }

    /*
     * WARNING - void declaration
     */
    private static Map<LwpsInfoT, Integer> initLwpsOffsets() {
        void var0;
        EnumMap<LwpsInfoT, Integer> infoMap = new EnumMap<LwpsInfoT, Integer>(LwpsInfoT.class);
        int offset = 0;
        for (LwpsInfoT field : LwpsInfoT.values()) {
            infoMap.put(field, offset);
            offset += field.size;
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<PsInfoT, Integer> initPsOffsets() {
        void var0;
        EnumMap<PsInfoT, Integer> infoMap = new EnumMap<PsInfoT, Integer>(PsInfoT.class);
        int offset = 0;
        for (PsInfoT field : PsInfoT.values()) {
            infoMap.put(field, offset);
            offset += field.size;
        }
        return var0;
    }

    /*
     * Exception decompiling
     */
    public static Quartet<Integer, Long, Long, Byte> queryArgsEnvAddrs(int pid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    public static Pair<List<String>, Map<String, String>> queryArgsEnv(int pid) {
        void var2_6;
        void var1_5;
        ArrayList<String> args = new ArrayList<String>();
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        Quartet<Integer, Long, Long, Byte> addrs = PsInfo.queryArgsEnvAddrs(pid);
        if (addrs != null) {
            String procas = "/proc/" + pid + "/as";
            int fd = LIBC.open(procas, 0);
            if (fd < 0) {
                LOG.trace("No permission to read file: {} ", (Object)procas);
                return new Pair<List<String>, Map<String, String>>(args, env);
            }
            try {
                long addr;
                int argc = addrs.getA();
                long argv = addrs.getB();
                long envp = addrs.getC();
                long increment = (long)addrs.getD().byteValue() << 2;
                long bufStart = 0L;
                Memory buffer = new Memory(PAGE_SIZE << 1);
                LibCAPI.size_t bufSize = new LibCAPI.size_t(buffer.size());
                long[] argp = new long[argc];
                long offset = argv;
                for (int i = 0; i < argc; ++i) {
                    argp[i] = (bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, bufStart, offset)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(buffer, offset - bufStart, increment);
                    offset += increment;
                }
                ArrayList<Long> envPtrList = new ArrayList<Long>();
                offset = envp;
                int limit = 500;
                do {
                    if ((addr = (bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, bufStart, offset)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(buffer, offset - bufStart, increment)) != 0L) {
                        envPtrList.add(addr);
                    }
                    offset += increment;
                } while (addr != 0L && --limit > 0);
                for (int i = 0; i < argp.length && argp[i] != 0L; ++i) {
                    String argStr;
                    if ((bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, bufStart, argp[i])) == 0L || (argStr = buffer.getString(argp[i] - bufStart)).isEmpty()) continue;
                    args.add(argStr);
                }
                for (Long envPtr : envPtrList) {
                    String envStr;
                    int idx;
                    if ((bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, bufStart, envPtr)) == 0L || (idx = (envStr = buffer.getString(envPtr - bufStart)).indexOf(61)) <= 0) continue;
                    env.put(envStr.substring(0, idx), envStr.substring(idx + 1));
                }
            }
            finally {
                LIBC.close(fd);
            }
        }
        return new Pair<void, void>(var1_5, var2_6);
    }

    /*
     * WARNING - void declaration
     */
    private static long conditionallyReadBufferFromStartOfPage(int fd, Memory buffer, LibCAPI.size_t bufSize, long bufStart, long addr) {
        void var3_4;
        if (addr < bufStart || addr - bufStart > PAGE_SIZE) {
            void var2_3;
            void var1_2;
            long newStart = Math.floorDiv(addr, PAGE_SIZE) * PAGE_SIZE;
            LibCAPI.ssize_t result = LIBC.pread(fd, (Pointer)var1_2, (LibCAPI.size_t)var2_3, new NativeLong(newStart));
            if (result.longValue() < PAGE_SIZE) {
                void var0_1;
                LOG.debug("Failed to read page from address space: {} bytes read", (Object)var0_1.longValue());
                return 0L;
            }
            return newStart;
        }
        return (long)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private static long getOffsetFromBuffer(Memory buffer, long offset, long increment) {
        void var1_1;
        Memory memory;
        if (increment == 8L) {
            return buffer.getLong(offset);
        }
        return memory.getInt((long)var1_1);
    }

    static /* synthetic */ Map access$000() {
        return lwpsInfoOffsets;
    }

    static enum LwpsInfoT {
        PR_FLAG(4),
        PR_LWPID(4),
        PR_ADDR(Native.POINTER_SIZE),
        PR_WCHAN(Native.POINTER_SIZE),
        PR_STYPE(1),
        PR_STATE(1),
        PR_SNAME(1),
        PR_NICE(1),
        PR_SYSCALL(2),
        PR_OLDPRI(1),
        PR_CPU(1),
        PR_PRI(4),
        PR_PCTCPU(2),
        PAD(2),
        PR_START(2 * NativeLong.SIZE),
        PR_TIME(2 * NativeLong.SIZE),
        PR_CLNAME(8),
        PR_NAME(16),
        PR_ONPRO(4),
        PR_BINDPRO(4),
        PR_BINDPSET(4),
        PR_LGRP(4),
        PR_LAST_ONPROC(8),
        SIZE(0);

        private final int size;

        /*
         * WARNING - void declaration
         */
        private LwpsInfoT(int bytes) {
            void var3_3;
            this.size = var3_3;
        }

        public final int size() {
            return this.size;
        }
    }

    static enum PsInfoT {
        PR_FLAG(4),
        PR_NLWP(4),
        PR_NZOMB(4),
        PR_PID(4),
        PR_PPID(4),
        PR_PGID(4),
        PR_SID(4),
        PR_UID(4),
        PR_EUID(4),
        PR_GID(4),
        PR_EGID(4),
        PAD1(Native.POINTER_SIZE - 4),
        PR_ADDR(Native.POINTER_SIZE),
        PR_SIZE(Native.SIZE_T_SIZE),
        PR_RSSIZE(Native.SIZE_T_SIZE),
        PR_TTYDEV(NativeLong.SIZE),
        PR_PCTCPU(2),
        PR_PCTMEM(2),
        PAD2(Native.POINTER_SIZE - 4),
        PR_START(2 * NativeLong.SIZE),
        PR_TIME(2 * NativeLong.SIZE),
        PR_CTIME(2 * NativeLong.SIZE),
        PR_FNAME(16),
        PR_PSARGS(80),
        PR_WSTAT(4),
        PR_ARGC(4),
        PR_ARGV(Native.POINTER_SIZE),
        PR_ENVP(Native.POINTER_SIZE),
        PR_DMODEL(1),
        PAD3(7),
        PR_LWP((Integer)PsInfo.access$000().get((Object)((Object)LwpsInfoT.SIZE))),
        PR_TASKID(4),
        PR_PROJID(4),
        PR_POOLID(4),
        PR_ZONEID(4),
        PR_CONTRACT(4),
        SIZE(0);

        private final int size;

        /*
         * WARNING - void declaration
         */
        private PsInfoT(int bytes) {
            void var3_3;
            this.size = var3_3;
        }

        public final int size() {
            return this.size;
        }
    }
}

