/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.freebsd.disk;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.freebsd.disk.Mount;
import oshi.hardware.HWPartition;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public final class GeomPartList {
    private static final String GEOM_PART_LIST = "geom part list";
    private static final String STAT_FILESIZE = "stat -f %i /dev/";

    private GeomPartList() {
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, List<HWPartition>> queryPartitions() {
        void var1_1;
        Map<String, String> mountMap = Mount.queryPartitionToMountMap();
        HashMap<Object, Object> partitionMap = new HashMap<Object, Object>();
        String diskName = null;
        List<Object> partList = new ArrayList<HWPartition>();
        String partName = null;
        String identification = "unknown";
        String type = "unknown";
        String uuid = "unknown";
        long size = 0L;
        String mountPoint = "";
        Object object = ExecutingCommand.runNative(GEOM_PART_LIST);
        object = object.iterator();
        while (object.hasNext()) {
            String[] split;
            String string = (String)object.next();
            String line = string.trim();
            if (line.startsWith("Geom name:")) {
                if (diskName != null && !partList.isEmpty()) {
                    partitionMap.put(diskName, partList);
                    partList = new ArrayList();
                }
                String string2 = line;
                diskName = string2.substring(string2.lastIndexOf(32) + 1);
            }
            if (diskName == null) continue;
            if (line.contains("Name:")) {
                if (partName != null) {
                    int minor = ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer(STAT_FILESIZE + partName), 0);
                    partList.add(new HWPartition(identification, partName, type, uuid, size, 0, minor, mountPoint));
                    partName = null;
                    identification = "unknown";
                    type = "unknown";
                    uuid = "unknown";
                    size = 0L;
                }
                String string3 = line;
                String part = string3.substring(string3.lastIndexOf(32) + 1);
                if (part.startsWith(diskName)) {
                    partName = part;
                    identification = part;
                    mountPoint = mountMap.getOrDefault(part, "");
                }
            }
            if (partName == null || (split = ParseUtil.whitespaces.split(line)).length < 2) continue;
            if (line.startsWith("Mediasize:")) {
                size = ParseUtil.parseLongOrDefault(split[1], 0L);
                continue;
            }
            if (line.startsWith("rawuuid:")) {
                uuid = split[1];
                continue;
            }
            if (!line.startsWith("type:")) continue;
            type = split[1];
        }
        if (diskName != null) {
            if (partName != null) {
                int minor = ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer(STAT_FILESIZE + partName), 0);
                partList.add(new HWPartition(identification, partName, type, uuid, size, 0, minor, mountPoint));
            }
            if (!partList.isEmpty()) {
                void var3_3;
                void var2_2;
                partList = partList.stream().sorted(Comparator.comparing(HWPartition::getName)).collect(Collectors.toList());
                partitionMap.put(var2_2, var3_3);
            }
        }
        return var1_1;
    }
}

