/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.freebsd.disk;

import java.util.HashMap;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.tuples.Triplet;

@ThreadSafe
public final class GeomDiskList {
    private static final String GEOM_DISK_LIST = "geom disk list";

    private GeomDiskList() {
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Triplet<String, String, Long>> queryDisks() {
        void var0;
        HashMap<Object, Triplet<Object, Object, Long>> diskMap = new HashMap<Object, Triplet<Object, Object, Long>>();
        String diskName = null;
        String descr = "unknown";
        String ident = "unknown";
        long mediaSize = 0L;
        Object object = ExecutingCommand.runNative(GEOM_DISK_LIST);
        object = object.iterator();
        while (object.hasNext()) {
            String[] split;
            String string = (String)object.next();
            String line = string.trim();
            if (line.startsWith("Geom name:")) {
                if (diskName != null) {
                    diskMap.put(diskName, new Triplet<String, String, Long>(descr, ident, mediaSize));
                    descr = "unknown";
                    ident = "unknown";
                    mediaSize = 0L;
                }
                String string2 = line;
                diskName = string2.substring(string2.lastIndexOf(32) + 1);
            }
            if (diskName == null) continue;
            if ((line = line.trim()).startsWith("Mediasize:") && (split = ParseUtil.whitespaces.split(line)).length > 1) {
                mediaSize = ParseUtil.parseLongOrDefault(split[1], 0L);
            }
            if (line.startsWith("descr:")) {
                descr = line.replace("descr:", "").trim();
            }
            if (!line.startsWith("ident:")) continue;
            ident = line.replace("ident:", "").replace("(null)", "").trim();
        }
        if (diskName != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            diskMap.put(var1_1, new Triplet<void, void, Long>(var2_2, var3_3, mediaSize));
        }
        return var0;
    }
}

