/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.aix;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.LibCAPI;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.aix.AixLibc;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
public final class PsInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PsInfo.class);
    private static final AixLibc LIBC = AixLibc.INSTANCE;
    private static final long PAGE_SIZE = 4096L;
    private static Map<LwpsInfoT, Integer> lwpsInfoOffsets = PsInfo.initLwpsOffsets();
    private static Map<PsInfoT, Integer> psInfoOffsets = PsInfo.initPsOffsets();

    private PsInfo() {
    }

    /*
     * WARNING - void declaration
     */
    private static Map<LwpsInfoT, Integer> initLwpsOffsets() {
        void var0;
        EnumMap<LwpsInfoT, Integer> infoMap = new EnumMap<LwpsInfoT, Integer>(LwpsInfoT.class);
        int offset = 0;
        for (LwpsInfoT field : LwpsInfoT.values()) {
            infoMap.put(field, offset);
            offset += field.size;
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<PsInfoT, Integer> initPsOffsets() {
        void var0;
        EnumMap<PsInfoT, Integer> infoMap = new EnumMap<PsInfoT, Integer>(PsInfoT.class);
        int offset = 0;
        for (PsInfoT field : PsInfoT.values()) {
            infoMap.put(field, offset);
            offset += field.size;
        }
        return var0;
    }

    /*
     * Exception decompiling
     */
    public static Triplet<Integer, Long, Long> queryArgsEnvAddrs(int pid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    public static Pair<List<String>, Map<String, String>> queryArgsEnv(int pid) {
        void var2_6;
        void var1_5;
        ArrayList<String> args = new ArrayList<String>();
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        Triplet<Integer, Long, Long> addrs = PsInfo.queryArgsEnvAddrs(pid);
        if (addrs != null) {
            String procas = "/proc/" + pid + "/as";
            int fd = LIBC.open(procas, 0);
            if (fd < 0) {
                LOG.trace("No permission to read file: {} ", (Object)procas);
                return new Pair<List<String>, Map<String, String>>(args, env);
            }
            try {
                long addr;
                int argc = addrs.getA();
                long argv = addrs.getB();
                long envp = addrs.getC();
                long increment = (envp - argv) / (long)(argc + 1);
                long bufStart = 0L;
                Memory buffer = new Memory(8192L);
                LibCAPI.size_t bufSize = new LibCAPI.size_t(buffer.size());
                long[] argp = new long[argc];
                long offset = argv;
                for (int i = 0; i < argc; ++i) {
                    argp[i] = (bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, bufStart, offset)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(buffer, offset - bufStart, increment);
                    offset += increment;
                }
                ArrayList<Long> envPtrList = new ArrayList<Long>();
                offset = envp;
                int limit = 500;
                do {
                    if ((addr = (bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, bufStart, offset)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(buffer, offset - bufStart, increment)) != 0L) {
                        envPtrList.add(addr);
                    }
                    offset += increment;
                } while (addr != 0L && --limit > 0);
                for (int i = 0; i < argp.length && argp[i] != 0L; ++i) {
                    String argStr;
                    if ((bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, bufStart, argp[i])) == 0L || (argStr = buffer.getString(argp[i] - bufStart)).isEmpty()) continue;
                    args.add(argStr);
                }
                for (Long envPtr : envPtrList) {
                    String envStr;
                    int idx;
                    if ((bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, bufStart, envPtr)) == 0L || (idx = (envStr = buffer.getString(envPtr - bufStart)).indexOf(61)) <= 0) continue;
                    env.put(envStr.substring(0, idx), envStr.substring(idx + 1));
                }
            }
            finally {
                LIBC.close(fd);
            }
        }
        return new Pair<void, void>(var1_5, var2_6);
    }

    /*
     * WARNING - void declaration
     */
    private static long conditionallyReadBufferFromStartOfPage(int fd, Memory buffer, LibCAPI.size_t bufSize, long bufStart, long addr) {
        void var3_4;
        if (addr < bufStart || addr - bufStart > 4096L) {
            void var2_3;
            void var1_2;
            long newStart = Math.floorDiv(addr, 4096L) << 12;
            LibCAPI.ssize_t result = LIBC.pread(fd, (Pointer)var1_2, (LibCAPI.size_t)var2_3, new NativeLong(newStart));
            if (result.longValue() < 4096L) {
                void var0_1;
                LOG.debug("Failed to read page from address space: {} bytes read", (Object)var0_1.longValue());
                return 0L;
            }
            return newStart;
        }
        return (long)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private static long getOffsetFromBuffer(Memory buffer, long offset, long increment) {
        void var1_1;
        Memory memory;
        if (increment == 8L) {
            return buffer.getLong(offset);
        }
        return memory.getInt((long)var1_1);
    }

    static /* synthetic */ Map access$000() {
        return lwpsInfoOffsets;
    }

    static enum LwpsInfoT {
        PR_LWPID(8),
        PR_ADDR(8),
        PR_WCHAN(8),
        PR_FLAG(4),
        PR_WTYPE(1),
        PR_STATE(1),
        PR_SNAME(1),
        PR_NICE(1),
        PR_PRI(4),
        PR_POLICY(4),
        PR_CLNAME(8),
        PR_ONPRO(Native.POINTER_SIZE),
        PR_BINDPRO(Native.POINTER_SIZE),
        SIZE(0);

        private final int size;

        /*
         * WARNING - void declaration
         */
        private LwpsInfoT(int bytes) {
            void var3_3;
            this.size = var3_3;
        }

        public final int size() {
            return this.size;
        }
    }

    static enum PsInfoT {
        PR_FLAG(4),
        PR_FLAG2(4),
        PR_NLWP(4),
        PR_PAD1(4),
        PR_UID(8),
        PR_EUID(8),
        PR_GID(8),
        PR_EGID(8),
        PR_PID(8),
        PR_PPID(8),
        PR_PGID(8),
        PR_SID(8),
        PR_TTYDEV(8),
        PR_ADDR(8),
        PR_SIZE(8),
        PR_RSSIZE(8),
        PR_START(16),
        PR_TIME(16),
        PR_CID(2),
        PR_PAD2(2),
        PR_ARGC(4),
        PR_ARGV(8),
        PR_ENVP(8),
        PR_FNAME(16),
        PR_PSARGS(80),
        PR_PAD(64),
        PR_LWP((Integer)PsInfo.access$000().get((Object)((Object)LwpsInfoT.SIZE))),
        SIZE(0);

        private final int size;

        /*
         * WARNING - void declaration
         */
        private PsInfoT(int bytes) {
            void var3_3;
            this.size = var3_3;
        }

        public final int size() {
            return this.size;
        }
    }
}

