/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.linux.proc;

import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.CentralProcessor;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;

@ThreadSafe
public final class CpuStat {
    private CpuStat() {
    }

    /*
     * WARNING - void declaration
     */
    public static long[] getSystemCpuLoadTicks() {
        void var0;
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        List<String> procStat = FileUtil.readFile(ProcPath.STAT);
        if (procStat.isEmpty()) {
            return ticks;
        }
        String tickStr = procStat.get(0);
        String[] tickArr = ParseUtil.whitespaces.split(tickStr);
        if (tickArr.length <= CentralProcessor.TickType.IDLE.getIndex()) {
            return ticks;
        }
        for (int i = 0; i < CentralProcessor.TickType.values().length; ++i) {
            ticks[i] = ParseUtil.parseLongOrDefault(tickArr[i + 1], 0L);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static long[][] getProcessorCpuLoadTicks(int logicalProcessorCount) {
        void var1_1;
        long[][] ticks = new long[logicalProcessorCount][CentralProcessor.TickType.values().length];
        int cpu = 0;
        Object object = FileUtil.readFile(ProcPath.STAT);
        object = object.iterator();
        while (object.hasNext()) {
            String stat = (String)object.next();
            if (!stat.startsWith("cpu") || stat.startsWith("cpu ")) continue;
            String[] tickArr = ParseUtil.whitespaces.split(stat);
            if (tickArr.length <= CentralProcessor.TickType.IDLE.getIndex()) {
                return ticks;
            }
            for (int i = 0; i < CentralProcessor.TickType.values().length; ++i) {
                ticks[cpu][i] = ParseUtil.parseLongOrDefault(tickArr[i + 1], 0L);
            }
            if (++cpu < logicalProcessorCount) continue;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long getContextSwitches() {
        Object object = FileUtil.readFile(ProcPath.STAT);
        object = object.iterator();
        while (object.hasNext()) {
            void var1_1;
            String[] ctxtArr;
            String stat = (String)object.next();
            if (!stat.startsWith("ctxt ") || (ctxtArr = ParseUtil.whitespaces.split(stat)).length != 2) continue;
            return ParseUtil.parseLongOrDefault((String)var1_1[1], 0L);
        }
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public static long getInterrupts() {
        Object object = FileUtil.readFile(ProcPath.STAT);
        object = object.iterator();
        while (object.hasNext()) {
            void var1_1;
            String[] intrArr;
            String stat = (String)object.next();
            if (!stat.startsWith("intr ") || (intrArr = ParseUtil.whitespaces.split(stat)).length <= 2) continue;
            return ParseUtil.parseLongOrDefault((String)var1_1[1], 0L);
        }
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public static long getBootTime() {
        String[] stringArray = FileUtil.readFile(ProcPath.STAT);
        stringArray = stringArray.iterator();
        while (stringArray.hasNext()) {
            void var1_1;
            String stat = (String)stringArray.next();
            if (!stat.startsWith("btime")) continue;
            stringArray = ParseUtil.whitespaces.split((CharSequence)var1_1);
            return ParseUtil.parseLongOrDefault(stringArray[1], 0L);
        }
        return 0L;
    }
}

