/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.linux;

import com.sun.jna.Native;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.linux.LinuxLibc;
import oshi.software.os.OSSession;
import oshi.util.ParseUtil;

@ThreadSafe
public final class Who {
    private static final LinuxLibc LIBC = LinuxLibc.INSTANCE;

    private Who() {
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized List<OSSession> queryUtxent() {
        void var0;
        ArrayList<OSSession> whoList = new ArrayList();
        LIBC.setutxent();
        try {
            LinuxLibc.LinuxUtmpx ut;
            while ((ut = LIBC.getutxent()) != null) {
                void var3_4;
                void var2_3;
                void var1_2;
                if (ut.ut_type != 7 && ut.ut_type != 6) continue;
                String user = Native.toString((byte[])ut.ut_user, (Charset)Charset.defaultCharset());
                String device = Native.toString((byte[])ut.ut_line, (Charset)Charset.defaultCharset());
                String host = ParseUtil.parseUtAddrV6toIP(ut.ut_addr_v6);
                long loginTime = (long)ut.ut_tv.tv_sec * 1000L + (long)var1_2.ut_tv.tv_usec / 1000L;
                if (user.isEmpty() || device.isEmpty() || loginTime < 0L || loginTime > System.currentTimeMillis()) {
                    whoList = oshi.driver.unix.Who.queryWho();
                    return whoList;
                }
                whoList.add(new OSSession((String)var2_3, (String)var3_4, loginTime, host));
            }
        }
        finally {
            LIBC.endutxent();
        }
        return var0;
    }
}

