/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.core;

import androidx.datastore.core.CorruptionException;
import androidx.datastore.core.okio.OkioSerializer;
import androidx.datastore.preferences.PreferencesMapCompat;
import androidx.datastore.preferences.PreferencesProto;
import androidx.datastore.preferences.core.MutablePreferences;
import androidx.datastore.preferences.core.Preferences;
import androidx.datastore.preferences.core.PreferencesFactory;
import androidx.datastore.preferences.core.PreferencesKeys;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.BufferedSource;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0004\b\u0013\u0010\u0014J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u00058\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e"}, d2={"Landroidx/datastore/preferences/core/PreferencesSerializer;", "Landroidx/datastore/core/okio/OkioSerializer;", "Landroidx/datastore/preferences/core/Preferences;", "<init>", "()V", "", "name", "Landroidx/datastore/preferences/PreferencesProto$Value;", "value", "Landroidx/datastore/preferences/core/MutablePreferences;", "mutablePreferences", "", "addProtoEntryToPreferences", "(Ljava/lang/String;Landroidx/datastore/preferences/PreferencesProto$Value;Landroidx/datastore/preferences/core/MutablePreferences;)V", "", "getValueProto", "(Ljava/lang/Object;)Landroidx/datastore/preferences/PreferencesProto$Value;", "Lokio/BufferedSource;", "source", "readFrom", "(Lokio/BufferedSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "t", "Lokio/BufferedSink;", "sink", "writeTo", "(Landroidx/datastore/preferences/core/Preferences;Lokio/BufferedSink;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDefaultValue", "()Landroidx/datastore/preferences/core/Preferences;", "defaultValue", "fileExtension", "Ljava/lang/String;"})
@SourceDebugExtension(value={"SMAP\nPreferencesSerializer.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreferencesSerializer.jvm.kt\nandroidx/datastore/preferences/core/PreferencesSerializer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,115:1\n215#2,2:116\n*S KotlinDebug\n*F\n+ 1 PreferencesSerializer.jvm.kt\nandroidx/datastore/preferences/core/PreferencesSerializer\n*L\n50#1:116,2\n*E\n"})
public final class PreferencesSerializer
implements OkioSerializer<Preferences> {
    public static final PreferencesSerializer INSTANCE = new PreferencesSerializer();
    public static final String fileExtension = "preferences_pb";

    private PreferencesSerializer() {
    }

    public final Preferences getDefaultValue() {
        return PreferencesFactory.createEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final Object readFrom(BufferedSource source, Continuation<? super Preferences> $completion) throws IOException, CorruptionException {
        void var2_2;
        Map map;
        PreferencesProto.PreferenceMap preferencesProto = PreferencesMapCompat.Companion.readFrom(source.inputStream());
        MutablePreferences mutablePreferences = PreferencesFactory.createMutable(new Preferences.Pair[0]);
        Map map2 = map.getPreferencesMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"preferencesProto.preferencesMap");
        map = map2;
        for (Map.Entry entry : map2.entrySet()) {
            Map.Entry entry2 = entry;
            entry2 = entry;
            String name = (String)entry.getKey();
            PreferencesProto.Value value = (PreferencesProto.Value)entry2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            INSTANCE.addProtoEntryToPreferences(name, (PreferencesProto.Value)entry2, mutablePreferences);
        }
        return var2_2.toPreferences();
    }

    /*
     * WARNING - void declaration
     */
    public final Object writeTo(Preferences t, BufferedSink sink, Continuation<? super Unit> $completion) throws IOException, CorruptionException {
        void var2_2;
        void var3_3;
        Iterator iterator;
        Map<Preferences.Key<?>, Object> preferences = t.asMap();
        PreferencesProto.PreferenceMap.Builder protoBuilder = PreferencesProto.PreferenceMap.newBuilder();
        for (Map.Entry entry : iterator.entrySet()) {
            Preferences.Key key = (Preferences.Key)entry.getKey();
            Object value = entry.getValue();
            protoBuilder.putPreferences(key.getName(), this.getValueProto(value));
        }
        ((PreferencesProto.PreferenceMap)var3_3.build()).writeTo(var2_2.outputStream());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final PreferencesProto.Value getValueProto(Object value) {
        void var1_1;
        Object object = value;
        if (object instanceof Boolean) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setBoolean(((Boolean)value).booleanValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"newBuilder().setBoolean(value).build()");
            return (PreferencesProto.Value)generatedMessageLite;
        }
        if (object instanceof Float) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setFloat(((Number)value).floatValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"newBuilder().setFloat(value).build()");
            return (PreferencesProto.Value)generatedMessageLite;
        }
        if (object instanceof Double) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setDouble(((Number)value).doubleValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"newBuilder().setDouble(value).build()");
            return (PreferencesProto.Value)generatedMessageLite;
        }
        if (object instanceof Integer) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setInteger(((Number)value).intValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"newBuilder().setInteger(value).build()");
            return (PreferencesProto.Value)generatedMessageLite;
        }
        if (object instanceof Long) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setLong(((Number)value).longValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"newBuilder().setLong(value).build()");
            return (PreferencesProto.Value)generatedMessageLite;
        }
        if (object instanceof String) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setString((String)value).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"newBuilder().setString(value).build()");
            return (PreferencesProto.Value)generatedMessageLite;
        }
        if (object instanceof Set) {
            PreferencesProto.Value.Builder builder = PreferencesProto.Value.newBuilder();
            PreferencesProto.StringSet.Builder builder2 = PreferencesProto.StringSet.newBuilder();
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.Set<kotlin.String>");
            value = builder.setStringSet(builder2.addAllStrings((Iterable)((Set)value))).build();
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"newBuilder().setStringSe\u2026                ).build()");
            return (PreferencesProto.Value)value;
        }
        if (object instanceof byte[]) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setBytes(ByteString.copyFrom((byte[])((byte[])value))).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"newBuilder().setBytes(By\u2026.copyFrom(value)).build()");
            return (PreferencesProto.Value)generatedMessageLite;
        }
        throw new IllegalStateException("PreferencesSerializer does not support type: " + var1_1.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    private final void addProtoEntryToPreferences(String name, PreferencesProto.Value value, MutablePreferences mutablePreferences) {
        PreferencesProto.Value.ValueCase valueCase = value.getValueCase();
        switch (valueCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[valueCase.ordinal()]) {
            case 1: {
                mutablePreferences.set(PreferencesKeys.booleanKey(name), value.getBoolean());
                return;
            }
            case 2: {
                mutablePreferences.set(PreferencesKeys.floatKey(name), Float.valueOf(value.getFloat()));
                return;
            }
            case 3: {
                mutablePreferences.set(PreferencesKeys.doubleKey(name), value.getDouble());
                return;
            }
            case 4: {
                mutablePreferences.set(PreferencesKeys.intKey(name), value.getInteger());
                return;
            }
            case 5: {
                mutablePreferences.set(PreferencesKeys.longKey(name), value.getLong());
                return;
            }
            case 6: {
                Preferences.Key<String> key = PreferencesKeys.stringKey(name);
                String string = value.getString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.string");
                mutablePreferences.set(key, string);
                return;
            }
            case 7: {
                Preferences.Key<Set<String>> key = PreferencesKeys.stringSetKey(name);
                List list = value.getStringSet().getStringsList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"value.stringSet.stringsList");
                mutablePreferences.set(key, CollectionsKt.toSet((Iterable)list));
                return;
            }
            case 8: {
                void var3_3;
                void var2_2;
                void var1_1;
                Preferences.Key<byte[]> key = PreferencesKeys.byteArrayKey((String)var1_1);
                byte[] byArray = var2_2.getBytes().toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.bytes.toByteArray()");
                var3_3.set(key, byArray);
                return;
            }
            case 9: {
                throw new CorruptionException("Value not set.", null, 2, null);
            }
            case -1: {
                throw new CorruptionException("Value case is null.", null, 2, null);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PreferencesProto.Value.ValueCase.values().length];
            try {
                nArray[PreferencesProto.Value.ValueCase.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PreferencesProto.Value.ValueCase.FLOAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PreferencesProto.Value.ValueCase.DOUBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PreferencesProto.Value.ValueCase.INTEGER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PreferencesProto.Value.ValueCase.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PreferencesProto.Value.ValueCase.STRING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PreferencesProto.Value.ValueCase.STRING_SET.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PreferencesProto.Value.ValueCase.BYTES.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PreferencesProto.Value.ValueCase.VALUE_NOT_SET.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

