/*
 * Decompiled with CFR 0.152.
 */
package me.him188.ani.app.ui.settings.mediasource;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.him188.ani.app.domain.mediasource.codec.ExportedMediaSourceData;
import me.him188.ani.app.domain.mediasource.codec.ExportedMediaSourceDataList;
import me.him188.ani.app.domain.mediasource.codec.FactoryNotFoundException;
import me.him188.ani.app.domain.mediasource.codec.InvalidMediaSourceContentException;
import me.him188.ani.app.domain.mediasource.codec.MediaSourceArguments;
import me.him188.ani.app.domain.mediasource.codec.MediaSourceCodecManager;
import me.him188.ani.app.domain.mediasource.codec.MediaSourceCodecManagerKt;
import me.him188.ani.app.domain.mediasource.codec.MediaSourceDecodeException;
import me.him188.ani.app.domain.mediasource.codec.UnsupportedVersionException;
import me.him188.ani.app.ui.settings.mediasource.ParseResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003B#\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0013R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0014R/\u0010\u001d\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00158@@BX\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001d\u0010#\u001a\u0004\u0018\u00010\u001e8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001b\u0010(\u001a\u00020$8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010 \u001a\u0004\b&\u0010'"}, d2={"Lme/him188/ani/app/ui/settings/mediasource/ImportMediaSourceState;", "Lme/him188/ani/app/domain/mediasource/codec/MediaSourceArguments;", "T", "", "Lme/him188/ani/app/domain/mediasource/codec/MediaSourceCodecManager;", "codecManager", "Lkotlin/Function1;", "", "onImport", "<init>", "(Lme/him188/ani/app/domain/mediasource/codec/MediaSourceCodecManager;Lkotlin/jvm/functions/Function1;)V", "", "string", "parseContent", "(Ljava/lang/String;)V", "cancelOverride", "()V", "dismissError", "confirmImport", "Lme/him188/ani/app/domain/mediasource/codec/MediaSourceCodecManager;", "Lkotlin/jvm/functions/Function1;", "Lme/him188/ani/app/ui/settings/mediasource/ParseResult;", "<set-?>", "parseResult$delegate", "Landroidx/compose/runtime/MutableState;", "getParseResult$ui_settings", "()Lme/him188/ani/app/ui/settings/mediasource/ParseResult;", "setParseResult", "(Lme/him188/ani/app/ui/settings/mediasource/ParseResult;)V", "parseResult", "Lme/him188/ani/app/ui/settings/mediasource/ParseResult$Error;", "error$delegate", "Landroidx/compose/runtime/State;", "getError$ui_settings", "()Lme/him188/ani/app/ui/settings/mediasource/ParseResult$Error;", "error", "", "showOverrideDialog$delegate", "getShowOverrideDialog$ui_settings", "()Z", "showOverrideDialog"})
@SourceDebugExtension(value={"SMAP\nMediaSourceConfigurationDefaults.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaSourceConfigurationDefaults.kt\nme/him188/ani/app/ui/settings/mediasource/ImportMediaSourceState\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,304:1\n85#2:305\n117#2,2:306\n85#2:308\n85#2:309\n*S KotlinDebug\n*F\n+ 1 MediaSourceConfigurationDefaults.kt\nme/him188/ani/app/ui/settings/mediasource/ImportMediaSourceState\n*L\n73#1:305\n73#1:306,2\n76#1:308\n79#1:309\n*E\n"})
public final class ImportMediaSourceState<T extends MediaSourceArguments> {
    private final MediaSourceCodecManager codecManager;
    private final Function1<T, Unit> onImport;
    private final MutableState parseResult$delegate;
    private final State error$delegate;
    private final State showOverrideDialog$delegate;
    public static final int $stable = MediaSourceCodecManager.$stable;

    /*
     * WARNING - void declaration
     */
    public ImportMediaSourceState(MediaSourceCodecManager codecManager, Function1<? super T, Unit> onImport) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)codecManager, (String)"codecManager");
        Intrinsics.checkNotNullParameter(onImport, (String)"onImport");
        this.codecManager = var1_1;
        this.onImport = var2_2;
        this.parseResult$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
        this.error$delegate = SnapshotStateKt.derivedStateOf(() -> ImportMediaSourceState.error_delegate$lambda$0(this));
        this.showOverrideDialog$delegate = SnapshotStateKt.derivedStateOf(() -> ImportMediaSourceState.showOverrideDialog_delegate$lambda$0(this));
    }

    public final ParseResult getParseResult$ui_settings() {
        State state2 = (State)this.parseResult$delegate;
        return (ParseResult)state2.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setParseResult(ParseResult parseResult) {
        void var1_1;
        MutableState mutableState = this.parseResult$delegate;
        mutableState.setValue((Object)var1_1);
    }

    public final ParseResult.Error getError$ui_settings() {
        State state2 = this.error$delegate;
        return (ParseResult.Error)state2.getValue();
    }

    public final boolean getShowOverrideDialog$ui_settings() {
        State state2 = this.showOverrideDialog$delegate;
        return (Boolean)state2.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void parseContent(String string2) {
        void var1_1;
        CharSequence charSequence = string2;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.setParseResult(ParseResult.EmptyContent.INSTANCE);
            return;
        }
        ExportedMediaSourceDataList list = MediaSourceCodecManagerKt.decodeFromStringOrNull((MediaSourceCodecManager)this.codecManager, (String)string2);
        if (list == null) {
            this.setParseResult(ParseResult.InvalidContent.INSTANCE);
            return;
        }
        if (list.getMediaSources().isEmpty()) {
            this.setParseResult(ParseResult.EmptyContent.INSTANCE);
            return;
        }
        if (list.getMediaSources().size() > 1) {
            this.setParseResult(ParseResult.HasMoreThanOneArgument.INSTANCE);
            return;
        }
        ExportedMediaSourceData data = (ExportedMediaSourceData)CollectionsKt.single((List)charSequence.getMediaSources());
        try {
            data = this.codecManager.decode(data);
        }
        catch (MediaSourceDecodeException e) {
            ParseResult.Error error;
            e = e;
            if (e instanceof UnsupportedVersionException) {
                error = ParseResult.UnsupportedVersion.INSTANCE;
            } else if (e instanceof FactoryNotFoundException) {
                error = ParseResult.UnsupportedFactory.INSTANCE;
            } else if (e instanceof InvalidMediaSourceContentException) {
                error = ParseResult.InvalidContent.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            this.setParseResult(error);
            return;
        }
        this.setParseResult(new ParseResult.Success<void>(var1_1));
    }

    public final void cancelOverride() {
        this.setParseResult(null);
    }

    public final void dismissError() {
        this.setParseResult(null);
    }

    public final void confirmImport() {
        ParseResult parseResult = this.getParseResult$ui_settings();
        ParseResult.Success success = parseResult instanceof ParseResult.Success ? (ParseResult.Success)parseResult : null;
        if (success != null) {
            ParseResult.Success it = success;
            Object t = ((ParseResult.Success)parseResult).getArgument();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type T of me.him188.ani.app.ui.settings.mediasource.ImportMediaSourceState");
            this.onImport.invoke((Object)((MediaSourceArguments)t));
        }
        this.setParseResult(null);
    }

    private static final ParseResult.Error error_delegate$lambda$0(ImportMediaSourceState this$0) {
        ParseResult parseResult = this$0.getParseResult$ui_settings();
        if (parseResult instanceof ParseResult.Error) {
            return (ParseResult.Error)parseResult;
        }
        return null;
    }

    private static final boolean showOverrideDialog_delegate$lambda$0(ImportMediaSourceState this$0) {
        return this$0.getParseResult$ui_settings() instanceof ParseResult.Success;
    }
}

