/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.lang.annotation.Annotation;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SealedClassSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.internal.JsonInternalDependenciesKt;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonClassDiscriminator;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonEncodingException;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.TreeJsonDecoderKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\u001ak\u0010\r\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u0000*\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0004\u001a\u00028\u000026\u0010\f\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a/\u0010\u0011\u001a\u00020\u000b2\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u0017\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a9\u0010\u001c\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u0000*\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a\u001b\u0010\u0010\u001a\u00020\u0006*\u00020\u001e2\u0006\u0010 \u001a\u00020\u001fH\u0000\u00a2\u0006\u0004\b\u0010\u0010!\u001a!\u0010%\u001a\u00020$2\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010#\u001a\u00020\"H\u0000\u00a2\u0006\u0004\b%\u0010&\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"T", "Lkotlinx/serialization/json/JsonEncoder;", "Lkotlinx/serialization/SerializationStrategy;", "serializer", "value", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "discriminatorName", "serialName", "", "ifPolymorphic", "encodePolymorphically", "(Lkotlinx/serialization/json/JsonEncoder;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "actualSerializer", "classDiscriminator", "validateIfSealed", "(Lkotlinx/serialization/SerializationStrategy;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/String;)V", "Lkotlinx/serialization/descriptors/SerialKind;", "kind", "checkKind", "(Lkotlinx/serialization/descriptors/SerialKind;)V", "Lkotlinx/serialization/json/JsonDecoder;", "Lkotlinx/serialization/DeserializationStrategy;", "deserializer", "Lkotlin/Function0;", "path", "decodeSerializableValuePolymorphic", "(Lkotlinx/serialization/json/JsonDecoder;Lkotlinx/serialization/DeserializationStrategy;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "Lkotlinx/serialization/json/Json;", "json", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/json/Json;)Ljava/lang/String;", "Lkotlinx/serialization/json/JsonElement;", "element", "", "throwJsonElementPolymorphicException", "(Ljava/lang/String;Lkotlinx/serialization/json/JsonElement;)Ljava/lang/Void;"})
@SourceDebugExtension(value={"SMAP\nPolymorphic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Polymorphic.kt\nkotlinx/serialization/json/internal/PolymorphicKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TreeJsonEncoder.kt\nkotlinx/serialization/json/internal/TreeJsonEncoderKt\n*L\n1#1,109:1\n1#2:110\n270#3,8:111\n*S KotlinDebug\n*F\n+ 1 Polymorphic.kt\nkotlinx/serialization/json/internal/PolymorphicKt\n*L\n83#1:111,8\n*E\n"})
public final class PolymorphicKt {
    /*
     * WARNING - void declaration
     */
    public static final <T> void encodePolymorphically(JsonEncoder $this$encodePolymorphically, SerializationStrategy<? super T> serializer, T value, Function2<? super String, ? super String, Unit> ifPolymorphic) {
        void var2_2;
        JsonEncoder jsonEncoder;
        void var1_1;
        void actualSerializer;
        SerializationStrategy serializationStrategy;
        String baseClassDiscriminator;
        Object it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$encodePolymorphically, (String)"<this>");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(ifPolymorphic, (String)"ifPolymorphic");
        if ($this$encodePolymorphically.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serializer.serialize((Encoder)$this$encodePolymorphically, value);
            return;
        }
        boolean isPolymorphicSerializer = serializer instanceof AbstractPolymorphicSerializer;
        if (isPolymorphicSerializer) {
            bl = $this$encodePolymorphically.getJson().getConfiguration().getClassDiscriminatorMode() != ClassDiscriminatorMode.NONE;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[$this$encodePolymorphically.getJson().getConfiguration().getClassDiscriminatorMode().ordinal()]) {
                case 1: 
                case 2: {
                    bl = false;
                    break;
                }
                case 3: {
                    it = serializer.getDescriptor().getKind();
                    if (Intrinsics.areEqual((Object)it, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)it, (Object)StructureKind.OBJECT.INSTANCE)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        boolean bl2 = bl;
        String string = baseClassDiscriminator = bl ? PolymorphicKt.classDiscriminator(serializer.getDescriptor(), $this$encodePolymorphically.getJson()) : null;
        if (isPolymorphicSerializer) {
            AbstractPolymorphicSerializer casted = (AbstractPolymorphicSerializer)serializer;
            if (value == null) {
                it = "Value for serializer " + ((AbstractPolymorphicSerializer)serializer).getDescriptor() + " should always be non-null. Please report issue to the kotlinx.serialization tracker.";
                throw new IllegalArgumentException(it.toString());
            }
            SerializationStrategy actual = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)casted, (Encoder)$this$encodePolymorphically, value);
            if (baseClassDiscriminator != null) {
                PolymorphicKt.access$validateIfSealed(serializer, actual, baseClassDiscriminator);
                PolymorphicKt.checkKind(actual.getDescriptor().getKind());
            }
            Intrinsics.checkNotNull((Object)actual, (String)"null cannot be cast to non-null type kotlinx.serialization.SerializationStrategy<T of kotlinx.serialization.json.internal.PolymorphicKt.encodePolymorphically>");
            serializationStrategy = actual;
        } else {
            serializationStrategy = actualSerializer = actualSerializer;
        }
        if (baseClassDiscriminator != null) {
            void var3_3;
            var3_3.invoke((Object)baseClassDiscriminator, (Object)actualSerializer.getDescriptor().getSerialName());
        }
        var1_1.serialize((Encoder)jsonEncoder, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void validateIfSealed(SerializationStrategy<?> serializer, SerializationStrategy<?> actualSerializer, String classDiscriminator) {
        if (!(serializer instanceof SealedClassSerializer)) {
            return;
        }
        if (JsonInternalDependenciesKt.jsonCachedSerialNames((SerialDescriptor)actualSerializer.getDescriptor()).contains(classDiscriminator)) {
            void var2_2;
            Object object;
            void var1_1;
            Object baseName = ((SealedClassSerializer)serializer).getDescriptor().getSerialName();
            String actualName = actualSerializer.getDescriptor().getSerialName();
            throw new IllegalStateException(("Sealed class '" + (String)var1_1 + "' cannot be serialized as base class '" + object + "' because it has property name that conflicts with JSON class discriminator '" + (String)var2_2 + "'. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism").toString());
        }
    }

    public static final void checkKind(SerialKind kind) {
        SerialKind serialKind;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (kind instanceof SerialKind.ENUM) {
            throw new IllegalStateException("Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (kind instanceof PrimitiveKind) {
            throw new IllegalStateException("Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (serialKind instanceof PolymorphicKind) {
            throw new IllegalStateException("Actual serializer for polymorphic cannot be polymorphic itself".toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T decodeSerializableValuePolymorphic(JsonDecoder $this$decodeSerializableValuePolymorphic, DeserializationStrategy<? extends T> deserializer, Function0<String> path) {
        void var2_3;
        void var3_4;
        JsonDecoder jsonDecoder;
        DeserializationStrategy deserializationStrategy;
        void value$iv;
        Intrinsics.checkNotNullParameter((Object)$this$decodeSerializableValuePolymorphic, (String)"<this>");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        if (!(deserializer instanceof AbstractPolymorphicSerializer) || $this$decodeSerializableValuePolymorphic.getJson().getConfiguration().getUseArrayPolymorphism()) {
            return (T)deserializer.deserialize((Decoder)$this$decodeSerializableValuePolymorphic);
        }
        String discriminator = PolymorphicKt.classDiscriminator(((AbstractPolymorphicSerializer)deserializer).getDescriptor(), $this$decodeSerializableValuePolymorphic.getJson());
        JsonElement jsonElement = $this$decodeSerializableValuePolymorphic.decodeJsonElement();
        String serialName$iv = ((AbstractPolymorphicSerializer)deserializer).getDescriptor().getSerialName();
        if (!(value$iv instanceof JsonObject)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName() + ", but had " + Reflection.getOrCreateKotlinClass(value$iv.getClass()).getSimpleName() + " as the serialized body of " + serialName$iv + " at element: " + (String)path.invoke(), value$iv.toString());
        }
        JsonObject jsonTree = (JsonObject)value$iv;
        JsonElement jsonElement2 = (JsonElement)jsonTree.get((Object)discriminator);
        String type = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive(jsonElement2)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement2) : null;
        try {
            deserializationStrategy = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)((AbstractPolymorphicSerializer)deserializationStrategy), (CompositeDecoder)$this$decodeSerializableValuePolymorphic, (String)type);
        }
        catch (SerializationException it) {
            void var0_1;
            String string = var0_1.getMessage();
            Intrinsics.checkNotNull((Object)string);
            throw JsonExceptionsKt.JsonDecodingException(-1, string, jsonTree.toString());
        }
        Intrinsics.checkNotNull((Object)deserializationStrategy, (String)"null cannot be cast to non-null type kotlinx.serialization.DeserializationStrategy<T of kotlinx.serialization.json.internal.PolymorphicKt.decodeSerializableValuePolymorphic>");
        DeserializationStrategy actualSerializer = deserializationStrategy;
        return TreeJsonDecoderKt.readPolymorphicJson(jsonDecoder.getJson(), (String)var3_4, (JsonObject)var2_3, actualSerializer);
    }

    /*
     * WARNING - void declaration
     */
    public static final String classDiscriminator(SerialDescriptor $this$classDiscriminator, Json json) {
        void var1_1;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$classDiscriminator, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        for (Annotation annotation : object.getAnnotations()) {
            void var2_2;
            if (!(annotation instanceof JsonClassDiscriminator)) continue;
            return ((JsonClassDiscriminator)var2_2).discriminator();
        }
        return var1_1.getConfiguration().getClassDiscriminator();
    }

    /*
     * WARNING - void declaration
     */
    public static final Void throwJsonElementPolymorphicException(String serialName, JsonElement element) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new JsonEncodingException("Class with serial name " + string + " cannot be serialized polymorphically because it is represented as " + Reflection.getOrCreateKotlinClass(var1_1.getClass()).getSimpleName() + ". Make sure that its JsonTransformingSerializer returns JsonObject, so class discriminator can be added to it.");
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$validateIfSealed(SerializationStrategy serializer, SerializationStrategy actualSerializer, String classDiscriminator) {
        void var2_2;
        void var1_1;
        PolymorphicKt.validateIfSealed(serializer, var1_1, (String)var2_2);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=176)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassDiscriminatorMode.values().length];
            try {
                nArray[ClassDiscriminatorMode.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ClassDiscriminatorMode.POLYMORPHIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ClassDiscriminatorMode.ALL_JSON_OBJECTS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

