/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.StringOpsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0019\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J'\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0003J\u000f\u0010\u0019\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b \u0010!R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&"}, d2={"Lkotlinx/serialization/json/internal/JsonToStringWriter;", "Lkotlinx/serialization/json/internal/InternalJsonWriter;", "<init>", "()V", "", "value", "", "writeLong", "(J)V", "", "char", "writeChar", "(C)V", "", "text", "write", "(Ljava/lang/String;)V", "writeQuoted", "", "firstEscapedChar", "currentSize", "string", "appendStringSlowPath", "(IILjava/lang/String;)V", "release", "toString", "()Ljava/lang/String;", "expected", "ensureAdditionalCapacity", "(I)V", "oldSize", "additional", "ensureTotalCapacity", "(II)I", "", "array", "[C", "size", "I"})
public final class JsonToStringWriter
implements InternalJsonWriter {
    private char[] array = CharArrayPool.INSTANCE.take();
    private int size;

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeLong(long value) {
        void var1_1;
        this.write(String.valueOf((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeChar(char c) {
        void var1_1;
        this.ensureAdditionalCapacity(1);
        int n = this.size;
        this.size = n + 1;
        this.array[n] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(String text) {
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int length = text.length();
        if (length == 0) {
            return;
        }
        this.ensureAdditionalCapacity(length);
        String string = text;
        char[] cArray = this.array;
        int n = this.size;
        int n2 = var1_1.length();
        string.getChars(0, n2, cArray, n);
        this.size += var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeQuoted(String text) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.ensureAdditionalCapacity(text.length() + 2);
        char[] arr = this.array;
        int sz = this.size;
        arr[sz++] = 34;
        int length = text.length();
        String string = text;
        string.getChars(0, length, arr, sz);
        int n = sz + length;
        for (int i = sz; i < n; ++i) {
            char ch = arr[i];
            if (ch >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[ch] == 0) continue;
            this.appendStringSlowPath(i - sz, i, text);
            return;
        }
        sz += length;
        var2_2[sz++] = 34;
        this.size = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final void appendStringSlowPath(int firstEscapedChar, int currentSize, String string) {
        void var2_2;
        void i;
        int sz = currentSize;
        int n = string.length();
        while (i < n) {
            byte marker2;
            sz = this.ensureTotalCapacity(sz, 2);
            char ch = string.charAt((int)i);
            if (ch < StringOpsKt.getESCAPE_MARKERS().length && (marker2 = StringOpsKt.getESCAPE_MARKERS()[ch]) != 0) {
                if (marker2 == 1) {
                    String escapedString;
                    Intrinsics.checkNotNull((Object)StringOpsKt.getESCAPE_STRINGS()[ch]);
                    sz = this.ensureTotalCapacity(sz, escapedString.length());
                    String marker2 = escapedString;
                    char[] cArray = this.array;
                    int n2 = escapedString.length();
                    marker2.getChars(0, n2, cArray, sz);
                    this.size = sz += escapedString.length();
                } else {
                    this.array[sz] = 92;
                    this.array[sz + 1] = (char)marker2;
                    this.size = sz += 2;
                }
            } else {
                void var5_5;
                this.array[sz++] = (char)var5_5;
            }
            ++i;
        }
        sz = this.ensureTotalCapacity(sz, 1);
        this.array[sz++] = 34;
        this.size = var2_2;
    }

    @Override
    public final void release() {
        CharArrayPool.INSTANCE.release(this.array);
    }

    public final String toString() {
        return new String(this.array, 0, this.size);
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureAdditionalCapacity(int expected) {
        void var1_1;
        JsonToStringWriter jsonToStringWriter = this;
        jsonToStringWriter.ensureTotalCapacity(jsonToStringWriter.size, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final int ensureTotalCapacity(int oldSize, int additional) {
        void var1_1;
        int newSize = oldSize + additional;
        if (this.array.length <= newSize) {
            void var2_2;
            char[] cArray = Arrays.copyOf(this.array, RangesKt.coerceAtLeast((int)var2_2, (int)(oldSize << 1)));
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"copyOf(...)");
            this.array = cArray;
        }
        return (int)var1_1;
    }
}

