/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.ByteArrayPool;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.JsonEncodingException;
import kotlinx.serialization.json.internal.StringOpsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u001f\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\u0018\u0010!\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0014H\u0082\b\u00a2\u0006\u0004\b!\u0010\"J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u0014H\u0082\b\u00a2\u0006\u0004\b\u0011\u0010\"J\u0010\u0010$\u001a\u00020\u0014H\u0082\b\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010(\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010+\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b+\u0010\"R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010,R\u0014\u0010.\u001a\u00020-8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0016\u00100\u001a\u00020&8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00102\u001a\u00020\u00148\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103"}, d2={"Lkotlinx/serialization/json/internal/JsonToJavaStreamWriter;", "Lkotlinx/serialization/json/internal/InternalJsonWriter;", "Ljava/io/OutputStream;", "stream", "<init>", "(Ljava/io/OutputStream;)V", "", "value", "", "writeLong", "(J)V", "", "char", "writeChar", "(C)V", "", "text", "write", "(Ljava/lang/String;)V", "writeQuoted", "", "currentSize", "string", "appendStringSlowPath", "(ILjava/lang/String;)V", "oldSize", "additional", "ensureTotalCapacity", "(II)I", "release", "()V", "flush", "bytesCount", "ensure", "(I)V", "byte", "rest", "()I", "", "count", "writeUtf8", "([CI)V", "codePoint", "writeUtf8CodePoint", "Ljava/io/OutputStream;", "", "buffer", "[B", "charArray", "[C", "indexInBuffer", "I"})
@SourceDebugExtension(value={"SMAP\nJvmJsonStreams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmJsonStreams.kt\nkotlinx/serialization/json/internal/JsonToJavaStreamWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,268:1\n130#1:269\n117#1:271\n130#1:272\n118#1,3:273\n125#1,2:276\n130#1:278\n125#1,2:279\n117#1:281\n130#1:282\n118#1,3:283\n125#1,2:286\n125#1,2:288\n117#1:290\n130#1:291\n118#1,3:292\n125#1,2:295\n125#1,2:297\n125#1,2:299\n117#1:301\n130#1:302\n118#1,3:303\n125#1,2:306\n117#1:308\n130#1:309\n118#1,3:310\n125#1,2:313\n125#1,2:315\n125#1,2:317\n125#1,2:319\n117#1:321\n130#1:322\n118#1,3:323\n125#1,2:326\n117#1:328\n130#1:329\n118#1,3:330\n125#1,2:333\n125#1,2:335\n117#1:337\n130#1:338\n118#1,3:339\n125#1,2:342\n117#1:344\n130#1:345\n118#1,3:346\n125#1,2:349\n125#1,2:351\n125#1,2:353\n117#1:355\n130#1:356\n118#1,3:357\n125#1,2:360\n125#1,2:362\n125#1,2:364\n125#1,2:366\n1#2:270\n*S KotlinDebug\n*F\n+ 1 JvmJsonStreams.kt\nkotlinx/serialization/json/internal/JsonToJavaStreamWriter\n*L\n117#1:269\n148#1:271\n148#1:272\n148#1:273,3\n149#1:276,2\n151#1:278\n158#1:279,2\n165#1:281\n165#1:282\n165#1:283,3\n166#1:286,2\n167#1:288,2\n173#1:290\n173#1:291\n173#1:292,3\n174#1:295,2\n175#1:297,2\n176#1:299,2\n186#1:301\n186#1:302\n186#1:303,3\n187#1:306,2\n196#1:308\n196#1:309\n196#1:310,3\n197#1:313,2\n198#1:315,2\n199#1:317,2\n200#1:319,2\n215#1:321\n215#1:322\n215#1:323,3\n216#1:326,2\n221#1:328\n221#1:329\n221#1:330,3\n222#1:333,2\n223#1:335,2\n228#1:337\n228#1:338\n228#1:339,3\n229#1:342,2\n234#1:344\n234#1:345\n234#1:346,3\n235#1:349,2\n236#1:351,2\n237#1:353,2\n242#1:355\n242#1:356\n242#1:357,3\n243#1:360,2\n244#1:362,2\n245#1:364,2\n246#1:366,2\n*E\n"})
public final class JsonToJavaStreamWriter
implements InternalJsonWriter {
    private final OutputStream stream;
    private final byte[] buffer;
    private char[] charArray;
    private int indexInBuffer;

    /*
     * WARNING - void declaration
     */
    public JsonToJavaStreamWriter(OutputStream stream) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = var1_1;
        this.buffer = ByteArrayPool.INSTANCE.take();
        this.charArray = CharArrayPool.INSTANCE.take();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeLong(long value) {
        void var1_1;
        this.write(String.valueOf((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeChar(char c) {
        void var1_1;
        this.writeUtf8CodePoint((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(String text) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int length = text.length();
        this.ensureTotalCapacity(0, length);
        char[] cArray = this.charArray;
        var1_1.getChars(0, length, cArray, 0);
        JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
        jsonToJavaStreamWriter.writeUtf8(jsonToJavaStreamWriter.charArray, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeQuoted(String text) {
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.ensureTotalCapacity(0, text.length() + 2);
        char[] arr = this.charArray;
        this.charArray[0] = 34;
        int length = text.length();
        String string = text;
        string.getChars(0, length, arr, 1);
        int n = length + 1;
        for (int i = 1; i < n; ++i) {
            char ch = arr[i];
            if (ch >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[ch] == 0) continue;
            this.appendStringSlowPath(i, text);
            return;
        }
        arr[length + 1] = 34;
        this.writeUtf8((char[])var2_2, (int)(var3_3 + 2));
        this.flush();
    }

    /*
     * WARNING - void declaration
     */
    private final void appendStringSlowPath(int currentSize, String string) {
        void var3_3;
        int sz = currentSize;
        int n = string.length();
        for (int i = currentSize - 1; i < n; ++i) {
            void var5_5;
            byte marker2;
            sz = this.ensureTotalCapacity(sz, 2);
            char ch = string.charAt(i);
            if (ch < StringOpsKt.getESCAPE_MARKERS().length && (marker2 = StringOpsKt.getESCAPE_MARKERS()[ch]) != 0) {
                if (marker2 == 1) {
                    String escapedString;
                    Intrinsics.checkNotNull((Object)StringOpsKt.getESCAPE_STRINGS()[ch]);
                    sz = this.ensureTotalCapacity(sz, escapedString.length());
                    String marker2 = escapedString;
                    char[] cArray = this.charArray;
                    int n2 = escapedString.length();
                    marker2.getChars(0, n2, cArray, sz);
                    sz += escapedString.length();
                    continue;
                }
                this.charArray[sz] = 92;
                this.charArray[sz + 1] = (char)marker2;
                sz += 2;
                continue;
            }
            this.charArray[sz++] = (char)var5_5;
        }
        this.ensureTotalCapacity(sz, 1);
        this.charArray[sz++] = 34;
        JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
        jsonToJavaStreamWriter.writeUtf8(jsonToJavaStreamWriter.charArray, (int)var3_3);
        this.flush();
    }

    /*
     * WARNING - void declaration
     */
    private final int ensureTotalCapacity(int oldSize, int additional) {
        void var1_1;
        int newSize = oldSize + additional;
        if (this.charArray.length <= newSize) {
            void var2_2;
            char[] cArray = Arrays.copyOf(this.charArray, RangesKt.coerceAtLeast((int)var2_2, (int)(oldSize << 1)));
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"copyOf(...)");
            this.charArray = cArray;
        }
        return (int)var1_1;
    }

    @Override
    public final void release() {
        this.flush();
        CharArrayPool.INSTANCE.release(this.charArray);
        ByteArrayPool.INSTANCE.release(this.buffer);
    }

    private final void flush() {
        this.stream.write(this.buffer, 0, this.indexInBuffer);
        this.indexInBuffer = 0;
    }

    /*
     * WARNING - void declaration
     */
    private final void ensure(int bytesCount) {
        void var1_1;
        void var2_2;
        JsonToJavaStreamWriter this_$iv = this;
        if (this_$iv.buffer.length - var2_2.indexInBuffer < var1_1) {
            this.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void write(int n) {
        void var1_1;
        int n2 = this.indexInBuffer;
        this.indexInBuffer = n2 + 1;
        this.buffer[n2] = (byte)var1_1;
    }

    private final int rest() {
        return this.buffer.length - this.indexInBuffer;
    }

    private final void writeUtf8(char[] string, int count) {
        if (!(count >= 0)) {
            String string2 = "count < 0";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(count <= string.length)) {
            String string3 = "count > string.length: " + count + " > " + string.length;
            throw new IllegalArgumentException(string3.toString());
        }
        int i = 0;
        while (i < count) {
            JsonToJavaStreamWriter this_$iv;
            char low;
            char byte$iv;
            block17: {
                JsonToJavaStreamWriter this_$iv2;
                int this_$iv$iv22;
                block16: {
                    char c = string[i];
                    if (c < '\u0080') {
                        JsonToJavaStreamWriter this_$iv3;
                        JsonToJavaStreamWriter this_$iv$iv22 = this_$iv3 = this;
                        if (this_$iv3.buffer.length - this_$iv$iv22.indexInBuffer <= 0) {
                            this_$iv3.flush();
                        }
                        this_$iv3 = this;
                        char byte$iv2 = c;
                        this_$iv$iv22 = this_$iv3.indexInBuffer;
                        this_$iv3.indexInBuffer = this_$iv$iv22 + 1;
                        this_$iv3.buffer[this_$iv$iv22] = (byte)byte$iv2;
                        JsonToJavaStreamWriter this_$iv2222 = this;
                        int this_$iv2222 = ++i + (this_$iv2222.buffer.length - this_$iv2222.indexInBuffer);
                        int runLimit = Math.min(count, this_$iv2222);
                        while (i < runLimit && (c = string[i]) < '\u0080') {
                            JsonToJavaStreamWriter this_$iv2222 = this;
                            byte$iv = c;
                            this_$iv$iv22 = this_$iv2222.indexInBuffer;
                            this_$iv2222.indexInBuffer = this_$iv$iv22 + 1;
                            this_$iv2222.buffer[this_$iv$iv22] = (byte)byte$iv;
                            ++i;
                        }
                        continue;
                    }
                    if (byte$iv < '\u0800') {
                        JsonToJavaStreamWriter this_$iv4;
                        JsonToJavaStreamWriter this_$iv$iv = this_$iv4 = this;
                        if (this_$iv4.buffer.length - this_$iv$iv.indexInBuffer < 2) {
                            this_$iv4.flush();
                        }
                        this_$iv4 = this;
                        int byte$iv3 = byte$iv >> 6 | 0xC0;
                        this_$iv$iv22 = this_$iv4.indexInBuffer;
                        this_$iv4.indexInBuffer = this_$iv$iv22 + 1;
                        this_$iv4.buffer[this_$iv$iv22] = (byte)byte$iv3;
                        this_$iv4 = this;
                        byte$iv3 = byte$iv & 0x3F | 0x80;
                        this_$iv$iv22 = this_$iv4.indexInBuffer;
                        this_$iv4.indexInBuffer = this_$iv$iv22 + 1;
                        this_$iv4.buffer[this_$iv$iv22] = (byte)byte$iv3;
                        ++i;
                        continue;
                    }
                    if (byte$iv < '\ud800' || byte$iv > '\udfff') {
                        JsonToJavaStreamWriter this_$iv5;
                        JsonToJavaStreamWriter this_$iv$iv = this_$iv5 = this;
                        if (this_$iv5.buffer.length - this_$iv$iv.indexInBuffer < 3) {
                            this_$iv5.flush();
                        }
                        this_$iv5 = this;
                        int byte$iv4 = byte$iv >> 12 | 0xE0;
                        this_$iv$iv22 = this_$iv5.indexInBuffer;
                        this_$iv5.indexInBuffer = this_$iv$iv22 + 1;
                        this_$iv5.buffer[this_$iv$iv22] = (byte)byte$iv4;
                        this_$iv5 = this;
                        byte$iv4 = byte$iv >> 6 & 0x3F | 0x80;
                        this_$iv$iv22 = this_$iv5.indexInBuffer;
                        this_$iv5.indexInBuffer = this_$iv$iv22 + 1;
                        this_$iv5.buffer[this_$iv$iv22] = (byte)byte$iv4;
                        this_$iv5 = this;
                        byte$iv4 = byte$iv & 0x3F | 0x80;
                        this_$iv$iv22 = this_$iv5.indexInBuffer;
                        this_$iv5.indexInBuffer = this_$iv$iv22 + 1;
                        this_$iv5.buffer[this_$iv$iv22] = (byte)byte$iv4;
                        ++i;
                        continue;
                    }
                    char c2 = low = i + 1 < count ? string[i + 1] : (char)'\u0000';
                    if (byte$iv > 56319) break block16;
                    if ('\udc00' <= low ? low < '\ue000' : false) break block17;
                }
                JsonToJavaStreamWriter this_$iv$iv = this_$iv2 = this;
                if (this_$iv2.buffer.length - this_$iv$iv.indexInBuffer <= 0) {
                    this_$iv2.flush();
                }
                this_$iv2 = this;
                this_$iv$iv22 = this_$iv2.indexInBuffer;
                this_$iv2.indexInBuffer = this_$iv$iv22 + 1;
                this_$iv2.buffer[this_$iv$iv22] = 63;
                ++i;
                continue;
            }
            int codePoint = 65536 + ((byte$iv & 0x3FF) << 10 | low & 0x3FF);
            JsonToJavaStreamWriter this_$iv$iv = this_$iv = this;
            if (this_$iv.buffer.length - this_$iv$iv.indexInBuffer < 4) {
                this_$iv.flush();
            }
            this_$iv = this;
            int byte$iv5 = codePoint >> 18 | 0xF0;
            int n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv5;
            this_$iv = this;
            byte$iv5 = codePoint >> 12 & 0x3F | 0x80;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv5;
            this_$iv = this;
            byte$iv5 = codePoint >> 6 & 0x3F | 0x80;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv5;
            this_$iv = this;
            byte$iv5 = codePoint & 0x3F | 0x80;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv5;
            i += 2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeUtf8CodePoint(int codePoint) {
        void var1_1;
        if (codePoint < 128) {
            JsonToJavaStreamWriter this_$iv;
            JsonToJavaStreamWriter this_$iv$iv22 = this_$iv = this;
            if (this_$iv.buffer.length - this_$iv$iv22.indexInBuffer <= 0) {
                this_$iv.flush();
            }
            this_$iv = this;
            int byte$iv = codePoint;
            int this_$iv$iv22 = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = this_$iv$iv22 + 1;
            this_$iv.buffer[this_$iv$iv22] = (byte)byte$iv;
            return;
        }
        if (codePoint < 2048) {
            JsonToJavaStreamWriter this_$iv;
            JsonToJavaStreamWriter this_$iv$iv32 = this_$iv = this;
            if (this_$iv.buffer.length - this_$iv$iv32.indexInBuffer < 2) {
                this_$iv.flush();
            }
            this_$iv = this;
            int byte$iv = codePoint >> 6 | 0xC0;
            int this_$iv$iv32 = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = this_$iv$iv32 + 1;
            this_$iv.buffer[this_$iv$iv32] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint & 0x3F | 0x80;
            this_$iv$iv32 = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = this_$iv$iv32 + 1;
            this_$iv.buffer[this_$iv$iv32] = (byte)byte$iv;
            return;
        }
        boolean bl = 55296 <= codePoint ? codePoint < 57344 : false;
        if (bl) {
            JsonToJavaStreamWriter this_$iv;
            JsonToJavaStreamWriter this_$iv$iv42 = this_$iv = this;
            if (this_$iv.buffer.length - this_$iv$iv42.indexInBuffer <= 0) {
                this_$iv.flush();
            }
            this_$iv = this;
            int this_$iv$iv42 = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = this_$iv$iv42 + 1;
            this_$iv.buffer[this_$iv$iv42] = 63;
            return;
        }
        if (codePoint < 65536) {
            JsonToJavaStreamWriter this_$iv;
            JsonToJavaStreamWriter this_$iv$iv52 = this_$iv = this;
            if (this_$iv.buffer.length - this_$iv$iv52.indexInBuffer < 3) {
                this_$iv.flush();
            }
            this_$iv = this;
            int byte$iv = codePoint >> 12 | 0xE0;
            int this_$iv$iv52 = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = this_$iv$iv52 + 1;
            this_$iv.buffer[this_$iv$iv52] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint >> 6 & 0x3F | 0x80;
            this_$iv$iv52 = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = this_$iv$iv52 + 1;
            this_$iv.buffer[this_$iv$iv52] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint & 0x3F | 0x80;
            this_$iv$iv52 = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = this_$iv$iv52 + 1;
            this_$iv.buffer[this_$iv$iv52] = (byte)byte$iv;
            return;
        }
        if (codePoint <= 0x10FFFF) {
            void var3_20;
            JsonToJavaStreamWriter this_$iv;
            JsonToJavaStreamWriter this_$iv$iv = this_$iv = this;
            if (this_$iv.buffer.length - this_$iv$iv.indexInBuffer < 4) {
                this_$iv.flush();
            }
            this_$iv = this;
            int byte$iv = codePoint >> 18 | 0xF0;
            int n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint >> 12 & 0x3F | 0x80;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint >> 6 & 0x3F | 0x80;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint & 0x3F | 0x80;
            n = this_$iv.indexInBuffer;
            var2_6.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)var3_20;
            return;
        }
        throw new JsonEncodingException("Unexpected code point: " + (int)var1_1);
    }
}

