/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.modules.SerializersModuleCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005JX\u0010\u0012\u001a\u00020\u0011\"\b\b\u0000\u0010\u0007*\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b2/\u0010\u0010\u001a+\u0012\u001d\u0012\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\nH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013JM\u0010\u0019\u001a\u00020\u0011\"\b\b\u0000\u0010\u0014*\u00020\u0006\"\b\b\u0001\u0010\u0015*\u00028\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\fH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001b2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ#\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001b2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\bH\u0002\u00a2\u0006\u0004\b\u001f\u0010\u001eJR\u0010#\u001a\u00020\u0011\"\b\b\u0000\u0010\u0014*\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\b2)\u0010\"\u001a%\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b( \u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010!0\nH\u0016\u00a2\u0006\u0004\b#\u0010\u0013JT\u0010(\u001a\u00020\u0011\"\b\b\u0000\u0010\u0014*\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\b2+\u0010'\u001a'\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(%\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010&0\nH\u0016\u00a2\u0006\u0004\b(\u0010\u0013R\u0014\u0010)\u001a\u00020$8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010,\u001a\u00020+8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020+8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010-"}, d2={"Lkotlinx/serialization/json/internal/JsonSerializersModuleValidator;", "Lkotlinx/serialization/modules/SerializersModuleCollector;", "Lkotlinx/serialization/json/JsonConfiguration;", "configuration", "<init>", "(Lkotlinx/serialization/json/JsonConfiguration;)V", "", "T", "Lkotlin/reflect/KClass;", "kClass", "Lkotlin/Function1;", "", "Lkotlinx/serialization/KSerializer;", "Lkotlin/ParameterName;", "name", "typeArgumentsSerializers", "provider", "", "contextual", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function1;)V", "Base", "Sub", "baseClass", "actualClass", "actualSerializer", "polymorphic", "(Lkotlin/reflect/KClass;Lkotlin/reflect/KClass;Lkotlinx/serialization/KSerializer;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "checkKind", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlin/reflect/KClass;)V", "checkDiscriminatorCollisions", "value", "Lkotlinx/serialization/SerializationStrategy;", "defaultSerializerProvider", "polymorphicDefaultSerializer", "", "className", "Lkotlinx/serialization/DeserializationStrategy;", "defaultDeserializerProvider", "polymorphicDefaultDeserializer", "discriminator", "Ljava/lang/String;", "", "useArrayPolymorphism", "Z", "isDiscriminatorRequired"})
public final class JsonSerializersModuleValidator
implements SerializersModuleCollector {
    private final String discriminator;
    private final boolean useArrayPolymorphism;
    private final boolean isDiscriminatorRequired;

    /*
     * WARNING - void declaration
     */
    public JsonSerializersModuleValidator(JsonConfiguration configuration) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.discriminator = configuration.getClassDiscriminator();
        this.useArrayPolymorphism = configuration.getUseArrayPolymorphism();
        this.isDiscriminatorRequired = var1_1.getClassDiscriminatorMode() != ClassDiscriminatorMode.NONE;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void contextual(KClass<T> kClass, Function1<? super List<? extends KSerializer<?>>, ? extends KSerializer<?>> provider) {
        void var2_2;
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"provider");
    }

    /*
     * WARNING - void declaration
     */
    public final <Base, Sub extends Base> void polymorphic(KClass<Base> baseClass, KClass<Sub> actualClass, KSerializer<Sub> actualSerializer) {
        void var3_3;
        Intrinsics.checkNotNullParameter(baseClass, (String)"baseClass");
        Intrinsics.checkNotNullParameter(actualClass, (String)"actualClass");
        Intrinsics.checkNotNullParameter(actualSerializer, (String)"actualSerializer");
        SerialDescriptor descriptor = var3_3.getDescriptor();
        this.checkKind(descriptor, actualClass);
        if (!this.useArrayPolymorphism && this.isDiscriminatorRequired) {
            void var2_2;
            void var1_1;
            this.checkDiscriminatorCollisions((SerialDescriptor)var1_1, (KClass<?>)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkKind(SerialDescriptor descriptor, KClass<?> actualClass) {
        SerialKind kind = descriptor.getKind();
        if (kind instanceof PolymorphicKind || Intrinsics.areEqual((Object)kind, (Object)SerialKind.CONTEXTUAL.INSTANCE)) {
            throw new IllegalArgumentException("Serializer for " + actualClass.getSimpleName() + " can't be registered as a subclass for polymorphic serialization because its kind " + kind + " is not concrete. To work with multiple hierarchies, register it as a base class.");
        }
        if (this.useArrayPolymorphism) {
            return;
        }
        if (!this.isDiscriminatorRequired) {
            return;
        }
        if (Intrinsics.areEqual((Object)kind, (Object)StructureKind.LIST.INSTANCE) || Intrinsics.areEqual((Object)kind, (Object)StructureKind.MAP.INSTANCE) || kind instanceof PrimitiveKind || kind instanceof SerialKind.ENUM) {
            void var1_1;
            void var2_2;
            throw new IllegalArgumentException("Serializer for " + var2_2.getSimpleName() + " of kind " + var1_1 + " cannot be serialized polymorphically with class discriminator.");
        }
    }

    private final void checkDiscriminatorCollisions(SerialDescriptor descriptor, KClass<?> actualClass) {
        int n = descriptor.getElementsCount();
        for (int i = 0; i < n; ++i) {
            String name = descriptor.getElementName(i);
            if (!Intrinsics.areEqual((Object)name, (Object)this.discriminator)) continue;
            throw new IllegalArgumentException("Polymorphic serializer for " + actualClass + " has property '" + name + "' that conflicts with JSON class discriminator. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <Base> void polymorphicDefaultSerializer(KClass<Base> baseClass, Function1<? super Base, ? extends SerializationStrategy<? super Base>> defaultSerializerProvider) {
        void var2_2;
        Intrinsics.checkNotNullParameter(baseClass, (String)"baseClass");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"defaultSerializerProvider");
    }

    /*
     * WARNING - void declaration
     */
    public final <Base> void polymorphicDefaultDeserializer(KClass<Base> baseClass, Function1<? super String, ? extends DeserializationStrategy<? extends Base>> defaultDeserializerProvider) {
        void var2_2;
        Intrinsics.checkNotNullParameter(baseClass, (String)"baseClass");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"defaultDeserializerProvider");
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void contextual(KClass<T> kClass, KSerializer<T> serializer) {
        void var2_2;
        void var1_1;
        super.contextual((KClass)var1_1, (KSerializer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Deprecated in favor of function with more precise name: polymorphicDefaultDeserializer", replaceWith=@ReplaceWith(expression="polymorphicDefaultDeserializer(baseClass, defaultDeserializerProvider)", imports={}), level=DeprecationLevel.WARNING)
    public final <Base> void polymorphicDefault(KClass<Base> baseClass, Function1<? super String, ? extends DeserializationStrategy<? extends Base>> defaultDeserializerProvider) {
        void var2_2;
        void var1_1;
        super.polymorphicDefault((KClass)var1_1, (Function1)var2_2);
    }
}

