/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.StructureKind;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0003J\r\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0011\u0010\u0003J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0016\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0003J\u000f\u0010\u0019\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0014R\u001e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!"}, d2={"Lkotlinx/serialization/json/internal/JsonPath;", "", "<init>", "()V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "sd", "", "pushDescriptor", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "", "index", "updateDescriptorIndex", "(I)V", "key", "updateCurrentMapKey", "(Ljava/lang/Object;)V", "resetCurrentMapKey", "popDescriptor", "", "getPath", "()Ljava/lang/String;", "it", "prettyString", "(Ljava/lang/Object;)Ljava/lang/String;", "resize", "toString", "", "currentObjectPath", "[Ljava/lang/Object;", "", "indicies", "[I", "currentDepth", "I", "Tombstone"})
public final class JsonPath {
    private Object[] currentObjectPath = new Object[8];
    private int[] indicies;
    private int currentDepth;

    public JsonPath() {
        int n = 0;
        int[] nArray = new int[8];
        JsonPath jsonPath = this;
        while (n < 8) {
            int n2 = n++;
            nArray[n2] = -1;
        }
        jsonPath.indicies = nArray;
        this.currentDepth = -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void pushDescriptor(SerialDescriptor sd) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sd, (String)"sd");
        ++this.currentDepth;
        int depth = this.currentDepth;
        if (depth == this.currentObjectPath.length) {
            this.resize();
        }
        this.currentObjectPath[var2_2] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateDescriptorIndex(int index) {
        void var1_1;
        this.indicies[this.currentDepth] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCurrentMapKey(Object key) {
        void var1_1;
        if (this.indicies[this.currentDepth] != -2) {
            ++this.currentDepth;
            if (this.currentDepth == this.currentObjectPath.length) {
                this.resize();
            }
        }
        this.currentObjectPath[this.currentDepth] = var1_1;
        this.indicies[this.currentDepth] = -2;
    }

    public final void resetCurrentMapKey() {
        if (this.indicies[this.currentDepth] == -2) {
            this.currentObjectPath[this.currentDepth] = Tombstone.INSTANCE;
        }
    }

    public final void popDescriptor() {
        int n;
        int depth = this.currentDepth;
        if (this.indicies[depth] == -2) {
            this.indicies[n] = -1;
            n = this.currentDepth;
            this.currentDepth = n + -1;
        }
        if (this.currentDepth != -1) {
            n = this.currentDepth;
            this.currentDepth = n + -1;
        }
    }

    public final String getPath() {
        StringBuilder stringBuilder;
        StringBuilder $this$getPath_u24lambda_u241 = stringBuilder = new StringBuilder();
        stringBuilder.append("$");
        int n = this.currentDepth + 1;
        for (int i = 0; i < n; ++i) {
            int it = i;
            Object element = this.currentObjectPath[it];
            if (element instanceof SerialDescriptor) {
                if (Intrinsics.areEqual((Object)((SerialDescriptor)element).getKind(), (Object)StructureKind.LIST.INSTANCE)) {
                    if (this.indicies[it] == -1) continue;
                    $this$getPath_u24lambda_u241.append("[");
                    $this$getPath_u24lambda_u241.append(this.indicies[it]);
                    $this$getPath_u24lambda_u241.append("]");
                    continue;
                }
                int idx = this.indicies[it];
                if (idx < 0) continue;
                $this$getPath_u24lambda_u241.append(".");
                $this$getPath_u24lambda_u241.append(((SerialDescriptor)element).getElementName(idx));
                continue;
            }
            if (element == Tombstone.INSTANCE) continue;
            $this$getPath_u24lambda_u241.append("[");
            $this$getPath_u24lambda_u241.append("'");
            $this$getPath_u24lambda_u241.append(element);
            $this$getPath_u24lambda_u241.append("'");
            $this$getPath_u24lambda_u241.append("]");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String prettyString(Object it) {
        Object object = it instanceof SerialDescriptor ? (SerialDescriptor)it : null;
        if (object == null || (object = object.getSerialName()) == null) {
            void var1_1;
            object = String.valueOf(var1_1);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void resize() {
        void var1_2;
        int newSize = this.currentDepth << 1;
        Object[] objectArray = Arrays.copyOf(this.currentObjectPath, newSize);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        this.currentObjectPath = objectArray;
        int n = 0;
        int[] nArray = new int[newSize];
        while (n < newSize) {
            int n2 = n++;
            nArray[n2] = -1;
        }
        int[] newIndices = nArray;
        ArraysKt.copyInto$default((int[])this.indicies, (int[])newIndices, (int)0, (int)0, (int)0, (int)14, null);
        this.indicies = var1_2;
    }

    public final String toString() {
        return this.getPath();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lkotlinx/serialization/json/internal/JsonPath$Tombstone;", "", "<init>", "()V"})
    private static final class Tombstone {
        public static final Tombstone INSTANCE = new Tombstone();

        private Tombstone() {
        }
    }
}

