/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.snapshots.SnapshotStateList;
import androidx.compose.runtime.snapshots.SnapshotStateListKt;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableListIterator;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\r\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0010\u0010\rJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0004\b\u0015\u0010\u000bJ\u0010\u0010\u0016\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0016\u0010\u000fJ\u000f\u0010\u0017\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0014J\u000f\u0010\u001a\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0018R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001d"}, d2={"Landroidx/compose/runtime/snapshots/StateListIterator;", "T", "", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "list", "", "offset", "<init>", "(Landroidx/compose/runtime/snapshots/SnapshotStateList;I)V", "", "hasPrevious", "()Z", "nextIndex", "()I", "previous", "()Ljava/lang/Object;", "previousIndex", "element", "", "add", "(Ljava/lang/Object;)V", "hasNext", "next", "remove", "()V", "set", "validateModification", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "index", "I", "lastRequested", "structure"})
@SourceDebugExtension(value={"SMAP\nSnapshotStateList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotStateList.kt\nandroidx/compose/runtime/snapshots/StateListIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,511:1\n1#2:512\n*E\n"})
public final class StateListIterator<T>
implements ListIterator<T>,
KMutableListIterator {
    public final SnapshotStateList<T> list;
    private int index;
    private int lastRequested;
    private int structure;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public StateListIterator(SnapshotStateList<T> list, int offset) {
        void var2_2;
        void var1_1;
        this.list = var1_1;
        this.index = var2_2 - true;
        this.lastRequested = -1;
        this.structure = SnapshotStateListKt.getStructure(this.list);
    }

    @Override
    public final boolean hasPrevious() {
        return this.index >= 0;
    }

    @Override
    public final int nextIndex() {
        return this.index + 1;
    }

    @Override
    public final T previous() {
        this.validateModification();
        SnapshotStateListKt.access$validateRange(this.index, this.list.size());
        this.lastRequested = this.index;
        T t = this.list.get(this.index);
        int n = this.index;
        this.index = n + -1;
        return t;
    }

    @Override
    public final int previousIndex() {
        return this.index;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(T element) {
        void var1_1;
        this.validateModification();
        this.list.add(this.index + 1, var1_1);
        this.lastRequested = -1;
        int n = this.index;
        this.index = n + 1;
        this.structure = SnapshotStateListKt.getStructure(this.list);
    }

    @Override
    public final boolean hasNext() {
        return this.index < this.list.size() - 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T next() {
        void var1_1;
        int newIndex;
        this.validateModification();
        this.lastRequested = newIndex = this.index + 1;
        SnapshotStateListKt.access$validateRange(newIndex, this.list.size());
        T t = this.list.get(newIndex);
        this.index = var1_1;
        return t;
    }

    @Override
    public final void remove() {
        this.validateModification();
        this.list.remove(this.lastRequested);
        int n = this.index;
        this.index = n + -1;
        this.lastRequested = -1;
        this.structure = SnapshotStateListKt.getStructure(this.list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void set(T element) {
        void var1_1;
        this.validateModification();
        if (this.lastRequested < 0) {
            SnapshotStateListKt.access$invalidIteratorSet();
            throw new KotlinNothingValueException();
        }
        this.list.set(this.lastRequested, var1_1);
        this.structure = SnapshotStateListKt.getStructure(this.list);
    }

    private final void validateModification() {
        if (SnapshotStateListKt.getStructure(this.list) != this.structure) {
            throw new ConcurrentModificationException();
        }
    }
}

