/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap;

import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBaseIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.TrieNode;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.TrieNodeBaseIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.TrieNodeKt;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\b\u0012\u0004\u0012\u00028\u00020\u00042\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0005B;\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u001e\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J7\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00162\u000e\u0010\u0019\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00182\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0011J\u000f\u0010\u001e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0011R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001fR\u0018\u0010 \u001a\u0004\u0018\u00018\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&"}, d2={"Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableMap/PersistentHashMapBuilderBaseIterator;", "K", "V", "T", "", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableMap/PersistentHashMapBaseIterator;", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableMap/PersistentHashMapBuilder;", "builder", "", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableMap/TrieNodeBaseIterator;", "path", "<init>", "(Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableMap/PersistentHashMapBuilder;[Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableMap/TrieNodeBaseIterator;)V", "next", "()Ljava/lang/Object;", "", "remove", "()V", "key", "newValue", "setValue", "(Ljava/lang/Object;Ljava/lang/Object;)V", "", "keyHash", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableMap/TrieNode;", "node", "pathIndex", "resetPath", "(ILandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableMap/TrieNode;Ljava/lang/Object;I)V", "checkNextWasInvoked", "checkForComodification", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableMap/PersistentHashMapBuilder;", "lastIteratedKey", "Ljava/lang/Object;", "", "nextWasInvoked", "Z", "expectedModCount", "I"})
public class PersistentHashMapBuilderBaseIterator<K, V, T>
extends PersistentHashMapBaseIterator<K, V, T>
implements Iterator<T>,
KMutableIterator {
    private final PersistentHashMapBuilder<K, V> builder;
    private K lastIteratedKey;
    private boolean nextWasInvoked;
    private int expectedModCount;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public PersistentHashMapBuilderBaseIterator(PersistentHashMapBuilder<K, V> builder, TrieNodeBaseIterator<K, V, T>[] path) {
        super(builder.getNode$runtime(), (TrieNodeBaseIterator<K, V, T>[])var2_2);
        void var1_1;
        void var2_2;
        this.builder = var1_1;
        this.expectedModCount = this.builder.getModCount$runtime();
    }

    @Override
    public T next() {
        this.checkForComodification();
        this.lastIteratedKey = this.currentKey();
        this.nextWasInvoked = true;
        return super.next();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove() {
        this.checkNextWasInvoked();
        if (this.hasNext()) {
            void var1_1;
            Object currentKey = this.currentKey();
            Map map = this.builder;
            K k = this.lastIteratedKey;
            TypeIntrinsics.asMutableMap((Object)map).remove(k);
            Object k2 = currentKey;
            this.resetPath(k2 != null ? k2.hashCode() : 0, this.builder.getNode$runtime(), var1_1, 0);
        } else {
            Map map = this.builder;
            K k = this.lastIteratedKey;
            TypeIntrinsics.asMutableMap((Object)map).remove(k);
        }
        this.lastIteratedKey = null;
        this.nextWasInvoked = false;
        this.expectedModCount = this.builder.getModCount$runtime();
    }

    /*
     * WARNING - void declaration
     */
    public final void setValue(K key, V newValue) {
        if (!this.builder.containsKey(key)) {
            return;
        }
        if (this.hasNext()) {
            void var3_3;
            Object currentKey = this.currentKey();
            ((Map)this.builder).put(key, newValue);
            Object k = currentKey;
            this.resetPath(k != null ? k.hashCode() : 0, this.builder.getNode$runtime(), var3_3, 0);
        } else {
            void var2_2;
            void var1_1;
            ((Map)this.builder).put(var1_1, var2_2);
        }
        this.expectedModCount = this.builder.getModCount$runtime();
    }

    private final void resetPath(int keyHash, TrieNode<?, ?> node, K key, int pathIndex) {
        while (true) {
            int keyIndex;
            int shift;
            if ((shift = pathIndex * 5) > 30) {
                this.getPath()[pathIndex].reset(node.getBuffer$runtime(), node.getBuffer$runtime().length, 0);
                while (!Intrinsics.areEqual(this.getPath()[pathIndex].currentKey(), key)) {
                    this.getPath()[pathIndex].moveToNextKey();
                }
                this.setPathLastIndex(pathIndex);
                return;
            }
            int keyPositionMask = 1 << TrieNodeKt.indexSegment(keyHash, shift);
            if (node.hasEntryAt$runtime(keyPositionMask)) {
                keyIndex = node.entryKeyIndex$runtime(keyPositionMask);
                this.getPath()[pathIndex].reset(node.getBuffer$runtime(), 2 * node.entryCount$runtime(), keyIndex);
                this.setPathLastIndex(pathIndex);
                return;
            }
            int nodeIndex = node.nodeIndex$runtime(keyIndex);
            TrieNode<?, ?> targetNode = node.nodeAtIndex$runtime(nodeIndex);
            this.getPath()[pathIndex].reset(node.getBuffer$runtime(), 2 * node.entryCount$runtime(), nodeIndex);
            ++pathIndex;
            node = targetNode;
        }
    }

    private final void checkNextWasInvoked() {
        if (!this.nextWasInvoked) {
            throw new IllegalStateException();
        }
    }

    private final void checkForComodification() {
        if (this.builder.getModCount$runtime() != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

