/*
 * Decompiled with CFR 0.152.
 */
package me.him188.ani.app.domain.media.cache;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import me.him188.ani.app.domain.media.cache.MediaCacheState;
import me.him188.ani.app.tools.Progress;
import me.him188.ani.app.tools.ProgressKt;
import me.him188.ani.datasources.api.CachedMedia;
import me.him188.ani.datasources.api.Media;
import me.him188.ani.datasources.api.MediaCacheMetadata;
import me.him188.ani.datasources.api.topic.FileSize;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 #2\u00020\u0001:\u0003$%#J\u0010\u0010\u0003\u001a\u00020\u0002H\u00a6@\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0004\b\u0007\u0010\u0004J\u0010\u0010\b\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0004\b\b\u0010\u0004R\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\r8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\u00118&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00158&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0018R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0\u00158&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0018\u00c0\u0006\u0003"}, d2={"Lme/him188/ani/app/domain/media/cache/MediaCache;", "", "Lme/him188/ani/datasources/api/CachedMedia;", "getCachedMedia", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "pause", "resume", "closeAndDeleteFiles", "", "getCacheId", "()Ljava/lang/String;", "cacheId", "Lme/him188/ani/datasources/api/Media;", "getOrigin", "()Lme/him188/ani/datasources/api/Media;", "origin", "Lme/him188/ani/datasources/api/MediaCacheMetadata;", "getMetadata", "()Lme/him188/ani/datasources/api/MediaCacheMetadata;", "metadata", "Lkotlinx/coroutines/flow/Flow;", "Lme/him188/ani/app/domain/media/cache/MediaCacheState;", "getState", "()Lkotlinx/coroutines/flow/Flow;", "state", "", "getCanPlay", "canPlay", "Lme/him188/ani/app/domain/media/cache/MediaCache$FileStats;", "getFileStats", "fileStats", "Lme/him188/ani/app/domain/media/cache/MediaCache$SessionStats;", "getSessionStats", "sessionStats", "Companion", "FileStats", "SessionStats"})
public interface MediaCache {
    public static final Companion Companion = me.him188.ani.app.domain.media.cache.MediaCache$Companion.$$INSTANCE;

    default public String getCacheId() {
        return Companion.calculateCacheId(this.getOrigin().getMediaId(), this.getMetadata());
    }

    public Media getOrigin();

    public MediaCacheMetadata getMetadata();

    public Flow<MediaCacheState> getState();

    default public Flow<Boolean> getCanPlay() {
        return FlowKt.flowOf((Object)Boolean.TRUE);
    }

    public Object getCachedMedia(Continuation<? super CachedMedia> var1);

    public Flow<FileStats> getFileStats();

    public Flow<SessionStats> getSessionStats();

    public Object pause(Continuation<? super Unit> var1);

    public Object resume(Continuation<? super Unit> var1);

    public Object closeAndDeleteFiles(Continuation<? super Unit> var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\t"}, d2={"Lme/him188/ani/app/domain/media/cache/MediaCache$Companion;", "", "<init>", "()V", "", "originMediaId", "Lme/him188/ani/datasources/api/MediaCacheMetadata;", "metadata", "calculateCacheId", "(Ljava/lang/String;Lme/him188/ani/datasources/api/MediaCacheMetadata;)Ljava/lang/String;"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final String calculateCacheId(String originMediaId, MediaCacheMetadata metadata) {
            void var1_1;
            String string;
            Intrinsics.checkNotNullParameter((Object)originMediaId, (String)"originMediaId");
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            String hash = String.valueOf(Math.abs(originMediaId.hashCode() * 31 + metadata.getSubjectId().hashCode() * 31 + metadata.getEpisodeId().hashCode()));
            String string2 = (String)CollectionsKt.firstOrNull((List)metadata.getSubjectNames());
            if (string2 == null) {
                string2 = string.getSubjectId();
            }
            string = string2;
            return StringsKt.take((String)me.him188.ani.app.domain.media.cache.MediaCache$Companion.calculateCacheId$removeSpecials(string2), (int)8) + "-" + (String)var1_1;
        }

        private static final String calculateCacheId$removeSpecials(String value) {
            CharSequence charSequence = value;
            Regex regex = new Regex("[-\\\\|/.,;'\\[\\]{}()=_ ~!@#$%^&*]");
            String string = "";
            return regex.replace(charSequence, string);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0087\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u000b\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000e\u001a\u00020\rH\u00d6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0013\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019"}, d2={"Lme/him188/ani/app/domain/media/cache/MediaCache$FileStats;", "", "Lme/him188/ani/datasources/api/topic/FileSize;", "totalSize", "downloadedBytes", "Lme/him188/ani/app/tools/Progress;", "downloadProgress", "<init>", "(JJFLkotlin/jvm/internal/DefaultConstructorMarker;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "J", "getTotalSize-dkBenQQ", "()J", "getDownloadedBytes-dkBenQQ", "F", "getDownloadProgress-4U8rbxw", "()F", "Companion"})
    @SourceDebugExtension(value={"SMAP\nMediaCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaCache.kt\nme/him188/ani/app/domain/media/cache/MediaCache$FileStats\n+ 2 FileSize.kt\nme/him188/ani/datasources/api/topic/FileSize\n*L\n1#1,309:1\n44#2:310\n42#2,3:311\n42#2,3:314\n*S KotlinDebug\n*F\n+ 1 MediaCache.kt\nme/him188/ani/app/domain/media/cache/MediaCache$FileStats\n*L\n91#1:310\n94#1:311,3\n97#1:314,3\n*E\n"})
    public static final class FileStats {
        public static final Companion Companion = new Companion(null);
        private final long totalSize;
        private final long downloadedBytes;
        private final float downloadProgress;
        private static final FileStats Unspecified = new FileStats(FileSize.Companion.getUnspecified-dkBenQQ(), FileSize.Companion.getUnspecified-dkBenQQ(), Progress.Companion.getUnspecified-4U8rbxw(), null);

        /*
         * WARNING - void declaration
         */
        private FileStats(long totalSize, long downloadedBytes, float downloadProgress) {
            void var3_2;
            void var1_1;
            this.totalSize = var1_1;
            this.downloadedBytes = var3_2;
            this.downloadProgress = downloadProgress;
        }

        public /* synthetic */ FileStats(long l, long l2, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                float f2;
                long l3 = l;
                if (FileSize.equals-impl0((long)l3, (long)FileSize.Companion.getUnspecified-dkBenQQ()) || FileSize.equals-impl0((long)(l3 = l2), (long)FileSize.Companion.getUnspecified-dkBenQQ())) {
                    f2 = Progress.Companion.getUnspecified-4U8rbxw();
                } else {
                    long l4;
                    long l5 = l4 = l;
                    if ((FileSize.equals-impl0((long)l4, (long)FileSize.Companion.getUnspecified-dkBenQQ()) ? 0L : l4) == 0L) {
                        f2 = ProgressKt.toProgress(0.0f);
                    } else {
                        l5 = l4 = l2;
                        float f3 = FileSize.equals-impl0((long)l4, (long)FileSize.Companion.getUnspecified-dkBenQQ()) ? 0L : l4;
                        l5 = l4 = l;
                        f2 = ProgressKt.toProgress(f3 / (float)(FileSize.equals-impl0((long)l4, (long)FileSize.Companion.getUnspecified-dkBenQQ()) ? 0L : l4));
                    }
                }
                f = f2;
            }
            this(l, l2, f, null);
        }

        public final long getTotalSize-dkBenQQ() {
            return this.totalSize;
        }

        public final long getDownloadedBytes-dkBenQQ() {
            return this.downloadedBytes;
        }

        public final float getDownloadProgress-4U8rbxw() {
            return this.downloadProgress;
        }

        public final String toString() {
            return "FileStats(totalSize=" + FileSize.toString-impl((long)this.totalSize) + ", downloadedBytes=" + FileSize.toString-impl((long)this.downloadedBytes) + ", downloadProgress=" + Progress.toString-impl(this.downloadProgress) + ")";
        }

        public final int hashCode() {
            int n = FileSize.hashCode-impl((long)this.totalSize);
            n = n * 31 + FileSize.hashCode-impl((long)this.downloadedBytes);
            n = n * 31 + Progress.hashCode-impl(this.downloadProgress);
            return n;
        }

        public final boolean equals(Object other) {
            FileStats fileStats;
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileStats)) {
                return false;
            }
            fileStats = fileStats;
            if (!FileSize.equals-impl0((long)this.totalSize, (long)fileStats.totalSize)) {
                return false;
            }
            if (!FileSize.equals-impl0((long)this.downloadedBytes, (long)fileStats.downloadedBytes)) {
                return false;
            }
            return Progress.equals-impl0(this.downloadProgress, fileStats.downloadProgress);
        }

        /*
         * WARNING - void declaration
         */
        public /* synthetic */ FileStats(long totalSize, long downloadedBytes, float downloadProgress, DefaultConstructorMarker $constructor_marker) {
            this((long)var1_1, (long)var3_2, downloadProgress);
            void var3_2;
            void var1_1;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Lme/him188/ani/app/domain/media/cache/MediaCache$FileStats$Companion;", "", "<init>", "()V", "Lme/him188/ani/app/domain/media/cache/MediaCache$FileStats;", "Unspecified", "Lme/him188/ani/app/domain/media/cache/MediaCache$FileStats;", "getUnspecified", "()Lme/him188/ani/app/domain/media/cache/MediaCache$FileStats;"})
        public static final class Companion {
            private Companion() {
            }

            public final FileStats getUnspecified() {
                return Unspecified;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0016R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0016\u001a\u0004\b\u0019\u0010\u0018R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c"}, d2={"Lme/him188/ani/app/domain/media/cache/MediaCache$SessionStats;", "", "Lme/him188/ani/datasources/api/topic/FileSize;", "totalSize", "downloadedBytes", "downloadSpeed", "uploadedBytes", "uploadSpeed", "Lme/him188/ani/app/tools/Progress;", "downloadProgress", "<init>", "(JJJJJFLkotlin/jvm/internal/DefaultConstructorMarker;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "J", "getDownloadedBytes-dkBenQQ", "()J", "getUploadSpeed-dkBenQQ", "F", "getDownloadProgress-4U8rbxw", "()F", "Companion"})
    public static final class SessionStats {
        public static final Companion Companion = new Companion(null);
        public final long totalSize;
        private final long downloadedBytes;
        public final long downloadSpeed;
        public final long uploadedBytes;
        private final long uploadSpeed;
        private final float downloadProgress;
        private static final SessionStats Unspecified = new SessionStats(FileSize.Companion.getUnspecified-dkBenQQ(), FileSize.Companion.getUnspecified-dkBenQQ(), FileSize.Companion.getUnspecified-dkBenQQ(), FileSize.Companion.getUnspecified-dkBenQQ(), FileSize.Companion.getUnspecified-dkBenQQ(), Progress.Companion.getUnspecified-4U8rbxw(), null);

        /*
         * WARNING - void declaration
         */
        private SessionStats(long totalSize, long downloadedBytes, long downloadSpeed, long uploadedBytes, long uploadSpeed, float downloadProgress) {
            void var3_2;
            void var1_1;
            this.totalSize = var1_1;
            this.downloadedBytes = var3_2;
            this.downloadSpeed = downloadSpeed;
            this.uploadedBytes = uploadedBytes;
            this.uploadSpeed = uploadSpeed;
            this.downloadProgress = downloadProgress;
        }

        public final long getDownloadedBytes-dkBenQQ() {
            return this.downloadedBytes;
        }

        public final long getUploadSpeed-dkBenQQ() {
            return this.uploadSpeed;
        }

        public final float getDownloadProgress-4U8rbxw() {
            return this.downloadProgress;
        }

        public final String toString() {
            return "SessionStats(totalSize=" + FileSize.toString-impl((long)this.totalSize) + ", downloadedBytes=" + FileSize.toString-impl((long)this.downloadedBytes) + ", downloadSpeed=" + FileSize.toString-impl((long)this.downloadSpeed) + ", uploadedBytes=" + FileSize.toString-impl((long)this.uploadedBytes) + ", uploadSpeed=" + FileSize.toString-impl((long)this.uploadSpeed) + ", downloadProgress=" + Progress.toString-impl(this.downloadProgress) + ")";
        }

        public final int hashCode() {
            int n = FileSize.hashCode-impl((long)this.totalSize);
            n = n * 31 + FileSize.hashCode-impl((long)this.downloadedBytes);
            n = n * 31 + FileSize.hashCode-impl((long)this.downloadSpeed);
            n = n * 31 + FileSize.hashCode-impl((long)this.uploadedBytes);
            n = n * 31 + FileSize.hashCode-impl((long)this.uploadSpeed);
            n = n * 31 + Progress.hashCode-impl(this.downloadProgress);
            return n;
        }

        public final boolean equals(Object other) {
            SessionStats sessionStats2;
            if (this == other) {
                return true;
            }
            if (!(other instanceof SessionStats)) {
                return false;
            }
            sessionStats2 = sessionStats2;
            if (!FileSize.equals-impl0((long)this.totalSize, (long)sessionStats2.totalSize)) {
                return false;
            }
            if (!FileSize.equals-impl0((long)this.downloadedBytes, (long)sessionStats2.downloadedBytes)) {
                return false;
            }
            if (!FileSize.equals-impl0((long)this.downloadSpeed, (long)sessionStats2.downloadSpeed)) {
                return false;
            }
            if (!FileSize.equals-impl0((long)this.uploadedBytes, (long)sessionStats2.uploadedBytes)) {
                return false;
            }
            if (!FileSize.equals-impl0((long)this.uploadSpeed, (long)sessionStats2.uploadSpeed)) {
                return false;
            }
            return Progress.equals-impl0(this.downloadProgress, sessionStats2.downloadProgress);
        }

        /*
         * WARNING - void declaration
         */
        public /* synthetic */ SessionStats(long totalSize, long downloadedBytes, long downloadSpeed, long uploadedBytes, long uploadSpeed, float downloadProgress, DefaultConstructorMarker $constructor_marker) {
            this((long)var1_1, (long)var3_2, downloadSpeed, uploadedBytes, uploadSpeed, downloadProgress);
            void var3_2;
            void var1_1;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Lme/him188/ani/app/domain/media/cache/MediaCache$SessionStats$Companion;", "", "<init>", "()V", "Lme/him188/ani/app/domain/media/cache/MediaCache$SessionStats;", "Unspecified", "Lme/him188/ani/app/domain/media/cache/MediaCache$SessionStats;", "getUnspecified", "()Lme/him188/ani/app/domain/media/cache/MediaCache$SessionStats;"})
        public static final class Companion {
            private Companion() {
            }

            public final SessionStats getUnspecified() {
                return Unspecified;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

