/*
 * Decompiled with CFR 0.152.
 */
package me.him188.ani.app.data.repository;

import io.ktor.client.plugins.ClientRequestException;
import io.ktor.client.plugins.ServerResponseException;
import io.ktor.http.HttpStatusCode;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.him188.ani.app.data.repository.RepositoryAuthorizationException;
import me.him188.ani.app.data.repository.RepositoryNetworkException;
import me.him188.ani.app.data.repository.RepositoryRateLimitedException;
import me.him188.ani.app.data.repository.RepositoryRequestError;
import me.him188.ani.app.data.repository.RepositoryServiceUnavailableException;
import me.him188.ani.app.data.repository.RepositoryUnknownException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u0000 \n2\u00060\u0001j\u0002`\u0002:\u0001\nB\t\b\u0014\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u001d\b\u0014\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0003\u0010\t\u0082\u0001\u0006\u000b\f\r\u000e\u000f\u0010"}, d2={"Lme/him188/ani/app/data/repository/RepositoryException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "()V", "", "message", "", "cause", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "Companion", "Lme/him188/ani/app/data/repository/RepositoryAuthorizationException;", "Lme/him188/ani/app/data/repository/RepositoryNetworkException;", "Lme/him188/ani/app/data/repository/RepositoryRateLimitedException;", "Lme/him188/ani/app/data/repository/RepositoryRequestError;", "Lme/him188/ani/app/data/repository/RepositoryServiceUnavailableException;", "Lme/him188/ani/app/data/repository/RepositoryUnknownException;"})
public abstract sealed class RepositoryException
extends Exception
permits RepositoryAuthorizationException, RepositoryNetworkException, RepositoryRateLimitedException, RepositoryRequestError, RepositoryServiceUnavailableException, RepositoryUnknownException {
    public static final Companion Companion = new Companion(null);
    public static final int $stable = 8;

    private RepositoryException() {
    }

    /*
     * WARNING - void declaration
     */
    private RepositoryException(String message, Throwable cause) {
        super((String)var1_1, (Throwable)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ RepositoryException(String message, Throwable cause, DefaultConstructorMarker $constructor_marker) {
        this((String)var1_1, (Throwable)var2_2);
        void var2_2;
        void var1_1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Lme/him188/ani/app/data/repository/RepositoryException$Companion;", "", "<init>", "()V", "", "cause", "Lme/him188/ani/app/data/repository/RepositoryException;", "wrapOrThrowCancellation", "(Ljava/lang/Throwable;)Lme/him188/ani/app/data/repository/RepositoryException;"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final RepositoryException wrapOrThrowCancellation(Throwable cause) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            Throwable throwable = cause;
            if (throwable instanceof CancellationException) {
                throw cause;
            }
            if (throwable instanceof RepositoryException) {
                return (RepositoryException)cause;
            }
            if (throwable instanceof ClientRequestException) {
                throwable = ((ClientRequestException)cause).getResponse().getStatus();
                if (Intrinsics.areEqual((Object)throwable, (Object)HttpStatusCode.Companion.getUnauthorized())) {
                    return new RepositoryAuthorizationException(((ClientRequestException)cause).getResponse().getStatus().getDescription(), null, 2, null);
                }
                if (Intrinsics.areEqual((Object)throwable, (Object)HttpStatusCode.Companion.getForbidden())) {
                    return new RepositoryAuthorizationException(((ClientRequestException)cause).getResponse().getStatus().getDescription(), null, 2, null);
                }
                if (Intrinsics.areEqual((Object)throwable, (Object)HttpStatusCode.Companion.getTooManyRequests())) {
                    return new RepositoryRateLimitedException(((ClientRequestException)cause).getResponse().getStatus().getDescription(), null, 2, null);
                }
                return new RepositoryUnknownException(cause);
            }
            if (throwable instanceof IOException) {
                return new RepositoryNetworkException(null, cause);
            }
            if (throwable instanceof ServerResponseException) {
                return new RepositoryServiceUnavailableException(((ServerResponseException)cause).getResponse().getStatus().getDescription(), null, 2, null);
            }
            return new RepositoryUnknownException((Throwable)var1_1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

