/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.kotlinruntime.Vocabulary;
import org.antlr.v4.kotlinruntime.misc.IntSet;
import org.antlr.v4.kotlinruntime.misc.Interval;
import org.antlr.v4.kotlinruntime.misc.MurmurHash;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\f\u0018\u0000 ;2\u00020\u0001:\u0001;B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\rJ\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\t\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001a\u0010\u001f\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0096\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b#\u0010\u0012J\u0017\u0010$\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b$\u0010\nJ\u000f\u0010%\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b%\u0010\"J\u0017\u0010&\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b&\u0010\u0012J\u0015\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060'H\u0016\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010*\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u0015\u00a2\u0006\u0004\b*\u0010-J\u0015\u0010*\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b*\u0010.R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e0/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0014\u00102\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R$\u00105\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u00158\u0006@FX\u0086\u000e\u00a2\u0006\f\n\u0004\b5\u00106\"\u0004\b7\u00108R\u0011\u0010:\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\""}, d2={"Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;", "Lorg/antlr/v4/kotlinruntime/misc/IntSet;", "<init>", "()V", "set", "(Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;)V", "", "el", "", "add", "(I)V", "a", "b", "(II)V", "Lorg/antlr/v4/kotlinruntime/misc/Interval;", "addition", "(Lorg/antlr/v4/kotlinruntime/misc/Interval;)V", "addAll", "(Lorg/antlr/v4/kotlinruntime/misc/IntSet;)Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;", "elements", "complement", "", "contains", "(I)Z", "Lorg/antlr/v4/kotlinruntime/Vocabulary;", "vocabulary", "", "elementName", "(Lorg/antlr/v4/kotlinruntime/Vocabulary;I)Ljava/lang/String;", "", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "or", "remove", "size", "subtract", "", "toList", "()Ljava/util/List;", "toString", "()Ljava/lang/String;", "elemAreChar", "(Z)Ljava/lang/String;", "(Lorg/antlr/v4/kotlinruntime/Vocabulary;)Ljava/lang/String;", "", "_intervals", "Ljava/util/List;", "isNil", "()Z", "value", "isReadonly", "Z", "setReadonly", "(Z)V", "getMinElement", "minElement", "Companion"})
public final class IntervalSet
implements IntSet {
    public static final Companion Companion;
    private final List<Interval> _intervals;
    private boolean isReadonly;
    @JvmField
    public static final IntervalSet COMPLETE_CHAR_SET;
    @JvmField
    public static final IntervalSet EMPTY_SET;

    @Override
    public final boolean isNil() {
        return this._intervals.size() == 0;
    }

    public final int getMinElement() {
        if (this.isNil()) {
            throw new RuntimeException("set is empty");
        }
        return this._intervals.get(0).getA();
    }

    /*
     * WARNING - void declaration
     */
    public final void setReadonly(boolean value) {
        void var1_1;
        if (this.isReadonly && !value) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        this.isReadonly = var1_1;
    }

    public IntervalSet() {
        this._intervals = new ArrayList(16);
    }

    /*
     * WARNING - void declaration
     */
    public IntervalSet(IntervalSet set) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        this._intervals = new ArrayList(set._intervals.size());
        this.addAll((IntSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void add(int el) {
        void var1_1;
        void v0 = var1_1;
        this.add((int)v0, (int)v0);
    }

    /*
     * WARNING - void declaration
     */
    public final void add(int a, int b) {
        void var2_2;
        void var1_1;
        this.add(Interval.Companion.of((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private final void add(Interval addition) {
        void var1_1;
        if (this.isReadonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        if (addition.getB() < addition.getA()) {
            return;
        }
        ListIterator<Interval> iter = this._intervals.listIterator();
        while (iter.hasNext()) {
            void var2_2;
            void var3_3;
            Interval r = iter.next();
            if (Intrinsics.areEqual((Object)addition, (Object)r)) {
                return;
            }
            if (addition.adjacent(r) || !addition.disjoint(r)) {
                Interval next;
                Interval bigger = addition.union(r);
                iter.set(bigger);
                while (iter.hasNext() && (bigger.adjacent(next = iter.next()) || !bigger.disjoint(next))) {
                    iter.remove();
                    iter.previous();
                    iter.set(bigger.union((Interval)var3_3));
                    iter.next();
                }
                return;
            }
            if (!var1_1.startsBeforeDisjoint((Interval)var3_3)) continue;
            iter.previous();
            var2_2.add(var1_1);
            return;
        }
        this._intervals.add((Interval)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final IntervalSet addAll(IntSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        if (set instanceof IntervalSet) {
            List<Interval> setIntervals = ((IntervalSet)set)._intervals;
            int n = setIntervals.size();
            for (int i = 0; i < n; ++i) {
                Interval I = setIntervals.get(i);
                this.add(I.getA(), I.getB());
            }
        } else {
            Iterator<Integer> iterator;
            iterator = iterator.toList().iterator();
            while (iterator.hasNext()) {
                void var2_3;
                int value = ((Number)iterator.next()).intValue();
                this.add((int)var2_3);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final IntervalSet complement(IntSet elements) {
        IntervalSet intervalSet;
        IntervalSet intervalSet2;
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if (elements.isNil()) {
            return new IntervalSet();
        }
        if (elements instanceof IntervalSet) {
            intervalSet2 = (IntervalSet)elements;
        } else {
            void var2_2;
            IntervalSet temp = new IntervalSet();
            temp.addAll(intervalSet);
            intervalSet2 = var2_2;
        }
        intervalSet = intervalSet2;
        return intervalSet2.subtract(this);
    }

    /*
     * WARNING - void declaration
     */
    public final IntervalSet subtract(IntSet a) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (a.isNil()) {
            return new IntervalSet(this);
        }
        if (a instanceof IntervalSet) {
            return Companion.subtract(this, (IntervalSet)a);
        }
        IntervalSet other = new IntervalSet();
        other.addAll((IntSet)var1_1);
        return Companion.subtract(this, (IntervalSet)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final IntervalSet or(IntSet a) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        IntervalSet o = new IntervalSet();
        o.addAll(this);
        o.addAll((IntSet)var1_1);
        return var2_2;
    }

    public final boolean contains(int el) {
        int n = this._intervals.size();
        int l = 0;
        int r = n - 1;
        while (l <= r) {
            int m = (l + r) / 2;
            Interval I = this._intervals.get(m);
            int a = I.getA();
            int n2 = I.getB();
            if (n2 < el) {
                l = m + 1;
                continue;
            }
            if (a > el) {
                r = m - 1;
                continue;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        int n;
        int hash = MurmurHash.initialize$default(MurmurHash.INSTANCE, 0, 1, null);
        for (Interval I : this._intervals) {
            void var3_3;
            hash = MurmurHash.INSTANCE.update(hash, I.getA());
            hash = MurmurHash.INSTANCE.update(hash, var3_3.getB());
        }
        n = MurmurHash.INSTANCE.finish(n, this._intervals.size() << 1);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof IntervalSet && Intrinsics.areEqual(this._intervals, ((IntervalSet)var1_1)._intervals);
    }

    public final String toString() {
        return this.toString(false);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(boolean elemAreChar) {
        void var2_2;
        if (this._intervals.isEmpty()) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder(64);
        if (this.size() > 1) {
            buf.append("{");
        }
        int n = this._intervals.size();
        int index = 0;
        while (index < n) {
            int b;
            Interval I;
            int a;
            if ((a = (I = this._intervals.get(index++)).getA()) == (b = I.getB())) {
                if (a == -1) {
                    buf.append("<EOF>");
                } else if (elemAreChar) {
                    buf.append("'");
                    buf.appendCodePoint(a);
                    buf.append("'");
                } else {
                    buf.append(a);
                }
            } else if (elemAreChar) {
                buf.append("'");
                buf.appendCodePoint(a);
                buf.append("'..'");
                buf.appendCodePoint(b);
                buf.append("'");
            } else {
                buf.append(a);
                buf.append("..");
                buf.append(b);
            }
            if (index >= n) continue;
            buf.append(", ");
        }
        if (this.size() > 1) {
            buf.append("}");
        }
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(Vocabulary vocabulary) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)vocabulary, (String)"vocabulary");
        if (this._intervals.isEmpty()) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder(64);
        if (this.size() > 1) {
            buf.append("{");
        }
        int n = this._intervals.size();
        int index = 0;
        while (index < n) {
            int b;
            Interval I;
            int a;
            if ((a = (I = this._intervals.get(index++)).getA()) == (b = I.getB())) {
                buf.append(this.elementName(vocabulary, a));
            } else {
                int p = a;
                if (p <= b) {
                    while (true) {
                        if (p > a) {
                            buf.append(", ");
                        }
                        buf.append(this.elementName(vocabulary, p));
                        if (p == b) break;
                        ++p;
                    }
                }
            }
            if (index >= n) continue;
            buf.append(", ");
        }
        if (this.size() > 1) {
            buf.append("}");
        }
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String elementName(Vocabulary vocabulary, int a) {
        void var2_2;
        void var1_1;
        switch (a) {
            case -1: {
                return "<EOF>";
            }
            case -2: {
                return "<EPSILON>";
            }
        }
        return var1_1.getDisplayName((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int size() {
        void var2_3;
        int numIntervals = this._intervals.size();
        if (numIntervals == 1) {
            Interval firstInterval = this._intervals.get(0);
            return firstInterval.getB() - firstInterval.getA() + 1;
        }
        int n = 0;
        for (int i = 0; i < numIntervals; ++i) {
            Interval I = this._intervals.get(i);
            n += I.getB() - I.getA() + 1;
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Integer> toList() {
        void var1_1;
        ArrayList<Integer> values = new ArrayList<Integer>(32);
        int n = this._intervals.size();
        block0: for (int i = 0; i < n; ++i) {
            int b;
            Interval I = this._intervals.get(i);
            int a = I.getA();
            int v = a;
            if (v > (b = I.getB())) continue;
            while (true) {
                values.add(v);
                if (v == b) continue block0;
                ++v;
            }
        }
        return (List)var1_1;
    }

    public final void remove(int el) {
        if (this.isReadonly) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        int n = this._intervals.size();
        for (int i = 0; i < n; ++i) {
            Interval I = this._intervals.get(i);
            int a = I.getA();
            int b = I.getB();
            if (el < a) break;
            if (el == a && el == b) {
                this._intervals.remove(i);
                return;
            }
            if (el == a) {
                a = I.getA();
                I.setA(a + 1);
                return;
            }
            if (el == b) {
                a = I.getB();
                I.setB(a + -1);
                return;
            }
            if (el >= b) continue;
            int oldB = I.getB();
            I.setB(el - 1);
            this.add(el + 1, oldB);
        }
    }

    static {
        IntervalSet intervalSet;
        Companion = new Companion(null);
        IntervalSet intervalSet2 = intervalSet = Companion.of(0, 0x10FFFF);
        intervalSet.setReadonly(true);
        COMPLETE_CHAR_SET = intervalSet;
        intervalSet2 = intervalSet = new IntervalSet();
        intervalSet.setReadonly(true);
        EMPTY_SET = intervalSet;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\nJ\u001d\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010"}, d2={"Lorg/antlr/v4/kotlinruntime/misc/IntervalSet$Companion;", "", "<init>", "()V", "", "a", "Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;", "of", "(I)Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;", "b", "(II)Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;", "left", "right", "subtract", "(Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;)Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;", "COMPLETE_CHAR_SET", "Lorg/antlr/v4/kotlinruntime/misc/IntervalSet;", "EMPTY_SET"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final IntervalSet of(int a) {
            void var2_2;
            void var1_1;
            IntervalSet s = new IntervalSet();
            s.add((int)var1_1);
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final IntervalSet of(int a, int b) {
            void var3_3;
            void var2_2;
            void var1_1;
            IntervalSet s = new IntervalSet();
            s.add((int)var1_1, (int)var2_2);
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public final IntervalSet subtract(IntervalSet left, IntervalSet right) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (left.isNil()) {
                return new IntervalSet();
            }
            IntervalSet result = new IntervalSet(left);
            if (right.isNil()) {
                return result;
            }
            int resultI = 0;
            int rightI = 0;
            while (resultI < result._intervals.size() && rightI < right._intervals.size()) {
                Interval resultInterval = (Interval)result._intervals.get(resultI);
                Interval rightInterval = (Interval)right._intervals.get(rightI);
                if (rightInterval.getB() < resultInterval.getA()) {
                    ++rightI;
                    continue;
                }
                if (rightInterval.getA() > resultInterval.getB()) {
                    ++resultI;
                    continue;
                }
                Interval beforeCurrent = null;
                Interval afterCurrent = null;
                if (rightInterval.getA() > resultInterval.getA()) {
                    beforeCurrent = new Interval(resultInterval.getA(), rightInterval.getA() - 1);
                }
                if (rightInterval.getB() < resultInterval.getB()) {
                    afterCurrent = new Interval(rightInterval.getB() + 1, resultInterval.getB());
                }
                if (beforeCurrent != null) {
                    if (afterCurrent != null) {
                        result._intervals.set(resultI, beforeCurrent);
                        result._intervals.add(resultI + 1, afterCurrent);
                        ++resultI;
                        ++rightI;
                        continue;
                    }
                    result._intervals.set(resultI, beforeCurrent);
                    ++resultI;
                    continue;
                }
                if (afterCurrent != null) {
                    result._intervals.set(resultI, afterCurrent);
                    ++rightI;
                    continue;
                }
                result._intervals.remove(resultI);
            }
            return var1_1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

