/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.driver.bundled;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0014\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\nJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013"}, d2={"Landroidx/sqlite/driver/bundled/NativeLibraryLoader;", "", "<init>", "()V", "", "name", "", "loadLibrary", "(Ljava/lang/String;)V", "getLibraryName", "(Ljava/lang/String;)Ljava/lang/String;", "libName", "getResourceName", "path", "tryLoad", "LIB_PATH_PROPERTY_NAME", "Ljava/lang/String;", "LIB_NAME_PROPERTY_NAME", "getOsName", "()Ljava/lang/String;", "osName", "getOsArch", "osArch", "getOsPrefix", "osPrefix", "getArchSuffix", "archSuffix"})
@SourceDebugExtension(value={"SMAP\nNativeLibraryLoader.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeLibraryLoader.jvm.kt\nandroidx/sqlite/driver/bundled/NativeLibraryLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
public final class NativeLibraryLoader {
    public static final NativeLibraryLoader INSTANCE = new NativeLibraryLoader();
    private static final String LIB_PATH_PROPERTY_NAME = "androidx.sqlite.driver.bundled.path";
    private static final String LIB_NAME_PROPERTY_NAME = "androidx.sqlite.driver.bundled.name";

    private NativeLibraryLoader() {
    }

    private final String getOsName() {
        String string;
        block3: {
            block2: {
                string = System.getProperty("os.name");
                if (string == null) break block2;
                String string2 = string;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = string3;
                if (string3 != null) break block3;
            }
            throw new IllegalStateException("Cannot read osName".toString());
        }
        return string;
    }

    private final String getOsArch() {
        String string;
        block3: {
            block2: {
                string = System.getProperty("os.arch");
                if (string == null) break block2;
                String string2 = string;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = string3;
                if (string3 != null) break block3;
            }
            throw new IllegalStateException("Cannot read osArch".toString());
        }
        return string;
    }

    private final String getOsPrefix() {
        if (StringsKt.contains$default((CharSequence)this.getOsName(), (CharSequence)"linux", (boolean)false, (int)2, null)) {
            return "linux";
        }
        if (StringsKt.contains$default((CharSequence)this.getOsName(), (CharSequence)"mac", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)this.getOsName(), (CharSequence)"osx", (boolean)false, (int)2, null)) {
            return "osx";
        }
        if (StringsKt.contains$default((CharSequence)this.getOsName(), (CharSequence)"windows", (boolean)false, (int)2, null)) {
            return "windows";
        }
        throw new IllegalStateException(("Unsupported operating system: " + this.getOsName()).toString());
    }

    private final String getArchSuffix() {
        if (Intrinsics.areEqual((Object)this.getOsArch(), (Object)"aarch64")) {
            return "arm64";
        }
        if (StringsKt.contains$default((CharSequence)this.getOsArch(), (CharSequence)"arm", (boolean)false, (int)2, null)) {
            if (StringsKt.contains$default((CharSequence)this.getOsArch(), (CharSequence)"64", (boolean)false, (int)2, null)) {
                return "arm64";
            }
            return "arm32";
        }
        if (StringsKt.contains$default((CharSequence)this.getOsArch(), (CharSequence)"64", (boolean)false, (int)2, null)) {
            return "x64";
        }
        if (StringsKt.contains$default((CharSequence)this.getOsArch(), (CharSequence)"86", (boolean)false, (int)2, null)) {
            return "x86";
        }
        throw new IllegalStateException(("Unsupported architecture: " + this.getOsArch()).toString());
    }

    public final void loadLibrary(String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        NativeLibraryLoader nativeLibraryLoader = this;
        synchronized (nativeLibraryLoader) {
            try {
                System.loadLibrary(name);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                CopyOption[] copyOptionArray;
                Object object;
                String libraryPath = System.getProperty(LIB_PATH_PROPERTY_NAME);
                if (libraryPath != null) {
                    String libName;
                    File libFile;
                    String string = System.getProperty(LIB_NAME_PROPERTY_NAME);
                    if (string == null) {
                        string = INSTANCE.getLibraryName(name);
                    }
                    if (!(libFile = new File(libraryPath, libName = string)).exists()) {
                        libraryPath = "Cannot find a suitable SQLite binary for " + INSTANCE.getOsName() + " | " + INSTANCE.getOsArch() + " at the configured path (androidx.sqlite.driver.bundled.path = " + libraryPath + "). File " + libFile + " does not exist.";
                        throw new IllegalStateException(libraryPath.toString());
                    }
                    String string2 = libFile.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
                    INSTANCE.tryLoad(string2);
                    return;
                }
                String libName = INSTANCE.getLibraryName(name);
                File libFile = new File(System.getProperty("java.home"), Intrinsics.areEqual((Object)INSTANCE.getOsPrefix(), (Object)"windows") ? "bin" : "lib");
                File libFile2 = FilesKt.resolve((File)libFile, (String)libName);
                if (libFile2.exists()) {
                    String string = libFile2.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
                    INSTANCE.tryLoad(string);
                    return;
                }
                String libResourceName = INSTANCE.getResourceName(libName);
                Object object2 = object = Files.createTempFile("androidx_" + (String)object, null, new FileAttribute[0]);
                object.toFile().deleteOnExit();
                Path libTempCopy = object;
                ClassLoader classLoader = NativeLibraryLoader.class.getClassLoader();
                Intrinsics.checkNotNull((Object)classLoader);
                object = classLoader.getResourceAsStream(libResourceName);
                object2 = null;
                try {
                    Object resourceStream = (InputStream)object;
                    if (resourceStream == null) {
                        resourceStream = "Cannot find a suitable SQLite binary for " + INSTANCE.getOsName() + " | " + INSTANCE.getOsArch() + ". Please file a bug at https://issuetracker.google.com/issues/new?component=460784";
                        throw new IllegalStateException(resourceStream.toString());
                    }
                    CopyOption[] copyOptionArray2 = copyOptionArray;
                    CopyOption[] copyOptionArray3 = new CopyOption[1];
                    copyOptionArray = copyOptionArray3;
                    copyOptionArray3[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.copy((InputStream)copyOptionArray2, libTempCopy, copyOptionArray);
                }
                catch (Throwable copyOptionArray4) {
                    try {
                        copyOptionArray = copyOptionArray4;
                        object2 = copyOptionArray4;
                        throw copyOptionArray;
                    }
                    catch (Throwable throwable) {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                        throw throwable;
                    }
                }
                CloseableKt.closeFinally((Closeable)object, null);
                String string = libTempCopy.toFile().getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
                INSTANCE.tryLoad(string);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getLibraryName(String name) {
        String string;
        void var1_1;
        void var2_3;
        String string2;
        String string3;
        switch (this.getOsPrefix()) {
            case "osx": 
            case "linux": {
                string3 = "lib";
                break;
            }
            case "windows": {
                string3 = "";
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported operating system: " + this.getOsName()).toString());
            }
        }
        String prefix = string3;
        switch (this.getOsPrefix()) {
            case "linux": {
                string2 = "so";
                break;
            }
            case "osx": {
                string2 = "dylib";
                break;
            }
            case "windows": {
                string2 = "dll";
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported operating system: " + this.getOsName()).toString());
            }
        }
        String extension = string2;
        return (String)var2_3 + (String)var1_1 + '.' + string;
    }

    /*
     * WARNING - void declaration
     */
    private final String getResourceName(String libName) {
        void var1_1;
        void var2_2;
        String resourceFolder = this.getOsPrefix() + '_' + this.getArchSuffix();
        return "natives/" + (String)var2_2 + '/' + (String)var1_1;
    }

    private final void tryLoad(String path) {
        System.load(path);
    }
}

