/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.heartbeatinfo;

import android.content.SharedPreferences;
import android.os.Build;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class HeartBeatInfoStorage {
    private static HeartBeatInfoStorage instance = null;
    private final SharedPreferences firebaseSharedPreferences;

    private synchronized String getStoredUserAgentString(String dateString) {
        for (Map.Entry<String, String> entry : this.firebaseSharedPreferences.getAll().entrySet()) {
            if (!(entry.getValue() instanceof Set)) continue;
            Object object = (Set)((Object)entry.getValue());
            object = object.iterator();
            while (object.hasNext()) {
                String date = (String)object.next();
                if (!dateString.equals(date)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void updateStoredUserAgent(String userAgent, String dateString) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.removeStoredDate(dateString);
        HashSet<void> userAgentDateSet = new HashSet<void>(this.firebaseSharedPreferences.getStringSet(userAgent, new HashSet()));
        userAgentDateSet.add(var2_2);
        this.firebaseSharedPreferences.edit().putStringSet((String)var1_1, (Set)var3_3).commit();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void removeStoredDate(String dateString) {
        void var3_3;
        void var2_2;
        void var1_1;
        String userAgentString = this.getStoredUserAgentString(dateString);
        if (userAgentString == null) {
            return;
        }
        HashSet userAgentDateSet = new HashSet(this.firebaseSharedPreferences.getStringSet(userAgentString, new HashSet()));
        userAgentDateSet.remove(var1_1);
        if (userAgentDateSet.isEmpty()) {
            this.firebaseSharedPreferences.edit().remove(userAgentString).commit();
            return;
        }
        this.firebaseSharedPreferences.edit().putStringSet((String)var2_2, (Set)var3_3).commit();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized String getFormattedDate(long millis2) {
        void var1_1;
        if (Build.VERSION.SDK_INT >= 26) {
            Comparable<Instant> millis2 = new Date(millis2).toInstant();
            millis2 = millis2.atOffset(ZoneOffset.UTC).toLocalDateTime();
            return ((LocalDateTime)millis2).format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        return new SimpleDateFormat("yyyy-MM-dd", Locale.UK).format(new Date((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    synchronized void storeHeartBeat(long millis, String userAgentString) {
        void var1_2;
        void var3_3;
        String dateString = this.getFormattedDate(millis);
        String string = this.firebaseSharedPreferences.getString("last-used-date", "");
        if (string.equals(dateString)) {
            String storedUserAgentString = this.getStoredUserAgentString(dateString);
            if (storedUserAgentString == null) {
                return;
            }
            if (storedUserAgentString.equals(userAgentString)) {
                return;
            }
            this.updateStoredUserAgent(userAgentString, dateString);
            return;
        }
        long heartBeatCount = this.firebaseSharedPreferences.getLong("fire-count", 0L);
        if (heartBeatCount + 1L == 30L) {
            this.cleanUpStoredHeartBeats();
            heartBeatCount = this.firebaseSharedPreferences.getLong("fire-count", 0L);
        }
        HashSet<String> userAgentDateSet = new HashSet<String>(this.firebaseSharedPreferences.getStringSet(userAgentString, new HashSet()));
        userAgentDateSet.add(dateString);
        this.firebaseSharedPreferences.edit().putStringSet((String)var3_3, (Set)((Object)string)).putLong("fire-count", ++heartBeatCount).putString("last-used-date", (String)var1_2).commit();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void cleanUpStoredHeartBeats() {
        void var1_1;
        void var3_2;
        long heartBeatCount = this.firebaseSharedPreferences.getLong("fire-count", 0L);
        String lowestDate = null;
        String userAgentString = "";
        for (Map.Entry<String, String> entry : this.firebaseSharedPreferences.getAll().entrySet()) {
            if (!(entry.getValue() instanceof Set)) continue;
            Object object = (Set)((Object)entry.getValue());
            object = object.iterator();
            while (object.hasNext()) {
                String date = (String)object.next();
                if (lowestDate != null && lowestDate.compareTo(date) <= 0) continue;
                lowestDate = date;
                userAgentString = entry.getKey();
            }
        }
        HashSet userAgentDateSet = new HashSet(this.firebaseSharedPreferences.getStringSet(userAgentString, new HashSet()));
        userAgentDateSet.remove(var3_2);
        this.firebaseSharedPreferences.edit().putStringSet(userAgentString, userAgentDateSet).putLong("fire-count", (long)(var1_1 - 1L)).commit();
    }
}

