/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.heartbeatinfo;

import android.content.Context;
import androidx.core.os.UserManagerCompat;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.heartbeatinfo.HeartBeatInfoStorage;
import com.google.firebase.inject.Provider;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.util.Set;
import java.util.concurrent.Executor;

public class DefaultHeartBeatController {
    private final Provider<HeartBeatInfoStorage> storageProvider;
    private final Context applicationContext;
    private final Provider<UserAgentPublisher> userAgentProvider;
    private final Set<Object> consumers;
    private final Executor backgroundExecutor;

    public Task<Void> registerHeartBeat() {
        if (this.consumers.size() <= 0) {
            return Tasks.forResult(null);
        }
        boolean bl = !UserManagerCompat.isUserUnlocked(this.applicationContext);
        if (bl) {
            return Tasks.forResult(null);
        }
        return Tasks.call(this.backgroundExecutor, () -> {
            DefaultHeartBeatController defaultHeartBeatController = this;
            synchronized (defaultHeartBeatController) {
                this.storageProvider.get().storeHeartBeat(System.currentTimeMillis(), this.userAgentProvider.get().getUserAgent());
            }
            return null;
        });
    }
}

