/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.components.ComponentRuntime;
import com.google.firebase.heartbeatinfo.DefaultHeartBeatController;
import com.google.firebase.inject.Provider;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class FirebaseApp {
    private static final Object LOCK = new Object();
    static final Map<String, FirebaseApp> INSTANCES = new ArrayMap();
    private final String name;
    private final FirebaseOptions options;
    private final ComponentRuntime componentRuntime;
    private final AtomicBoolean deleted;
    private final Provider<DefaultHeartBeatController> defaultHeartBeatController;

    public String getName() {
        this.checkNotDeleted();
        return this.name;
    }

    public FirebaseOptions getOptions() {
        this.checkNotDeleted();
        return this.options;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (!(o instanceof FirebaseApp)) {
            return false;
        }
        return this.name.equals(((FirebaseApp)var1_1).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.name).add("options", this.options).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static FirebaseApp getInstance() {
        Object object = LOCK;
        synchronized (object) {
            void var1_1;
            FirebaseApp defaultApp = INSTANCES.get("[DEFAULT]");
            if (defaultApp == null) {
                throw new IllegalStateException("Default FirebaseApp is not initialized in this process " + ProcessUtils.getMyProcessName() + ". Make sure to call FirebaseApp.initializeApp(Context) first.");
            }
            defaultApp.defaultHeartBeatController.get().registerHeartBeat();
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> T get(Class<T> anInterface) {
        void var1_1;
        this.checkNotDeleted();
        return this.componentRuntime.get(var1_1);
    }

    private void checkNotDeleted() {
        Preconditions.checkState(!this.deleted.get(), "FirebaseApp was deleted");
    }

    public boolean isDefaultApp() {
        return "[DEFAULT]".equals(this.getName());
    }
}

