/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.DuplicateTaskCompletionException;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzj;
import com.google.android.gms.tasks.zzl;
import com.google.android.gms.tasks.zzn;
import com.google.android.gms.tasks.zzr;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;

final class zzw<TResult>
extends Task<TResult> {
    private final Object zza;
    private final zzr zzb;
    private boolean zzc;
    private volatile boolean zzd;
    private Object zze;
    private Exception zzf;

    @Override
    public final Task<TResult> addOnCompleteListener(Executor executor, OnCompleteListener<TResult> onCompleteListener) {
        zzj zzj2;
        zzr zzr2 = this.zzb;
        zzj zzj3 = zzj2;
        zzj2 = new zzj(executor, onCompleteListener);
        zzr2.zza(zzj3);
        this.zzi();
        return this;
    }

    @Override
    public final Task<TResult> addOnFailureListener(OnFailureListener onFailureListener) {
        this.addOnFailureListener(TaskExecutors.MAIN_THREAD, onFailureListener);
        return this;
    }

    public final Task<TResult> addOnFailureListener(Executor executor, OnFailureListener onFailureListener) {
        zzl zzl2;
        zzr zzr2 = this.zzb;
        zzl zzl3 = zzl2;
        zzl2 = new zzl(executor, onFailureListener);
        zzr2.zza(zzl3);
        this.zzi();
        return this;
    }

    @Override
    public final Task<TResult> addOnSuccessListener(OnSuccessListener<? super TResult> onSuccessListener) {
        this.addOnSuccessListener(TaskExecutors.MAIN_THREAD, onSuccessListener);
        return this;
    }

    public final Task<TResult> addOnSuccessListener(Executor executor, OnSuccessListener<? super TResult> onSuccessListener) {
        zzn zzn2;
        zzr zzr2 = this.zzb;
        zzn zzn3 = zzn2;
        zzn2 = new zzn(executor, onSuccessListener);
        zzr2.zza(zzn3);
        this.zzi();
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Exception getException() {
        Object object = ((zzw)this).zza;
        synchronized (object) {
            try {
                return ((zzw)this).zzf;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final TResult getResult() {
        Object object = ((zzw)object2).zza;
        synchronized (object) {
            Object object2;
            ((zzw)object2).zzf();
            ((zzw)object2).zzg();
            Exception exception = ((zzw)object2).zzf;
            if (exception != null) {
                object2 = new RuntimeExecutionException(exception);
                throw object2;
            }
            object2 = ((zzw)object2).zze;
            return (TResult)object2;
        }
    }

    zzw() {
        zzr zzr2;
        Object object;
        Object object2 = object;
        object = new Object();
        this.zza = object2;
        object2 = zzr2;
        zzr2 = new zzr();
        this.zzb = object2;
    }

    private final void zzf() {
        Preconditions.checkState(this.zzc, "Task is not yet complete");
    }

    private final void zzg() {
        if (((zzw)((Object)cancellationException2)).zzd) {
            CancellationException cancellationException;
            CancellationException cancellationException2 = cancellationException;
            cancellationException = new CancellationException("Task is already canceled.");
            throw cancellationException2;
        }
    }

    private final void zzh() {
        if (this.zzc) {
            throw DuplicateTaskCompletionException.of(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzi() {
        Object object = this.zza;
        synchronized (object) {
            block4: {
                boolean bl = this.zzc;
                if (bl) break block4;
                return;
            }
            this.zzb.zzb(this);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zza(Exception exception) {
        Preconditions.checkNotNull(exception, "Exception must not be null");
        Object object = this.zza;
        synchronized (object) {
            try {
                this.zzh();
                this.zzc = true;
                this.zzf = exception;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var2_3
                this.zzb.zzb(this);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zzb(Object object) {
        Object object2 = this.zza;
        synchronized (object2) {
            try {
                this.zzh();
                this.zzc = true;
                this.zze = object;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_3
                this.zzb.zzb(this);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    @Override
    public final boolean isCanceled() {
        return this.zzd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean isComplete() {
        Object object = this.zza;
        synchronized (object) {
            try {
                return this.zzc;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean isSuccessful() {
        Object object = ((zzw)((Object)exception)).zza;
        synchronized (object) {
            boolean bl;
            try {
                bl = ((zzw)((Object)exception)).zzc;
                if (!bl) return false;
            }
            catch (Throwable throwable) {}
            {
                throw throwable;
            }
            bl = ((zzw)((Object)exception)).zzd;
            if (bl) return false;
            Exception exception = ((zzw)((Object)exception)).zzf;
            if (exception != null) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzc() {
        Object object = this.zza;
        synchronized (object) {
            block5: {
                try {
                    boolean bl = this.zzc;
                    if (!bl) break block5;
                }
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
                return false;
            }
            this.zzc = true;
            this.zzd = true;
            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var1_2
            this.zzb.zzb(this);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zze(Object object) {
        Object object2 = this.zza;
        synchronized (object2) {
            block5: {
                try {
                    boolean bl = this.zzc;
                    if (!bl) break block5;
                }
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
                return false;
            }
            this.zzc = true;
            this.zze = object;
            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_3
            this.zzb.zzb(this);
            return true;
        }
    }
}

