/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcelable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\b&\u0018\u0000 \u00122\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0007\u0013\u0014\u0015\u0016\u0017\u0018\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\b\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH&\u00a2\u0006\u0004\b\u0010\u0010\u0011"}, d2={"Landroid/net/Uri;", "Landroid/os/Parcelable;", "", "<init>", "()V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "compareTo", "(Landroid/net/Uri;)I", "", "toString", "()Ljava/lang/String;", "Companion", "StringUri", "AbstractHierarchicalUri", "HierarchicalUri", "AbstractPart", "Part", "PathPart"})
public abstract class Uri
implements Parcelable,
Comparable<Uri> {
    public static final Companion Companion = new Companion(null);
    private static final String LOG;
    private static final Uri EMPTY;
    private static final Parcelable.Creator<Uri> CREATOR;
    private static final char[] HEX_DIGITS;

    private Uri() {
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        if (!(other instanceof Uri)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.toString(), (Object)((Uri)var1_1).toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Uri other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.toString().compareTo(var1_1.toString());
    }

    public abstract String toString();

    public /* synthetic */ Uri(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        String string = Uri.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        LOG = string;
        EMPTY = new HierarchicalUri(null, Part.Companion.getNULL(), PathPart.Companion.getEMPTY(), Part.Companion.getNULL(), Part.Companion.getNULL());
        CREATOR = new Parcelable.Creator<Uri>(){};
        char[] cArray = "0123456789ABCDEF".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        HEX_DIGITS = cArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b#\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00048V@\u0016X\u0096\f\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0016\u0010\b\u001a\u00020\u00078V@\u0016X\u0096\f\u00a2\u0006\u0006\n\u0004\b\b\u0010\t"}, d2={"Landroid/net/Uri$AbstractHierarchicalUri;", "Landroid/net/Uri;", "<init>", "()V", "", "host", "Ljava/lang/String;", "", "port", "I"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$AbstractHierarchicalUri\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
    private static abstract class AbstractHierarchicalUri
    extends Uri {
        public volatile String host = "NOT CACHED";
        public volatile int port = -2;

        public AbstractHierarchicalUri() {
            super(null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b'\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R$\u0010\u0007\u001a\u0004\u0018\u00010\u00028\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u0004\u0018\u00010\u00028\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\b\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\f"}, d2={"Landroid/net/Uri$AbstractPart;", "", "", "encoded", "decoded", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "_encoded", "Ljava/lang/String;", "get_encoded", "()Ljava/lang/String;", "set_encoded", "(Ljava/lang/String;)V", "_decoded", "get_decoded", "set_decoded"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$AbstractPart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
    public static abstract class AbstractPart {
        private volatile String _encoded;
        private volatile String _decoded;

        /*
         * WARNING - void declaration
         */
        public AbstractPart(String encoded, String decoded) {
            if (encoded != "NOT CACHED") {
                void var1_1;
                this._encoded = var1_1;
                this._decoded = "NOT CACHED";
                return;
            }
            if (decoded != "NOT CACHED") {
                void var2_2;
                this._encoded = "NOT CACHED";
                this._decoded = var2_2;
                return;
            }
            throw new IllegalArgumentException("Neither encoded nor decoded");
        }

        protected final String get_encoded() {
            return this._encoded;
        }

        /*
         * WARNING - void declaration
         */
        protected final void set_encoded(String string) {
            void var1_1;
            this._encoded = var1_1;
        }

        protected final String get_decoded() {
            return this._decoded;
        }

        /*
         * WARNING - void declaration
         */
        protected final void set_decoded(String string) {
            void var1_1;
            this._decoded = var1_1;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0012\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J&\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0007H\u0007J \u0010%\u001a\u0004\u0018\u00010\u00052\b\u0010&\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010'\u001a\u0004\u0018\u00010\u0005H\u0002J\u001e\u0010,\u001a\u0004\u0018\u00010\u00052\b\u0010-\u001a\u0004\u0018\u00010\u00052\b\u0010'\u001a\u0004\u0018\u00010\u0005H\u0007J\u001c\u0010.\u001a\u00020)2\b\u0010-\u001a\u0004\u0018\u00010\u00052\b\u0010'\u001a\u0004\u0018\u00010\u0005H\u0003J\u0014\u0010/\u001a\u0004\u0018\u00010\u00052\b\u0010&\u001a\u0004\u0018\u00010\u0005H\u0007J\u0014\u00100\u001a\u0004\u0018\u00010\u00052\b\u0010-\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00072\b\u00103\u001a\u0004\u0018\u00010\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001a8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0003\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Landroid/net/Uri$Companion;", "", "<init>", "()V", "LOG", "", "EMPTY", "Landroid/net/Uri;", "getEMPTY", "()Landroid/net/Uri;", "NOT_FOUND", "", "NOT_CALCULATED", "NOT_HIERARCHICAL", "DEFAULT_ENCODING", "parse", "uriString", "fromFile", "file", "Ljava/io/File;", "fromParts", "scheme", "ssp", "fragment", "NULL_TYPE_ID", "CREATOR", "Landroid/os/Parcelable$Creator;", "getCREATOR$annotations", "getCREATOR", "()Landroid/os/Parcelable$Creator;", "writeToParcel", "", "out", "Landroid/os/Parcel;", "uri", "HEX_DIGITS", "", "encode", "s", "allow", "isAllowed", "", "c", "", "encodeIfNotEncoded", "value", "isEncoded", "decode", "decodeIfNeeded", "withAppendedPath", "baseUri", "pathSegment", "firebase-java-sdk"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final Uri parse(String uriString) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
            return new StringUri((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        public final String encode(String s, String allow) {
            void var3_3;
            if (s == null) {
                return null;
            }
            StringBuilder encoded = null;
            int oldLength = s.length();
            int current = 0;
            while (current < oldLength) {
                int nextAllowed;
                int nextToEncode;
                for (nextToEncode = current; nextToEncode < oldLength && this.isAllowed(s.charAt(nextToEncode), allow); ++nextToEncode) {
                }
                if (nextToEncode == oldLength) {
                    if (current == 0) {
                        return s;
                    }
                    StringBuilder stringBuilder = encoded;
                    Intrinsics.checkNotNull(stringBuilder);
                    stringBuilder.append(s, current, oldLength);
                    return encoded.toString();
                }
                if (encoded == null) {
                    encoded = new StringBuilder();
                }
                if (nextToEncode > current) {
                    encoded.append(s, current, nextToEncode);
                }
                current = nextToEncode;
                for (nextAllowed = current + 1; nextAllowed < oldLength && !this.isAllowed(s.charAt(nextAllowed), allow); ++nextAllowed) {
                }
                Intrinsics.checkNotNullExpressionValue((Object)s.substring(current, nextAllowed), (String)"substring(...)");
                try {
                    byte[] bytes;
                    String toEncode;
                    Charset charset = Charset.forName("UTF-8");
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)toEncode.getBytes(charset), (String)"getBytes(...)");
                    int bytesLength = bytes.length;
                    for (int i = 0; i < bytesLength; ++i) {
                        encoded.append('%');
                        encoded.append(HEX_DIGITS[(bytes[i] & 0xF0) >> 4]);
                        encoded.append(HEX_DIGITS[bytes[i] & 0xF]);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)e);
                }
                int n = nextAllowed;
            }
            String string = var3_3;
            if (string == null || (string = ((StringBuilder)((Object)string)).toString()) == null) {
                void var1_1;
                string = var1_1;
            }
            return string;
        }

        public static /* synthetic */ String encode$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.encode(string, string2);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isAllowed(char c, String allow) {
            block4: {
                block3: {
                    void var1_1;
                    void var2_2;
                    if ('A' <= c ? c < '[' : false) break block3;
                    if ('a' <= c ? c < '{' : false) break block3;
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (!bl && StringsKt.indexOf$default((CharSequence)"_-!.~'()*", (char)c, (int)0, (boolean)false, (int)6, null) == -1 && (allow == null || StringsKt.indexOf$default((CharSequence)((CharSequence)var2_2), (char)var1_1, (int)0, (boolean)false, (int)6, null) == -1)) break block4;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 A2\u00020\u0001:\u0001AB7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0006\u0010'\u001a\u00020\u0003J\u0012\u0010(\u001a\u00020\u00172\n\u0010)\u001a\u00060*j\u0002`+J\b\u0010=\u001a\u00020\u0003H\u0016J\u0006\u0010>\u001a\u00020\u0003J\b\u0010?\u001a\u00020@H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001dR$\u0010 \u001a\u0004\u0018\u00010\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\rR\u0016\u0010%\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\rR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\rR\u0016\u0010-\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\rR\u0016\u0010/\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\rR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\rR\u0016\u0010\b\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\rR\u0016\u00103\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\rR\u0016\u0010\t\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\rR\u0016\u00106\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\rR\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020\u0003098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u000e\u0010<\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Landroid/net/Uri$HierarchicalUri;", "Landroid/net/Uri$AbstractHierarchicalUri;", "scheme", "", "authority", "Landroid/net/Uri$Part;", "path", "Landroid/net/Uri$PathPart;", "query", "fragment", "<init>", "(Ljava/lang/String;Landroid/net/Uri$Part;Landroid/net/Uri$PathPart;Landroid/net/Uri$Part;Landroid/net/Uri$Part;)V", "getScheme", "()Ljava/lang/String;", "_authority", "_path", "_query", "_fragment", "generatePath", "originalPath", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "isHierarchical", "", "()Z", "isRelative", "value", "ssp", "getSsp", "()Landroid/net/Uri$Part;", "encodedSchemeSpecificPart", "getEncodedSchemeSpecificPart", "schemeSpecificPart", "getSchemeSpecificPart", "makeSchemeSpecificPart", "appendSspTo", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getAuthority", "encodedAuthority", "getEncodedAuthority", "encodedPath", "getEncodedPath", "getPath", "getQuery", "encodedQuery", "getEncodedQuery", "getFragment", "encodedFragment", "getEncodedFragment", "pathSegments", "", "getPathSegments", "()Ljava/util/List;", "uriString", "toString", "makeUriString", "buildUpon", "Landroid/net/Uri$Builder;", "Companion", "firebase-java-sdk"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$HierarchicalUri\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
    private static final class HierarchicalUri
    extends AbstractHierarchicalUri {
        public static final Companion Companion = new Companion(null);
        private final String scheme;
        private final Part _authority;
        private final PathPart _path;
        private final Part _query;
        private final Part _fragment;
        private volatile String uriString;

        /*
         * WARNING - void declaration
         */
        public HierarchicalUri(String scheme, Part authority, PathPart path, Part query, Part fragment) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.scheme = var1_1;
            this._authority = Part.Companion.nonNull((Part)var2_2);
            this._path = this.generatePath((PathPart)var3_3);
            this._query = Part.Companion.nonNull(query);
            this._fragment = Part.Companion.nonNull(fragment);
            this.uriString = "NOT CACHED";
        }

        public final String getScheme() {
            return this.scheme;
        }

        /*
         * WARNING - void declaration
         */
        public final PathPart generatePath(PathPart originalPath) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
            boolean bl = this.getScheme() != null && this.getScheme().length() > 0 || !this._authority.isEmpty();
            if (bl) {
                return PathPart.Companion.makeAbsolute(originalPath);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void appendSspTo(StringBuilder builder) {
            String encodedPath;
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            String encodedAuthority = this._authority.getEncoded();
            if (encodedAuthority != null) {
                builder.append("//").append(encodedAuthority);
            }
            if ((encodedPath = this._path.getEncoded()) != null) {
                void var2_2;
                builder.append((String)var2_2);
            }
            if (!this._query.isEmpty()) {
                void var1_1;
                var1_1.append('?').append(this._query.getEncoded());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String toString() {
            void var2_3;
            String string;
            boolean bl = this.uriString != "NOT CACHED";
            if (bl) {
                return this.uriString;
            }
            String it = string = this.makeUriString();
            this.uriString = var2_3;
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public final String makeUriString() {
            void var1_1;
            StringBuilder builder = new StringBuilder();
            if (this.getScheme() != null) {
                builder.append(this.getScheme()).append(':');
            }
            this.appendSspTo(builder);
            if (!this._fragment.isEmpty()) {
                builder.append('#').append(this._fragment.getEncoded());
            }
            String string = var1_1.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroid/net/Uri$HierarchicalUri$Companion;", "", "<init>", "()V", "TYPE_ID", "", "readFrom", "Landroid/net/Uri;", "parcel", "Landroid/os/Parcel;", "firebase-java-sdk"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0017\u0018\u0000 \f2\u00020\u0001:\u0002\r\fB\u001d\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b"}, d2={"Landroid/net/Uri$Part;", "Landroid/net/Uri$AbstractPart;", "", "encoded", "decoded", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "", "isEmpty", "()Z", "getEncoded", "()Ljava/lang/String;", "Companion", "EmptyPart"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$Part\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
    public static class Part
    extends AbstractPart {
        public static final Companion Companion = new Companion(null);
        private static final Part NULL = new EmptyPart(null);
        public static final Part EMPTY = new EmptyPart("");

        /*
         * WARNING - void declaration
         */
        private Part(String encoded, String decoded) {
            super((String)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        public boolean isEmpty() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public String getEncoded() {
            void var2_3;
            String string;
            boolean bl = this.get_encoded() != "NOT CACHED";
            if (bl) {
                return this.get_encoded();
            }
            String it = string = android.net.Uri$Companion.encode$default(Companion, this.get_decoded(), null, 2, null);
            this.set_encoded((String)var2_3);
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public /* synthetic */ Part(String encoded, String decoded, DefaultConstructorMarker $constructor_marker) {
            this((String)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0006\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\f\u0010\t"}, d2={"Landroid/net/Uri$Part$Companion;", "", "<init>", "()V", "Landroid/net/Uri$Part;", "part", "nonNull", "(Landroid/net/Uri$Part;)Landroid/net/Uri$Part;", "NULL", "Landroid/net/Uri$Part;", "getNULL", "()Landroid/net/Uri$Part;", "EMPTY"})
        public static final class Companion {
            private Companion() {
            }

            public final Part getNULL() {
                return NULL;
            }

            @JvmStatic
            public final Part nonNull(Part part) {
                Part part2 = part;
                if (part2 == null) {
                    part2 = this.getNULL();
                }
                return part2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0007\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Landroid/net/Uri$Part$EmptyPart;", "Landroid/net/Uri$Part;", "", "value", "<init>", "(Ljava/lang/String;)V", "", "isEmpty", "()Z"})
        @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$Part$EmptyPart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
        private static final class EmptyPart
        extends Part {
            /*
             * WARNING - void declaration
             */
            public EmptyPart(String value) {
                void var1_1;
                String string = value;
                super(string, string, null);
                CharSequence charSequence = (CharSequence)value;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    value = "Expected empty value, got: " + (String)value;
                    throw new IllegalArgumentException(value.toString());
                }
                this.set_decoded((String)var1_1);
                EmptyPart emptyPart = this;
                emptyPart.set_encoded(emptyPart.get_decoded());
            }

            @Override
            public final boolean isEmpty() {
                return true;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u001d\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Landroid/net/Uri$PathPart;", "Landroid/net/Uri$AbstractPart;", "", "encoded", "decoded", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getEncoded", "()Ljava/lang/String;", "Companion"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$PathPart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
    public static final class PathPart
    extends AbstractPart {
        public static final Companion Companion = new Companion(null);
        public static final PathPart NULL = new PathPart(null, null);
        private static final PathPart EMPTY = new PathPart("", "");

        /*
         * WARNING - void declaration
         */
        private PathPart(String encoded, String decoded) {
            super((String)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final String getEncoded() {
            void var2_3;
            String string;
            boolean bl = this.get_encoded() != "NOT CACHED";
            if (bl) {
                return this.get_encoded();
            }
            String it = string = Companion.encode(this.get_decoded(), "/");
            this.set_encoded((String)var2_3);
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public /* synthetic */ PathPart(String encoded, String decoded, DefaultConstructorMarker $constructor_marker) {
            this((String)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\t\u001a\u0004\b\u000b\u0010\f"}, d2={"Landroid/net/Uri$PathPart$Companion;", "", "<init>", "()V", "Landroid/net/Uri$PathPart;", "oldPart", "makeAbsolute", "(Landroid/net/Uri$PathPart;)Landroid/net/Uri$PathPart;", "NULL", "Landroid/net/Uri$PathPart;", "EMPTY", "getEMPTY", "()Landroid/net/Uri$PathPart;"})
        public static final class Companion {
            private Companion() {
            }

            public final PathPart getEMPTY() {
                return EMPTY;
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            public final PathPart makeAbsolute(PathPart oldPart) {
                void var1_1;
                void var2_3;
                void var3_4;
                Intrinsics.checkNotNullParameter((Object)oldPart, (String)"oldPart");
                boolean encodedCached = oldPart.get_encoded() != "NOT CACHED";
                String oldPath = encodedCached ? oldPart.get_encoded() : oldPart.get_decoded();
                if (oldPath == null || oldPath.length() == 0 || StringsKt.startsWith$default((String)var3_4, (String)"/", (boolean)false, (int)2, null)) {
                    return oldPart;
                }
                String newEncoded = encodedCached ? "/" + oldPart.get_encoded() : "NOT CACHED";
                boolean bl = oldPart.get_decoded() != "NOT CACHED";
                String newDecoded = bl ? "/" + oldPart.get_decoded() : "NOT CACHED";
                return new PathPart((String)var2_3, (String)var1_1, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 K2\u00020\u0001:\u0001KB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u0010\u001a\u00020\u0007J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\"\u001a\u00020\u0003J\b\u00107\u001a\u0004\u0018\u00010\u0003J\b\u0010=\u001a\u0004\u0018\u00010\u0003J\b\u0010E\u001a\u0004\u0018\u00010\u0003J\b\u0010H\u001a\u00020\u0003H\u0016J\b\u0010I\u001a\u00020JH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R$\u0010\u0016\u001a\u0004\u0018\u00010\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u00038V@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001a8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0018R\u0016\u0010 \u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0018R\u0010\u0010#\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u0016\u0010&\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0018R\u0016\u0010(\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0018R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0016\u0010/\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0018R\u0016\u00101\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0018R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u0003048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0010\u00108\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00109\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001dR\u0016\u0010;\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0018R\u0016\u0010>\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0018R\u0010\u0010@\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010A\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u001dR\u0016\u0010C\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u0018R\u0016\u0010F\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u0018\u00a8\u0006L"}, d2={"Landroid/net/Uri$StringUri;", "Landroid/net/Uri$AbstractHierarchicalUri;", "uriString", "", "<init>", "(Ljava/lang/String;)V", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "cachedSsi", "findSchemeSeparator", "cachedFsi", "findFragmentSeparator", "isHierarchical", "", "()Z", "isRelative", "value", "scheme", "getScheme", "()Ljava/lang/String;", "parseScheme", "Landroid/net/Uri$Part;", "ssp", "getSsp", "()Landroid/net/Uri$Part;", "encodedSchemeSpecificPart", "getEncodedSchemeSpecificPart", "schemeSpecificPart", "getSchemeSpecificPart", "parseSsp", "_authorityPart", "authorityPart", "getAuthorityPart", "encodedAuthority", "getEncodedAuthority", "authority", "getAuthority", "_pathPart", "Landroid/net/Uri$PathPart;", "pathPart", "getPathPart", "()Landroid/net/Uri$PathPart;", "path", "getPath", "encodedPath", "getEncodedPath", "pathSegments", "", "getPathSegments", "()Ljava/util/List;", "parsePath", "_queryPart", "queryPart", "getQueryPart", "encodedQuery", "getEncodedQuery", "parseQuery", "query", "getQuery", "_fragmentPart", "fragmentPart", "getFragmentPart", "encodedFragment", "getEncodedFragment", "parseFragment", "fragment", "getFragment", "toString", "buildUpon", "Landroid/net/Uri$Builder;", "Companion", "firebase-java-sdk"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nandroid/net/Uri$StringUri\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2062:1\n1#2:2063\n*E\n"})
    private static final class StringUri
    extends AbstractHierarchicalUri {
        public static final Companion Companion = new Companion(null);
        private final String uriString;
        private volatile int cachedSsi = -2;
        private volatile int cachedFsi = -2;
        private volatile String scheme = "NOT CACHED";

        /*
         * WARNING - void declaration
         */
        public StringUri(String uriString) {
            void var1_1;
            if (uriString == null) {
                throw new NullPointerException("uriString");
            }
            this.uriString = var1_1;
        }

        @Override
        public final String toString() {
            return this.uriString;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0007J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroid/net/Uri$StringUri$Companion;", "", "<init>", "()V", "TYPE_ID", "", "readFrom", "Landroid/net/Uri;", "parcel", "Landroid/os/Parcel;", "parseAuthority", "", "uriString", "ssi", "parsePath", "firebase-java-sdk"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

