/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.Version;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingLayerPropertiesKt;
import org.jetbrains.skiko.swing.SwingRedrawer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b!\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001e\u0010\u000f\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0082\b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\nH\u0004\u00a2\u0006\u0004\b\u0011\u0010\fJ\u0019\u0010\u0014\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J/\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001bH$\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010#R\u0018\u0010%\u001a\u0004\u0018\u00010$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010'R\u0016\u0010)\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010+\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010*R\u0014\u0010-\u001a\u00020,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010/"}, d2={"Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "Lorg/jetbrains/skiko/swing/SwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "swingLayerProperties", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "analytics", "Lorg/jetbrains/skiko/GraphicsApi;", "graphicsApi", "<init>", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/GraphicsApi;)V", "", "dispose", "()V", "Lkotlin/Function0;", "body", "inDrawScope", "(Lkotlin/jvm/functions/Function0;)V", "onContextInit", "", "deviceName", "onDeviceChosen", "(Ljava/lang/String;)V", "Ljava/awt/Graphics2D;", "g", "", "width", "height", "", "nanoTime", "onRender", "(Ljava/awt/Graphics2D;IIJ)V", "redraw", "(Ljava/awt/Graphics2D;)V", "rendererInfo", "()Ljava/lang/String;", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$DeviceAnalytics;", "deviceAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$DeviceAnalytics;", "Lorg/jetbrains/skiko/GraphicsApi;", "", "isDisposed", "Z", "isFirstFrameRendered", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$RendererAnalytics;", "rendererAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$RendererAnalytics;", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;"})
@SourceDebugExtension(value={"SMAP\nSwingRedrawerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingRedrawerBase.kt\norg/jetbrains/skiko/swing/SwingRedrawerBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,98:1\n81#1:100\n82#1,16:102\n1#2:99\n1#2:101\n124#3,4:118\n*S KotlinDebug\n*F\n+ 1 SwingRedrawerBase.kt\norg/jetbrains/skiko/swing/SwingRedrawerBase\n*L\n47#1:100\n47#1:102,16\n47#1:101\n75#1:118,4\n*E\n"})
public abstract class SwingRedrawerBase
implements SwingRedrawer {
    private final SwingLayerProperties swingLayerProperties;
    private final SkiaLayerAnalytics analytics;
    private final GraphicsApi graphicsApi;
    private boolean isFirstFrameRendered;
    private final SkiaLayerAnalytics.RendererAnalytics rendererAnalytics;
    private SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
    private boolean isDisposed;

    /*
     * WARNING - void declaration
     */
    public SwingRedrawerBase(SwingLayerProperties swingLayerProperties2, SkiaLayerAnalytics analytics, GraphicsApi graphicsApi) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"swingLayerProperties");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"graphicsApi");
        this.swingLayerProperties = var1_1;
        this.analytics = var2_2;
        this.graphicsApi = var3_3;
        this.rendererAnalytics = this.analytics.renderer(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi);
        this.rendererAnalytics.init();
    }

    protected abstract void onRender(Graphics2D var1, int var2, int var3, long var4);

    @Override
    public void dispose() {
        if (!(!this.isDisposed)) {
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        this.isDisposed = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void redraw(Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!(!this.isDisposed)) {
            g = this.getClass() + " is disposed";
            throw new IllegalArgumentException(g.toString());
        }
        SwingRedrawerBase this_$iv = this;
        if (!SwingUtilities.isEventDispatchThread()) {
            g = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(g.toString());
        }
        SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this_$iv.deviceAnalytics;
        if (deviceAnalytics == null) {
            g = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(g.toString());
        }
        if (!this_$iv.isDisposed) {
            if (!this_$iv.isFirstFrameRendered && (deviceAnalytics = this_$iv.deviceAnalytics) != null) {
                deviceAnalytics.beforeFirstFrameRender();
            }
            try {
                void var3_5;
                void var1_1;
                float scale = SwingLayerPropertiesKt.getScale(this.swingLayerProperties);
                int width2 = RangesKt.coerceAtLeast((int)((int)((float)this.swingLayerProperties.getWidth() * scale)), (int)0);
                int height2 = RangesKt.coerceAtLeast((int)((int)((float)this.swingLayerProperties.getHeight() * scale)), (int)0);
                this.onRender((Graphics2D)var1_1, width2, (int)var3_5, System.nanoTime());
            }
            catch (CancellationException cancellationException) {}
            if (!this_$iv.isFirstFrameRendered && !this_$iv.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics2 = this_$iv.deviceAnalytics;
                if (deviceAnalytics2 != null) {
                    deviceAnalytics2.afterFirstFrameRender();
                }
            }
            var2_2.isFirstFrameRendered = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void onDeviceChosen(String deviceName) {
        void var1_1;
        if (!(!this.isDisposed)) {
            deviceName = this.getClass() + " is disposed";
            throw new IllegalArgumentException(deviceName.toString());
        }
        if (!(this.deviceAnalytics == null)) {
            deviceName = "deviceAnalytics is not null";
            throw new IllegalArgumentException(deviceName.toString());
        }
        this.rendererAnalytics.deviceChosen();
        SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics = this.analytics.device(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi, (String)var1_1);
        if (deviceAnalytics != null) {
            deviceAnalytics.init();
            return;
        }
    }

    protected String rendererInfo() {
        return "GraphicsApi: " + (Object)((Object)this.graphicsApi) + "\nOS: " + OsArch_jvmKt.getHostOs().getId() + ' ' + OsArch_jvmKt.getHostArch().getId() + '\n';
    }

    protected final void onContextInit() {
        Logger this_$iv;
        if (!(!this.isDisposed)) {
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.deviceAnalytics == null) {
            String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(string.toString());
        }
        if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && (this_$iv = Logger.INSTANCE).getLoggerImpl().isInfoEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface;
            skikoLoggerInterface = ((Logger)((Object)skikoLoggerInterface)).getLoggerImpl();
            skikoLoggerInterface.info("Renderer info:\n " + this.rendererInfo());
        }
        SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
        if (deviceAnalytics != null) {
            deviceAnalytics.contextInit();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void inDrawScope(Function0<Unit> body) {
        if (!SwingUtilities.isEventDispatchThread()) {
            body = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(body.toString());
        }
        SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
        if (deviceAnalytics == null) {
            body = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(body.toString());
        }
        if (!this.isDisposed) {
            if (!this.isFirstFrameRendered && (deviceAnalytics = this.deviceAnalytics) != null) {
                deviceAnalytics.beforeFirstFrameRender();
            }
            try {
                void var1_1;
                var1_1.invoke();
            }
            catch (CancellationException cancellationException) {}
            if (!this.isFirstFrameRendered && !this.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics2 = this.deviceAnalytics;
                if (deviceAnalytics2 != null) {
                    deviceAnalytics2.afterFirstFrameRender();
                }
            }
            this.isFirstFrameRendered = true;
        }
    }
}

