/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.impl.BufferUtil;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingLayerPropertiesKt;
import org.jetbrains.skiko.swing.SwingPainter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0087\u0001\u0010'\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b'\u0010(J}\u0010*\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010&\u001a\u00020%2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010)\u001a\u0004\u0018\u00010\u001b2\b\u0010$\u001a\u0004\u0018\u00010#H\u0002\u00a2\u0006\u0004\b*\u0010+Jk\u0010.\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010,\u001a\u00020\b2\b\b\u0002\u0010-\u001a\u00020\b2\b\b\u0002\u0010\u0019\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010$\u001a\u0004\u0018\u00010#H\u0002\u00a2\u0006\u0004\b.\u0010/J'\u00103\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00152\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b3\u00104J\u001f\u00106\u001a\u00020\b2\u0006\u00105\u001a\u00020\b2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b6\u00107R\u0016\u00109\u001a\u0002088\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0016\u0010;\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010="}, d2={"Lorg/jetbrains/skiko/swing/SoftwareSwingPainter;", "Lorg/jetbrains/skiko/swing/SwingPainter;", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "swingLayerProperties", "<init>", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;)V", "", "pBytes", "", "width", "height", "Ljava/awt/image/BufferedImage;", "createImageFromBytes", "(JII)Ljava/awt/image/BufferedImage;", "", "dispose", "()V", "Ljava/awt/image/BufferedImageOp;", "op", "Ljava/awt/Image;", "image", "Ljava/awt/Graphics2D;", "invG", "", "hasDestinationSize", "dw", "dh", "Ljava/awt/Rectangle;", "sourceBounds", "userWidth", "userHeight", "Ljava/awt/Graphics;", "g", "dx", "dy", "Ljava/awt/image/ImageObserver;", "observer", "", "scale", "doDraw", "(Ljava/awt/image/BufferedImageOp;Ljava/awt/Image;Ljava/awt/Graphics2D;ZIILjava/awt/Rectangle;IILjava/awt/Graphics;IILjava/awt/image/ImageObserver;D)V", "srcBounds", "doDrawHiDpi", "(IILjava/awt/Graphics;DIIIIZLjava/awt/image/BufferedImageOp;Ljava/awt/Image;Ljava/awt/Rectangle;Ljava/awt/image/ImageObserver;)V", "x", "y", "drawImage", "(Ljava/awt/Graphics;Ljava/awt/Image;IIIILjava/awt/Rectangle;Ljava/awt/image/BufferedImageOp;Ljava/awt/image/ImageObserver;)V", "Lorg/jetbrains/skia/Surface;", "surface", "texture", "paint", "(Ljava/awt/Graphics2D;Lorg/jetbrains/skia/Surface;J)V", "size", "scaleSize", "(ID)I", "Lorg/jetbrains/skia/Bitmap;", "bitmap", "Lorg/jetbrains/skia/Bitmap;", "bufferedImage", "Ljava/awt/image/BufferedImage;", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;"})
@SourceDebugExtension(value={"SMAP\nSoftwareSwingPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoftwareSwingPainter.kt\norg/jetbrains/skiko/swing/SoftwareSwingPainter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
public final class SoftwareSwingPainter
implements SwingPainter {
    private final SwingLayerProperties swingLayerProperties;
    private BufferedImage bufferedImage;
    private Bitmap bitmap;

    /*
     * WARNING - void declaration
     */
    public SoftwareSwingPainter(SwingLayerProperties swingLayerProperties2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"swingLayerProperties");
        this.swingLayerProperties = var1_1;
        this.bufferedImage = new BufferedImage(1, 1, 3);
        this.bitmap = new Bitmap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void paint(Graphics2D g, Surface surface, long texture) {
        void var1_1;
        void var3_4;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        int width2 = surface.getWidth();
        int height2 = surface.getHeight();
        if (this.bitmap.getWidth() != width2 || this.bitmap.getHeight() != height2) {
            this.bitmap.allocPixelsFlags(ImageInfo.Companion.makeS32(width2, height2, ColorAlphaType.PREMUL), false);
        }
        var2_2.readPixels(this.bitmap, 0, 0);
        Pixmap pixmap = this.bitmap.peekPixels();
        if (pixmap == null) {
            throw new RenderException("Can't get pixels address", null, 2, null);
        }
        long bufferPtr = pixmap.getAddr();
        this.bufferedImage = this.createImageFromBytes(bufferPtr, (int)var3_4, height2);
        SoftwareSwingPainter.drawImage$default(this, (Graphics)var1_1, this.bufferedImage, 0, 0, 0, 0, null, null, null, 508, null);
    }

    @Override
    public final void dispose() {
        this.bitmap.close();
    }

    /*
     * WARNING - void declaration
     */
    private final BufferedImage createImageFromBytes(long pBytes2, int width2, int height2) {
        void var1_2;
        void var3_3;
        if (this.bufferedImage.getWidth() != width2 || this.bufferedImage.getHeight() != height2) {
            this.bufferedImage = new BufferedImage(width2, height2, 3);
        }
        BufferedImage image = this.bufferedImage;
        DataBuffer dataBuffer = image.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
        int[] dstData = ((DataBufferInt)dataBuffer).getData();
        ByteBuffer pBytes2 = BufferUtil.INSTANCE.getByteBufferFromPointer(pBytes2, (int)(var3_3 * height2 << 2));
        IntBuffer intBuffer = pBytes2.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)intBuffer, (String)"asIntBuffer(...)");
        IntBuffer srcData = intBuffer;
        intBuffer.position(0).get(dstData, 0, Math.min(image.getHeight() * image.getWidth(), var1_2.capacity()));
        return image;
    }

    /*
     * WARNING - void declaration
     */
    private final void drawImage(Graphics g, Image image, int x2, int y2, int dw, int dh, Rectangle sourceBounds, BufferedImageOp op, ImageObserver observer) {
        void var2_2;
        void var3_3;
        void var1_1;
        boolean hasDestinationSize = dw >= 0 && dh >= 0;
        SoftwareSwingPainter softwareSwingPainter = this;
        softwareSwingPainter.doDrawHiDpi(softwareSwingPainter.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight(), (Graphics)var1_1, SwingLayerPropertiesKt.getScale(this.swingLayerProperties), (int)var3_3, y2, dw, dh, hasDestinationSize, op, (Image)var2_2, sourceBounds, observer);
    }

    static /* synthetic */ void drawImage$default(SoftwareSwingPainter softwareSwingPainter, Graphics graphics, Image image, int n, int n2, int n3, int n4, Rectangle rectangle, BufferedImageOp bufferedImageOp, ImageObserver imageObserver, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n = 0;
        }
        if ((n5 & 8) != 0) {
            n2 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n3 = -1;
        }
        if ((n5 & 0x20) != 0) {
            n4 = -1;
        }
        if ((n5 & 0x40) != 0) {
            rectangle = null;
        }
        if ((n5 & 0x80) != 0) {
            bufferedImageOp = null;
        }
        if ((n5 & 0x100) != 0) {
            imageObserver = null;
        }
        softwareSwingPainter.drawImage(graphics, image, n, n2, n3, n4, rectangle, bufferedImageOp, imageObserver);
    }

    /*
     * WARNING - void declaration
     */
    private final void doDrawHiDpi(int userWidth, int userHeight, Graphics g, double scale, int dx, int dy, int dw, int dh, boolean hasDestinationSize, BufferedImageOp op, Image image, Rectangle srcBounds, ImageObserver observer) {
        Graphics graphics;
        Graphics g1 = g;
        double scale1 = scale;
        int dx1 = dx;
        int dy1 = dy;
        double delta = 0.0;
        int maxSize = Math.max(userWidth, userHeight);
        if (maxSize < 0x3FFFFFFF) {
            void pow;
            int dotAccuracy = 1;
            while (true) {
                void it;
                double d;
                double d2 = d = Math.pow(10.0, dotAccuracy);
                double d3 = maxSize;
                pow = it;
                if (!(d3 > d)) break;
                ++dotAccuracy;
            }
            delta = 1.0 / pow;
        }
        Graphics graphics2 = g1;
        Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        AffineTransform tx = ((Graphics2D)graphics2).getTransform();
        Graphics invG = null;
        if ((tx.getType() & 0x18) == 0 && Math.abs(scale1 - tx.getScaleX()) <= delta) {
            scale1 = tx.getScaleX();
            double gScaleX = tx.getScaleX();
            double gScaleY = tx.getScaleY();
            tx.scale(1.0 / gScaleX, 1.0 / gScaleY);
            tx.translate((double)dx1 * gScaleX, (double)dy1 * gScaleY);
            dy1 = 0;
            dx1 = 0;
            Graphics graphics3 = g1.create();
            Intrinsics.checkNotNull((Object)graphics3, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            invG = (Graphics2D)graphics3;
            g1 = invG;
            ((Graphics2D)invG).setTransform(tx);
        }
        try {
            void var3_3;
            void var2_2;
            void var1_1;
            int dw2 = dw;
            int dh2 = dh;
            if (invG != null && hasDestinationSize) {
                dw2 = this.scaleSize(dw2, scale1);
                dh2 = this.scaleSize(dh2, scale1);
            }
            this.doDraw(op, image, (Graphics2D)invG, hasDestinationSize, dw2, dh2, srcBounds, (int)var1_1, (int)var2_2, (Graphics)var3_3, dx1, dy1, observer, scale1);
            graphics = invG;
        }
        catch (Throwable throwable) {
            Graphics graphics4 = invG;
            if (graphics4 != null) {
                graphics4.dispose();
            }
            throw throwable;
        }
        if (graphics == null) {
            return;
        }
        graphics.dispose();
    }

    /*
     * WARNING - void declaration
     */
    private final int scaleSize(int size2, double scale) {
        void var2_2;
        return MathKt.roundToInt((double)((double)size2 * var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private final void doDraw(BufferedImageOp op, Image image, Graphics2D invG, boolean hasDestinationSize, int dw, int dh, Rectangle sourceBounds, int userWidth, int userHeight, Graphics g, int dx, int dy, ImageObserver observer, double scale) {
        void var2_3;
        void var3_4;
        if (op != null && image instanceof BufferedImage) {
            BufferedImage bufferedImage = op.filter((BufferedImage)image, null);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"filter(...)");
            image = bufferedImage;
        }
        if (sourceBounds != null) {
            void var3_5;
            void var1_2;
            int sh;
            int sx = SoftwareSwingPainter.doDraw$size(this, scale, sourceBounds.x);
            int sy = SoftwareSwingPainter.doDraw$size(this, scale, sourceBounds.y);
            int sw = sourceBounds.width >= 0 ? SoftwareSwingPainter.doDraw$size(this, scale, sourceBounds.width) : SoftwareSwingPainter.doDraw$size(this, scale, userWidth) - sx;
            int n = sh = sourceBounds.height >= 0 ? SoftwareSwingPainter.doDraw$size(this, scale, sourceBounds.height) : SoftwareSwingPainter.doDraw$size(this, scale, userHeight) - sy;
            if (!hasDestinationSize) {
                dw = SoftwareSwingPainter.doDraw$size(this, scale, userWidth);
                dh = SoftwareSwingPainter.doDraw$size(this, scale, userHeight);
            }
            g.drawImage(image, dx, dy, dx + dw, dy + dh, sx, sy, (int)(var1_2 + sw), (int)(var3_5 + sh), observer);
            return;
        }
        if (hasDestinationSize) {
            void var6_8;
            void var5_7;
            g.drawImage(image, dx, dy, (int)var5_7, (int)var6_8, observer);
            return;
        }
        if (var3_4 == null) {
            g.drawImage(image, dx, dy, userWidth, userHeight, observer);
            return;
        }
        g.drawImage((Image)var2_3, dx, dy, observer);
    }

    /*
     * WARNING - void declaration
     */
    private static final int doDraw$size(SoftwareSwingPainter this$0, double $scale, int size2) {
        void var1_1;
        void var3_2;
        return this$0.scaleSize((int)var3_2, (double)var1_1);
    }
}

