/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skiko.ClipRectangle;
import org.jetbrains.skiko.ExperimentalSkikoApi;
import org.jetbrains.skiko.GpuPriority;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.NativeAccessibleFocusHelper;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkiaLayer_awtKt;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.redrawer.RedrawerManager;
import org.jetbrains.skiko.swing.SkiaSwingLayer;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingRedrawer;
import org.jetbrains.skiko.swing.SwingRedrawerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 ?2\u00020\u0001:\u0001?B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0011\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0017\u001a\u00020\u000e2\b\b\u0002\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u0010J\u0017\u0010\u001f\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0!8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0016\u0010&\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0016\u0010(\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010'R\u001a\u0010*\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\f\n\u0004\b*\u0010+\u0012\u0004\b,\u0010\u0010R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010-R\u0016\u00101\u001a\u0004\u0018\u00010.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020.028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0011\u00108\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u0010:\u001a\u0002098\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0014\u0010=\u001a\u00020<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>"}, d2={"Lorg/jetbrains/skiko/swing/SkiaSwingLayer;", "Ljavax/swing/JPanel;", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "renderDelegate", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "analytics", "Lkotlin/Function1;", "Ljava/awt/Component;", "Ljavax/accessibility/Accessible;", "externalAccessibleFactory", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "properties", "<init>", "(Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/skiko/SkiaLayerProperties;)V", "", "addNotify", "()V", "dispose", "Ljavax/accessibility/AccessibleContext;", "getAccessibleContext", "()Ljavax/accessibility/AccessibleContext;", "", "recreation", "init", "(Z)V", "Ljava/awt/Graphics;", "g", "paint", "(Ljava/awt/Graphics;)V", "removeNotify", "accessible", "requestNativeFocusOnAccessible", "(Ljavax/accessibility/Accessible;)V", "", "Lorg/jetbrains/skiko/ClipRectangle;", "getClipComponents", "()Ljava/util/List;", "clipComponents", "isDisposed", "Z", "isInitialized", "Lorg/jetbrains/skiko/NativeAccessibleFocusHelper;", "nativeAccessibleFocusHelper", "Lorg/jetbrains/skiko/NativeAccessibleFocusHelper;", "getNativeAccessibleFocusHelper$annotations", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "Lorg/jetbrains/skiko/swing/SwingRedrawer;", "getRedrawer", "()Lorg/jetbrains/skiko/swing/SwingRedrawer;", "redrawer", "Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "redrawerManager", "Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "renderApi", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$renderDelegateWithClipping$1;", "renderDelegateWithClipping", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$renderDelegateWithClipping$1;", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$swingLayerProperties$1;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$swingLayerProperties$1;", "Companion"})
@ExperimentalSkikoApi
@SourceDebugExtension(value={"SMAP\nSkiaSwingLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaSwingLayer.kt\norg/jetbrains/skiko/swing/SkiaSwingLayer\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n118#2,4:142\n118#2,4:146\n159#2,4:151\n1#3:150\n*S KotlinDebug\n*F\n+ 1 SkiaSwingLayer.kt\norg/jetbrains/skiko/swing/SkiaSwingLayer\n*L\n88#1:142,4\n94#1:146,4\n120#1:151,4\n*E\n"})
public class SkiaSwingLayer
extends JPanel {
    public static final Companion Companion = new Companion(null);
    private final SkiaLayerProperties properties;
    private boolean isInitialized;
    private volatile boolean isDisposed;
    private final renderDelegateWithClipping.1 renderDelegateWithClipping;
    private final swingLayerProperties.1 swingLayerProperties;
    private final RedrawerManager<SwingRedrawer> redrawerManager;
    private final NativeAccessibleFocusHelper nativeAccessibleFocusHelper;

    /*
     * WARNING - void declaration
     */
    public SkiaSwingLayer(SkikoRenderDelegate renderDelegate, SkiaLayerAnalytics analytics, Function1<? super Component, ? extends Accessible> externalAccessibleFactory, SkiaLayerProperties properties) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)renderDelegate, (String)"renderDelegate");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
        this.renderDelegateWithClipping = new SkikoRenderDelegate((SkikoRenderDelegate)var1_1, this){
            private final /* synthetic */ SkikoRenderDelegate $$delegate_0;
            final /* synthetic */ SkikoRenderDelegate $renderDelegate;
            final /* synthetic */ SkiaSwingLayer this$0;
            {
                void var1_1;
                void var2_2;
                this.$renderDelegate = $renderDelegate;
                this.this$0 = var2_2;
                this.$$delegate_0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final void onRender(Canvas canvas, int width2, int height2, long nanoTime) {
                void var3_3;
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                float scale = (float)this.this$0.getGraphicsConfiguration().getDefaultTransform().getScaleX();
                for (ClipRectangle component : this.this$0.getClipComponents()) {
                    SkiaLayer_awtKt.clipRectBy(canvas, component, scale);
                }
                this.$renderDelegate.onRender((Canvas)var1_1, (int)var2_2, (int)var3_3, nanoTime);
            }
        };
        this.swingLayerProperties = new SwingLayerProperties(this){
            final /* synthetic */ SkiaSwingLayer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public final int getWidth() {
                return this.this$0.getWidth();
            }

            public final int getHeight() {
                return this.this$0.getHeight();
            }

            public final GraphicsConfiguration getGraphicsConfiguration() {
                GraphicsConfiguration graphicsConfiguration = this.this$0.getGraphicsConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getGraphicsConfiguration(...)");
                return graphicsConfiguration;
            }

            public final GpuPriority getAdapterPriority() {
                return SkiaSwingLayer.access$getProperties$p(this.this$0).getAdapterPriority();
            }
        };
        this.redrawerManager = new RedrawerManager(this.properties.getRenderApi(), (Function2)new Function2<GraphicsApi, SwingRedrawer, SwingRedrawer>(this, (SkiaLayerAnalytics)var2_2){
            final /* synthetic */ SkiaSwingLayer this$0;
            final /* synthetic */ SkiaLayerAnalytics $analytics;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$analytics = var2_2;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final SwingRedrawer invoke(GraphicsApi renderApi, SwingRedrawer oldRedrawer) {
                void var1_1;
                block0: {
                    void var2_2;
                    Intrinsics.checkNotNullParameter((Object)((Object)renderApi), (String)"renderApi");
                    void v0 = var2_2;
                    if (v0 == null) break block0;
                    v0.dispose();
                }
                return SwingRedrawerKt.createSwingRedrawer(SkiaSwingLayer.access$getSwingLayerProperties$p(this.this$0), SkiaSwingLayer.access$getRenderDelegateWithClipping$p(this.this$0), (GraphicsApi)var1_1, this.$analytics);
            }
        }, null, 4, null);
        this.setOpaque(false);
        this.setLayout(null);
        void v0 = var3_3;
        this.nativeAccessibleFocusHelper = new NativeAccessibleFocusHelper(this, v0 != null ? (Accessible)v0.invoke((Object)this) : null);
    }

    public /* synthetic */ SkiaSwingLayer(SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics, Function1 function1, SkiaLayerProperties skiaLayerProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            skiaLayerAnalytics = SkiaLayerAnalytics.Companion.getEmpty();
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        if ((n & 8) != 0) {
            skiaLayerProperties = new SkiaLayerProperties(false, false, null, null, null, 31, null);
        }
        this(skikoRenderDelegate, skiaLayerAnalytics, (Function1<? super Component, ? extends Accessible>)function1, skiaLayerProperties);
    }

    public final List<ClipRectangle> getClipComponents() {
        return new ArrayList();
    }

    private final SwingRedrawer getRedrawer() {
        return this.redrawerManager.getRedrawer();
    }

    public final GraphicsApi getRenderApi() {
        return this.redrawerManager.getRenderApi();
    }

    @Override
    public void removeNotify() {
        Logger this_$iv = Logger.INSTANCE;
        if (this_$iv.getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface;
            skikoLoggerInterface = ((Logger)((Object)skikoLoggerInterface)).getLoggerImpl();
            skikoLoggerInterface.debug("SkiaSwingLayer.awt#removeNotify " + this);
        }
        this.dispose();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        Logger this_$iv = Logger.INSTANCE;
        if (this_$iv.getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface;
            skikoLoggerInterface = ((Logger)((Object)skikoLoggerInterface)).getLoggerImpl();
            skikoLoggerInterface.debug("SkiaSwingLayer.awt#addNotify " + this);
        }
        super.addNotify();
        SkiaSwingLayer skiaSwingLayer = this;
        skiaSwingLayer.init(skiaSwingLayer.isInitialized);
    }

    /*
     * WARNING - void declaration
     */
    private final void init(boolean recreation) {
        void var1_1;
        this.isDisposed = false;
        this.redrawerManager.findNextWorkingRenderApi((boolean)var1_1);
        this.isInitialized = true;
    }

    static /* synthetic */ void init$default(SkiaSwingLayer skiaSwingLayer, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        skiaSwingLayer.init(bl);
    }

    public final void dispose() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String string = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(string.toString());
        }
        if (this.isInitialized && !this.isDisposed) {
            SwingRedrawer swingRedrawer = this.getRedrawer();
            if (swingRedrawer != null) {
                swingRedrawer.dispose();
            }
            this.redrawerManager.dispose();
            this.isDisposed = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint(Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        try {
            SwingRedrawer swingRedrawer = this.getRedrawer();
            if (swingRedrawer != null) {
                swingRedrawer.redraw((Graphics2D)g);
                return;
            }
            return;
        }
        catch (RenderException e) {
            if (!this.isDisposed) {
                Logger this_$iv = Logger.INSTANCE;
                if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                    void var1_2;
                    Throwable throwable;
                    SkikoLoggerInterface skikoLoggerInterface = ((Logger)((Object)throwable)).getLoggerImpl();
                    throwable = (Throwable)var1_2;
                    SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                    String string = "Exception in draw scope";
                    skikoLoggerInterface2.warn(throwable, string);
                }
                RedrawerManager.findNextWorkingRenderApi$default(this.redrawerManager, false, 1, null);
                this.repaint();
            }
            return;
        }
    }

    private static /* synthetic */ void getNativeAccessibleFocusHelper$annotations() {
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        AccessibleContext accessibleContext = this.nativeAccessibleFocusHelper.getAccessibleContext();
        if (accessibleContext == null) {
            accessibleContext = super.getAccessibleContext();
        }
        return accessibleContext;
    }

    /*
     * WARNING - void declaration
     */
    public final void requestNativeFocusOnAccessible(Accessible accessible) {
        void var1_1;
        this.nativeAccessibleFocusHelper.requestNativeFocusOnAccessible((Accessible)var1_1);
    }

    public static final /* synthetic */ SkiaLayerProperties access$getProperties$p(SkiaSwingLayer $this) {
        return $this.properties;
    }

    public static final /* synthetic */ swingLayerProperties.1 access$getSwingLayerProperties$p(SkiaSwingLayer $this) {
        return $this.swingLayerProperties;
    }

    public static final /* synthetic */ renderDelegateWithClipping.1 access$getRenderDelegateWithClipping$p(SkiaSwingLayer $this) {
        return $this.renderDelegateWithClipping;
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lorg/jetbrains/skiko/swing/SkiaSwingLayer$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

