/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.graphicapi.InternalDirectXApi;
import org.jetbrains.skiko.swing.SoftwareSwingPainter;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingPainter;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J/\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0019H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001e\u001a\u00060\u0019j\u0002`\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0018\u0010&\u001a\u00060\u0019j\u0002`\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010\u001fR\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010*R\u0016\u0010+\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010\u001f"}, d2={"Lorg/jetbrains/skiko/swing/Direct3DSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "swingLayerProperties", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "renderDelegate", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "analytics", "<init>", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "", "dispose", "()V", "Lorg/jetbrains/skia/Surface;", "surface", "Ljava/awt/Graphics2D;", "g", "flush", "(Lorg/jetbrains/skia/Surface;Ljava/awt/Graphics2D;)V", "Lorg/jetbrains/skia/BackendRenderTarget;", "makeRenderTarget", "()Lorg/jetbrains/skia/BackendRenderTarget;", "", "width", "height", "", "nanoTime", "onRender", "(Ljava/awt/Graphics2D;IIJ)V", "Lorg/jetbrains/skia/impl/NativePointer;", "adapter", "J", "", "bytesToDraw", "[B", "Lorg/jetbrains/skia/DirectContext;", "context", "Lorg/jetbrains/skia/DirectContext;", "device", "Lorg/jetbrains/skiko/swing/SwingPainter;", "painter", "Lorg/jetbrains/skiko/swing/SwingPainter;", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "texturePtr", "Companion"})
public final class Direct3DSwingRedrawer
extends SwingRedrawerBase {
    public static final Companion Companion = new Companion(null);
    private final SkikoRenderDelegate renderDelegate;
    private final long adapter;
    private final long device;
    private final SwingPainter painter;
    private final DirectContext context;
    private long texturePtr;
    private byte[] bytesToDraw;

    /*
     * WARNING - void declaration
     */
    public Direct3DSwingRedrawer(SwingLayerProperties swingLayerProperties2, SkikoRenderDelegate renderDelegate, SkiaLayerAnalytics analytics) {
        void var1_1;
        Direct3DSwingRedrawer direct3DSwingRedrawer;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"swingLayerProperties");
        Intrinsics.checkNotNullParameter((Object)renderDelegate, (String)"renderDelegate");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        super(swingLayerProperties2, (SkiaLayerAnalytics)var3_3, GraphicsApi.DIRECT3D);
        this.renderDelegate = direct3DSwingRedrawer;
        long l = InternalDirectXApi.INSTANCE.chooseAdapter(swingLayerProperties2.getAdapterPriority());
        direct3DSwingRedrawer = this;
        this.onDeviceChosen("DirectX12");
        direct3DSwingRedrawer.adapter = l;
        this.device = InternalDirectXApi.INSTANCE.createDirectXOffscreenDevice(this.adapter);
        this.painter = new SoftwareSwingPainter((SwingLayerProperties)var1_1);
        if (this.device == 0L) {
            throw new RenderException("Failed to create DirectX12 device.", null, 2, null);
        }
        this.context = new DirectContext(InternalDirectXApi.INSTANCE.makeDirectXContext(this.device));
        this.bytesToDraw = new byte[0];
        this.onContextInit();
    }

    @Override
    public final void dispose() {
        this.bytesToDraw = new byte[0];
        this.context.close();
        InternalDirectXApi.INSTANCE.disposeDirectXTexture(this.texturePtr);
        InternalDirectXApi.INSTANCE.disposeDevice(this.device);
        this.painter.dispose();
        super.dispose();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void onRender(Graphics2D g, int width2, int height2, long nanoTime) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new Function1<CloseScope, Unit>((int)var2_2, this, (int)var3_3, nanoTime, (Graphics2D)var1_1){
            final /* synthetic */ int $width;
            final /* synthetic */ Direct3DSwingRedrawer this$0;
            final /* synthetic */ int $height;
            final /* synthetic */ long $nanoTime;
            final /* synthetic */ Graphics2D $g;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$width = var1_1;
                this.this$0 = var2_2;
                this.$height = var3_3;
                this.$nanoTime = $nanoTime;
                this.$g = $g;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(CloseScope $this$autoCloseScope) {
                void var1_1;
                void var2_3;
                Intrinsics.checkNotNullParameter((Object)$this$autoCloseScope, (String)"$this$autoCloseScope");
                int alignedWidth = InternalDirectXApi.INSTANCE.alignedTextureWidth(this.$width);
                Direct3DSwingRedrawer.access$setTexturePtr$p(this.this$0, InternalDirectXApi.INSTANCE.makeDirectXTexture(Direct3DSwingRedrawer.access$getDevice$p(this.this$0), Direct3DSwingRedrawer.access$getTexturePtr$p(this.this$0), alignedWidth, this.$height));
                if (Direct3DSwingRedrawer.access$getTexturePtr$p(this.this$0) == 0L) {
                    throw new RenderException("Can't allocate DirectX resources", null, 2, null);
                }
                Managed renderTarget = (BackendRenderTarget)$this$autoCloseScope.autoClose((AutoCloseable)Direct3DSwingRedrawer.access$makeRenderTarget(this.this$0));
                renderTarget = Surface.Companion.makeFromBackendRenderTarget(Direct3DSwingRedrawer.access$getContext$p(this.this$0), (BackendRenderTarget)renderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
                if (renderTarget == null || ($this$autoCloseScope = (Surface)$this$autoCloseScope.autoClose((AutoCloseable)renderTarget)) == null) {
                    throw new RenderException("Cannot create surface", null, 2, null);
                }
                Object surface = $this$autoCloseScope;
                Canvas canvas = ((Surface)surface).getCanvas();
                canvas.clear(0);
                Direct3DSwingRedrawer.access$getRenderDelegate$p(this.this$0).onRender((Canvas)var2_3, this.$width, this.$height, this.$nanoTime);
                this.this$0.flush((Surface)var1_1, this.$g);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void flush(Surface surface, Graphics2D g) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        surface.flushAndSubmit(false);
        InternalDirectXApi.INSTANCE.waitForCompletion(this.device, this.texturePtr);
        this.painter.paint((Graphics2D)var2_2, (Surface)var1_1, this.texturePtr);
    }

    private final BackendRenderTarget makeRenderTarget() {
        return new BackendRenderTarget(InternalDirectXApi.INSTANCE.makeDirectXRenderTargetOffScreen(this.texturePtr));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setTexturePtr$p(Direct3DSwingRedrawer $this, long l) {
        void var1_1;
        $this.texturePtr = var1_1;
    }

    public static final /* synthetic */ long access$getDevice$p(Direct3DSwingRedrawer $this) {
        return $this.device;
    }

    public static final /* synthetic */ long access$getTexturePtr$p(Direct3DSwingRedrawer $this) {
        return $this.texturePtr;
    }

    public static final /* synthetic */ BackendRenderTarget access$makeRenderTarget(Direct3DSwingRedrawer $this) {
        return $this.makeRenderTarget();
    }

    public static final /* synthetic */ DirectContext access$getContext$p(Direct3DSwingRedrawer $this) {
        return $this.context;
    }

    public static final /* synthetic */ SkikoRenderDelegate access$getRenderDelegate$p(Direct3DSwingRedrawer $this) {
        return $this.renderDelegate;
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lorg/jetbrains/skiko/swing/Direct3DSwingRedrawer$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

