/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import com.jetbrains.JBR;
import com.jetbrains.SharedTextures;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Surface;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.swing.SwingPainter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J'\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0016\u0010\u000f\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0015\u001a\u0006*\u00020\u00140\u00148\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018"}, d2={"Lorg/jetbrains/skiko/swing/AcceleratedSwingPainter;", "Lorg/jetbrains/skiko/swing/SwingPainter;", "<init>", "()V", "", "dispose", "Ljava/awt/Graphics2D;", "g", "Lorg/jetbrains/skia/Surface;", "surface", "", "texture", "paint", "(Ljava/awt/Graphics2D;Lorg/jetbrains/skia/Surface;J)V", "Ljava/awt/GraphicsConfiguration;", "gc", "Ljava/awt/GraphicsConfiguration;", "Ljava/awt/Image;", "imageWrapper", "Ljava/awt/Image;", "Lcom/jetbrains/SharedTextures;", "sharedTextures", "Lcom/jetbrains/SharedTextures;", "texturePtr", "J"})
public final class AcceleratedSwingPainter
implements SwingPainter {
    private final SharedTextures sharedTextures;
    private Image imageWrapper;
    private long texturePtr;
    private GraphicsConfiguration gc;

    public AcceleratedSwingPainter() {
        if (!JBR.isSharedTexturesSupported() || JBR.getSharedTextures().getTextureType() != 1) {
            throw new RenderException("Shared textures are not supported", null, 2, null);
        }
        this.sharedTextures = JBR.getSharedTextures();
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getDefaultConfiguration(...)");
        this.gc = graphicsConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void paint(Graphics2D g, Surface surface, long texture) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"surface");
        if (!Intrinsics.areEqual((Object)g.getDeviceConfiguration(), (Object)this.gc) || this.texturePtr != texture || this.imageWrapper == null) {
            void var3_3;
            GraphicsConfiguration graphicsConfiguration = g.getDeviceConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getDeviceConfiguration(...)");
            this.gc = graphicsConfiguration;
            this.texturePtr = var3_3;
            this.imageWrapper = this.sharedTextures.wrapTexture(this.gc, this.texturePtr);
        }
        var1_1.drawImage(this.imageWrapper, 0, 0, null);
    }

    @Override
    public final void dispose() {
    }
}

