/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoProperties;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u000f\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002Ba\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00128\u0010\n\u001a4\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0016\b\u0002\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\f2\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\"\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0019R(\u0010\u001b\u001a\u0004\u0018\u00018\u00002\b\u0010\u001a\u001a\u0004\u0018\u00018\u00008\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eRF\u0010\n\u001a4\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00028\u00000\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u001fR*\u0010\b\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00038\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%"}, d2={"Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "R", "", "Lorg/jetbrains/skiko/GraphicsApi;", "defaultRenderApi", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "renderApi", "oldRedrawer", "redrawerFactory", "Lkotlin/Function1;", "", "onRenderApiChanged", "<init>", "(Lorg/jetbrains/skiko/GraphicsApi;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "dispose", "()V", "", "recreation", "findNextWorkingRenderApi", "(Z)V", "", "fallbackRenderApiQueue", "Ljava/util/List;", "Lkotlin/jvm/functions/Function1;", "<set-?>", "redrawer", "Ljava/lang/Object;", "getRedrawer", "()Ljava/lang/Object;", "Lkotlin/jvm/functions/Function2;", "value", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "setRenderApi", "(Lorg/jetbrains/skiko/GraphicsApi;)V"})
@SourceDebugExtension(value={"SMAP\nRedrawerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedrawerManager.kt\norg/jetbrains/skiko/redrawer/RedrawerManager\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,49:1\n159#2,4:50\n*S KotlinDebug\n*F\n+ 1 RedrawerManager.kt\norg/jetbrains/skiko/redrawer/RedrawerManager\n*L\n36#1:50,4\n*E\n"})
public final class RedrawerManager<R> {
    private final Function2<GraphicsApi, R, R> redrawerFactory;
    private final Function1<GraphicsApi, Unit> onRenderApiChanged;
    private final List<GraphicsApi> fallbackRenderApiQueue;
    private R redrawer;
    private GraphicsApi renderApi;

    /*
     * WARNING - void declaration
     */
    public RedrawerManager(GraphicsApi defaultRenderApi, Function2<? super GraphicsApi, ? super R, ? extends R> redrawerFactory, Function1<? super GraphicsApi, Unit> onRenderApiChanged) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)((Object)defaultRenderApi), (String)"defaultRenderApi");
        Intrinsics.checkNotNullParameter(redrawerFactory, (String)"redrawerFactory");
        this.redrawerFactory = var2_2;
        this.onRenderApiChanged = var3_3;
        this.fallbackRenderApiQueue = CollectionsKt.toMutableList((Collection)SkikoProperties.INSTANCE.fallbackRenderApiQueue$skiko((GraphicsApi)var1_1));
        this.renderApi = this.fallbackRenderApiQueue.get(0);
    }

    public /* synthetic */ RedrawerManager(GraphicsApi graphicsApi, Function2 function2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        this(graphicsApi, function2, (Function1<? super GraphicsApi, Unit>)function1);
    }

    public final R getRedrawer() {
        return this.redrawer;
    }

    public final GraphicsApi getRenderApi() {
        return this.renderApi;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRenderApi(GraphicsApi value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.renderApi = value;
        Function1<GraphicsApi, Unit> function1 = this.onRenderApiChanged;
        if (function1 != null) {
            void var1_1;
            function1.invoke((Object)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void findNextWorkingRenderApi(boolean recreation) {
        boolean bl;
        if (recreation) {
            this.fallbackRenderApiQueue.add(0, this.renderApi);
        }
        do {
            boolean thrown = false;
            try {
                RedrawerManager redrawerManager2 = this;
                redrawerManager2.setRenderApi(redrawerManager2.fallbackRenderApiQueue.remove(0));
                this.redrawer = this.redrawerFactory.invoke((Object)this.renderApi, this.redrawer);
            }
            catch (RenderException e) {
                this.redrawer = null;
                Logger this_$iv = Logger.INSTANCE;
                if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                    void var1_2;
                    Throwable throwable = (Throwable)var1_2;
                    SkikoLoggerInterface skikoLoggerInterface = ((Logger)((Object)throwable)).getLoggerImpl();
                    String string = "Fallback to next API";
                    skikoLoggerInterface.warn(throwable, string);
                }
                bl = true;
            }
        } while (bl && !((Collection)this.fallbackRenderApiQueue).isEmpty());
        if (bl) {
            throw new RenderException("Cannot fallback to any render API", null, 2, null);
        }
    }

    public static /* synthetic */ void findNextWorkingRenderApi$default(RedrawerManager redrawerManager2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        redrawerManager2.findNextWorkingRenderApi(bl);
    }

    public final void dispose() {
        this.redrawer = null;
    }
}

