/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skiko.AWTKt;
import org.jetbrains.skiko.AngleApi;
import org.jetbrains.skiko.AngleSupport_jvmKt;
import org.jetbrains.skiko.FrameDispatcher;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.GraphicsApi_jvmKt;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.MainUIDispatcher_awtKt;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoProperties;
import org.jetbrains.skiko.context.AngleContextHandler;
import org.jetbrains.skiko.context.ContextHandler;
import org.jetbrains.skiko.redrawer.AWTRedrawer;
import org.jetbrains.skiko.redrawer.AngleRedrawerKt;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.RedrawerManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001b\u0010\fJ\u000f\u0010\u001c\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001c\u0010\fR\u0016\u0010 \u001a\u0004\u0018\u00010\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001c\u0010%\u001a\u00020$8B@\u0002X\u0082\u000e\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0016\u0010*\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010-\u001a\u00020,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010/R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00100R\u0014\u00102\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u001f"}, d2={"Lorg/jetbrains/skiko/redrawer/AngleRedrawer;", "Lorg/jetbrains/skiko/redrawer/AWTRedrawer;", "Lorg/jetbrains/skiko/SkiaLayer;", "layer", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "properties", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/SkiaLayerProperties;)V", "", "dispose", "()V", "draw", "", "withVsync", "drawAndSwap", "(Z)V", "Lorg/jetbrains/skia/DirectContext;", "makeContext", "()Lorg/jetbrains/skia/DirectContext;", "", "width", "height", "Lorg/jetbrains/skia/BackendRenderTarget;", "makeRenderTarget", "(II)Lorg/jetbrains/skia/BackendRenderTarget;", "needRedraw", "redrawImmediately", "", "getAdapterName", "()Ljava/lang/String;", "adapterName", "Lorg/jetbrains/skiko/context/AngleContextHandler;", "contextHandler", "Lorg/jetbrains/skiko/context/AngleContextHandler;", "", "device", "J", "getDevice", "()J", "", "drawLock", "Ljava/lang/Object;", "Lorg/jetbrains/skiko/FrameDispatcher;", "frameDispatcher", "Lorg/jetbrains/skiko/FrameDispatcher;", "Lorg/jetbrains/skiko/SkiaLayer;", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "getRenderInfo", "renderInfo"})
@SourceDebugExtension(value={"SMAP\nAngleRedrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AngleRedrawer.kt\norg/jetbrains/skiko/redrawer/AngleRedrawer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AWTRedrawer.kt\norg/jetbrains/skiko/redrawer/AWTRedrawer\n+ 4 SkiaLayer.awt.kt\norg/jetbrains/skiko/SkiaLayer\n+ 5 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,108:1\n1#2:109\n1#2:111\n1#2:144\n58#3:110\n59#3,6:112\n65#3,7:136\n58#3:143\n59#3,6:145\n65#3,7:169\n582#4,9:118\n591#4,5:131\n582#4,9:151\n591#4,5:164\n159#5,4:127\n159#5,4:160\n*S KotlinDebug\n*F\n+ 1 AngleRedrawer.kt\norg/jetbrains/skiko/redrawer/AngleRedrawer\n*L\n70#1:111\n77#1:144\n70#1:110\n70#1:112,6\n70#1:136,7\n77#1:143\n77#1:145,6\n77#1:169,7\n70#1:118,9\n70#1:131,5\n77#1:151,9\n77#1:164,5\n70#1:127,4\n77#1:160,4\n*E\n"})
public final class AngleRedrawer
extends AWTRedrawer {
    private final SkiaLayer layer;
    private final SkiaLayerProperties properties;
    private final AngleContextHandler contextHandler;
    private Object drawLock;
    private long device;
    private final FrameDispatcher frameDispatcher;

    /*
     * WARNING - void declaration
     */
    public AngleRedrawer(SkiaLayer layer, SkiaLayerAnalytics analytics, SkiaLayerProperties properties) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(layer, (SkiaLayerAnalytics)var2_2, GraphicsApi.ANGLE);
        this.layer = layer;
        this.properties = var3_3;
        AngleSupport_jvmKt.loadAngleLibrary();
        this.contextHandler = new AngleContextHandler(this.layer);
        this.drawLock = new Object();
        this.frameDispatcher = new FrameDispatcher((CoroutineContext)MainUIDispatcher_awtKt.getMainUIDispatcher(), (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AngleRedrawer this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super(1, (Continuation)var2_2);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (AngleRedrawer.access$getLayer$p(this.this$0).isShowing()) {
                            this.this$0.update(System.nanoTime());
                            AngleRedrawer.access$draw(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * WARNING - void declaration
             */
            public final Continuation<Unit> create(Continuation<?> $completion) {
                void var1_1;
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            /*
             * WARNING - void declaration
             */
            public final Object invoke(Continuation<? super Unit> p1) {
                void var1_1;
                return (this.create((Continuation)var1_1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        this.device = ((Number)AWTKt.useDrawingSurfacePlatformInfo(this.layer.getBackedLayer$skiko(), (Function1)new Function1<Long, Long>(this){
            final /* synthetic */ AngleRedrawer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(1);
            }

            public final Long invoke(long platformInfo) {
                Long l = AngleRedrawerKt.access$createAngleDevice(platformInfo, this.this$0.layer.getTransparency());
                long l2 = ((Number)l).longValue();
                Long l3 = l2 != 0L ? l : null;
                if (l3 == null) {
                    throw new RenderException("Failed to create ANGLE device.", null, 2, null);
                }
                return (long)l3;
            }
        })).longValue();
        String adapterName = this.getAdapterName();
        if (adapterName != null && !GraphicsApi_jvmKt.isVideoCardSupported(GraphicsApi.ANGLE, OsArch_jvmKt.getHostOs(), adapterName)) {
            throw new RenderException("Cannot create ANGLE redrawer.", null, 2, null);
        }
        this.onDeviceChosen((String)var1_1);
        this.onContextInit();
    }

    @Override
    public final String getRenderInfo() {
        return ((ContextHandler)this.contextHandler).rendererInfo();
    }

    private final long getDevice() {
        if (this.device == 0L) {
            throw new RenderException("ANGLE device is not initialized or already disposed", null, 2, null);
        }
        return this.device;
    }

    private final String getAdapterName() {
        AngleApi angleApi = AngleApi.INSTANCE;
        return angleApi.glGetString(angleApi.getGL_RENDERER());
    }

    @Override
    public final void dispose() {
        Object object = this.drawLock;
        synchronized (object) {
            this.frameDispatcher.cancel();
            AngleRedrawerKt.access$makeCurrent(this.getDevice());
            this.contextHandler.dispose();
            AngleRedrawerKt.access$disposeDevice(this.getDevice());
            this.device = 0L;
            super.dispose();
            return;
        }
    }

    @Override
    public final void needRedraw() {
        if (!(!this.isDisposed())) {
            String string = "ANGLE redrawer is disposed";
            throw new IllegalStateException(string.toString());
        }
        this.frameDispatcher.scheduleFrame();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void redrawImmediately() {
        if (!(!this.isDisposed())) {
            String string = "ANGLE redrawer is disposed";
            throw new IllegalStateException(string.toString());
        }
        Object this_$iv = this;
        if (AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv) == null) {
            this_$iv = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(this_$iv.toString());
        }
        if (!AWTRedrawer.access$isDisposed((AWTRedrawer)this_$iv)) {
            void var1_2;
            block15: {
                if (!AWTRedrawer.access$isFirstFrameRendered$p((AWTRedrawer)this_$iv)) {
                    SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv);
                    if (deviceAnalytics != null) {
                        deviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv);
                if (deviceAnalytics != null) {
                    deviceAnalytics.beforeFrameRender();
                }
                SkiaLayer this_$iv$iv = AWTRedrawer.access$getLayer$p((AWTRedrawer)this_$iv);
                if (!SwingUtilities.isEventDispatchThread()) {
                    String string = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException(string.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(this_$iv$iv))) {
                    String string = "SkiaLayer is disposed";
                    throw new IllegalStateException(string.toString());
                }
                try {
                    this.update(System.nanoTime());
                    this.drawAndSwap(SkikoProperties.INSTANCE.getWindowsWaitForVsyncOnRedrawImmediately());
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException e$iv$iv) {
                    void var2_3;
                    if (SkiaLayer.access$isDisposed$p(this_$iv$iv)) break block15;
                    Logger this_$iv$iv$iv = Logger.INSTANCE;
                    if (this_$iv$iv$iv.getLoggerImpl().isWarnEnabled()) {
                        Throwable throwable;
                        SkikoLoggerInterface skikoLoggerInterface = ((Logger)((Object)throwable)).getLoggerImpl();
                        throwable = e$iv$iv;
                        SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface2.warn(throwable, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(this_$iv$iv), false, 1, null);
                    Redrawer redrawer = var2_3.getRedrawer$skiko();
                    if (redrawer == null) break block15;
                    redrawer.redrawImmediately();
                }
            }
            if (!AWTRedrawer.access$isFirstFrameRendered$p((AWTRedrawer)this_$iv) && !AWTRedrawer.access$isDisposed((AWTRedrawer)this_$iv)) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv);
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv);
            if (deviceAnalytics != null) {
                deviceAnalytics.afterFrameRender();
            }
            AWTRedrawer.access$setFirstFrameRendered$p((AWTRedrawer)var1_2, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void draw() {
        Object this_$iv = this;
        if (AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv) == null) {
            this_$iv = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(this_$iv.toString());
        }
        if (!AWTRedrawer.access$isDisposed((AWTRedrawer)this_$iv)) {
            void var1_1;
            block14: {
                if (!AWTRedrawer.access$isFirstFrameRendered$p((AWTRedrawer)this_$iv)) {
                    SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv);
                    if (deviceAnalytics != null) {
                        deviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv);
                if (deviceAnalytics != null) {
                    deviceAnalytics.beforeFrameRender();
                }
                SkiaLayer this_$iv$iv = AWTRedrawer.access$getLayer$p((AWTRedrawer)this_$iv);
                if (!SwingUtilities.isEventDispatchThread()) {
                    String string = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException(string.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(this_$iv$iv))) {
                    String string = "SkiaLayer is disposed";
                    throw new IllegalStateException(string.toString());
                }
                try {
                    AngleRedrawer angleRedrawer = this;
                    angleRedrawer.drawAndSwap(angleRedrawer.properties.isVsyncEnabled());
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException e$iv$iv) {
                    void var2_2;
                    if (SkiaLayer.access$isDisposed$p(this_$iv$iv)) break block14;
                    Logger this_$iv$iv$iv = Logger.INSTANCE;
                    if (this_$iv$iv$iv.getLoggerImpl().isWarnEnabled()) {
                        Throwable throwable;
                        SkikoLoggerInterface skikoLoggerInterface = ((Logger)((Object)throwable)).getLoggerImpl();
                        throwable = e$iv$iv;
                        SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface2.warn(throwable, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(this_$iv$iv), false, 1, null);
                    Redrawer redrawer = var2_2.getRedrawer$skiko();
                    if (redrawer == null) break block14;
                    redrawer.redrawImmediately();
                }
            }
            if (!AWTRedrawer.access$isFirstFrameRendered$p((AWTRedrawer)this_$iv) && !AWTRedrawer.access$isDisposed((AWTRedrawer)this_$iv)) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv);
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv);
            if (deviceAnalytics != null) {
                deviceAnalytics.afterFrameRender();
            }
            AWTRedrawer.access$setFirstFrameRendered$p((AWTRedrawer)var1_1, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawAndSwap(boolean withVsync) {
        Object object = this.drawLock;
        synchronized (object) {
            void var1_1;
            if (this.isDisposed()) {
                return;
            }
            AngleRedrawerKt.access$makeCurrent(this.getDevice());
            this.contextHandler.draw();
            AngleRedrawerKt.access$swapBuffers(this.getDevice(), (boolean)var1_1);
            return;
        }
    }

    public final DirectContext makeContext() {
        Long l = AngleRedrawerKt.access$makeAngleContext(this.getDevice());
        long l2 = ((Number)l).longValue();
        Long l3 = l2 != 0L ? l : null;
        if (l3 == null) {
            throw new RenderException("Failed to make GL context.", null, 2, null);
        }
        long l4 = l3;
        return new DirectContext(l4);
    }

    /*
     * WARNING - void declaration
     */
    public final BackendRenderTarget makeRenderTarget(int width2, int height2) {
        void var2_3;
        void var1_1;
        Long l = AngleRedrawerKt.access$makeAngleRenderTarget(this.getDevice(), (int)var1_1, (int)var2_3);
        long l2 = ((Number)l).longValue();
        Long l3 = l2 != 0L ? l : null;
        if (l3 == null) {
            throw new RenderException("Failed to make ANGLE render target.", null, 2, null);
        }
        long l4 = l3;
        return new BackendRenderTarget(l4);
    }

    public static final /* synthetic */ void access$draw(AngleRedrawer $this) {
        $this.draw();
    }
}

