/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.graphicapi;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skiko.ExperimentalSkikoApi;
import org.jetbrains.skiko.GpuPriority;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.graphicapi.InternalDirectXApi;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u0018\u0010\b\u001a\u00060\u0006j\u0002`\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00060\u0006j\u0002`\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\tR\u001a\u0010\f\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/skiko/graphicapi/DirectXOffscreenContext;", "Ljava/lang/AutoCloseable;", "<init>", "()V", "", "close", "", "Lorg/jetbrains/skia/impl/NativePointer;", "adapter", "J", "device", "Lorg/jetbrains/skia/DirectContext;", "directContext", "Lorg/jetbrains/skia/DirectContext;", "getDirectContext", "()Lorg/jetbrains/skia/DirectContext;", "Texture"})
@ExperimentalSkikoApi
public final class DirectXOffscreenContext
implements AutoCloseable {
    private final long adapter = InternalDirectXApi.INSTANCE.chooseAdapter(GpuPriority.Integrated);
    private final long device;
    private final DirectContext directContext;

    public DirectXOffscreenContext() {
        long l;
        long l2 = l = InternalDirectXApi.INSTANCE.createDirectXOffscreenDevice(this.adapter);
        DirectXOffscreenContext directXOffscreenContext = this;
        if (l2 == 0L) {
            throw new RenderException("Failed to create DirectX12 device.", null, 2, null);
        }
        directXOffscreenContext.device = l;
        this.directContext = new DirectContext(InternalDirectXApi.INSTANCE.makeDirectXContext(this.device));
    }

    public final DirectContext getDirectContext() {
        return this.directContext;
    }

    @Override
    public final void close() {
        this.directContext.close();
        InternalDirectXApi.INSTANCE.disposeDevice(this.device);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\tR\u001a\u0010\u000f\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0014\u0010\u0012R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001c\u001a\u00060\u001aj\u0002`\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d"}, d2={"Lorg/jetbrains/skiko/graphicapi/DirectXOffscreenContext$Texture;", "Ljava/lang/AutoCloseable;", "", "desiredWidth", "desiredHeight", "<init>", "(Lorg/jetbrains/skiko/graphicapi/DirectXOffscreenContext;II)V", "", "close", "()V", "", "byteArray", "readPixels", "([B)V", "waitForCompletion", "actualHeight", "I", "getActualHeight", "()I", "actualWidth", "getActualWidth", "Lorg/jetbrains/skia/BackendRenderTarget;", "backendRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "getBackendRenderTarget", "()Lorg/jetbrains/skia/BackendRenderTarget;", "", "Lorg/jetbrains/skia/impl/NativePointer;", "texture", "J"})
    public final class Texture
    implements AutoCloseable {
        private final int actualWidth;
        private final int actualHeight;
        private final long texture;
        private final BackendRenderTarget backendRenderTarget;
        final /* synthetic */ DirectXOffscreenContext this$0;

        /*
         * WARNING - void declaration
         */
        public Texture(DirectXOffscreenContext this$0, int desiredWidth, int desiredHeight) {
            void it;
            long l;
            void var3_3;
            void var2_2;
            Texture texture;
            this.this$0 = texture;
            this.actualWidth = InternalDirectXApi.INSTANCE.alignedTextureWidth((int)var2_2);
            this.actualHeight = var3_3;
            long l2 = l = InternalDirectXApi.INSTANCE.makeDirectXTexture(this.this$0.device, 0L, this.actualWidth, this.actualHeight);
            texture = this;
            if (it == 0L) {
                throw new RenderException("Can't allocate DirectX resources", null, 2, null);
            }
            texture.texture = l;
            this.backendRenderTarget = new BackendRenderTarget(InternalDirectXApi.INSTANCE.makeDirectXRenderTargetOffScreen(this.texture));
        }

        public final int getActualWidth() {
            return this.actualWidth;
        }

        public final int getActualHeight() {
            return this.actualHeight;
        }

        public final BackendRenderTarget getBackendRenderTarget() {
            return this.backendRenderTarget;
        }

        @Override
        public final void close() {
            this.backendRenderTarget.close();
            InternalDirectXApi.INSTANCE.disposeDirectXTexture(this.texture);
        }

        public final void waitForCompletion() {
            InternalDirectXApi.INSTANCE.waitForCompletion(this.this$0.device, this.texture);
        }

        /*
         * WARNING - void declaration
         */
        public final void readPixels(byte[] byteArray) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            if (!InternalDirectXApi.INSTANCE.readPixels(this.texture, (byte[])var1_1)) {
                throw new RenderException("Couldn't read pixels", null, 2, null);
            }
        }
    }
}

