/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.AngleApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.ContextHandler;
import org.jetbrains.skiko.context.JvmContextHandler;
import org.jetbrains.skiko.redrawer.AngleRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019"}, d2={"Lorg/jetbrains/skiko/context/AngleContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "Lorg/jetbrains/skiko/SkiaLayer;", "layer", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "", "initCanvas", "()V", "", "initContext", "()Z", "", "width", "height", "isSizeChanged", "(II)Z", "", "rendererInfo", "()Ljava/lang/String;", "Lorg/jetbrains/skiko/redrawer/AngleRedrawer;", "getAngleRedrawer", "()Lorg/jetbrains/skiko/redrawer/AngleRedrawer;", "angleRedrawer", "currentHeight", "I", "currentWidth"})
@SourceDebugExtension(value={"SMAP\nAngleContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AngleContextHandler.kt\norg/jetbrains/skiko/context/AngleContextHandler\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,73:1\n124#2,4:74\n159#2,4:78\n*S KotlinDebug\n*F\n+ 1 AngleContextHandler.kt\norg/jetbrains/skiko/context/AngleContextHandler\n*L\n19#1:74,4\n23#1:78,4\n*E\n"})
public final class AngleContextHandler
extends JvmContextHandler {
    private int currentWidth;
    private int currentHeight;

    /*
     * WARNING - void declaration
     */
    public AngleContextHandler(SkiaLayer layer) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super((SkiaLayer)var1_1);
    }

    private final AngleRedrawer getAngleRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (AngleRedrawer)redrawer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean initContext() {
        try {
            if (this.getContext() == null) {
                Object this_$iv;
                AngleContextHandler angleContextHandler = this;
                angleContextHandler.setContext(angleContextHandler.getAngleRedrawer().makeContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && ((Logger)(this_$iv = Logger.INSTANCE)).getLoggerImpl().isInfoEnabled()) {
                    this_$iv = ((Logger)this_$iv).getLoggerImpl();
                    this_$iv.info("Renderer info:\n " + ((ContextHandler)this).rendererInfo());
                }
            }
        }
        catch (Exception e) {
            Logger this_$iv = Logger.INSTANCE;
            if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                void var1_2;
                Throwable throwable;
                SkikoLoggerInterface skikoLoggerInterface = ((Logger)((Object)throwable)).getLoggerImpl();
                throwable = (Throwable)var1_2;
                SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                String string = "Failed to create Skia ANGLE context!";
                skikoLoggerInterface2.warn(throwable, string);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSizeChanged(int width2, int height2) {
        if (width2 != this.currentWidth || height2 != this.currentHeight) {
            void var2_2;
            void var1_1;
            this.currentWidth = var1_1;
            this.currentHeight = var2_2;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void initCanvas() {
        int h;
        DirectContext directContext = this.getContext();
        if (directContext == null) {
            return;
        }
        DirectContext context = directContext;
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        if (this.isSizeChanged(w, h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0)) || this.getSurface() == null) {
            void var1_1;
            void var2_3;
            void var3_4;
            this.disposeCanvas();
            context.flush();
            AngleContextHandler angleContextHandler = this;
            angleContextHandler.setRenderTarget(angleContextHandler.getAngleRedrawer().makeRenderTarget((int)var3_4, (int)var2_3));
            BackendRenderTarget backendRenderTarget = this.getRenderTarget();
            Intrinsics.checkNotNull((Object)backendRenderTarget);
            Surface surface = Surface.Companion.makeFromBackendRenderTarget((DirectContext)var1_1, backendRenderTarget, SurfaceOrigin.BOTTOM_LEFT, SurfaceColorFormat.RGBA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null));
            if (surface == null) {
                throw new RenderException("Cannot create surface", null, 2, null);
            }
            this.setSurface(surface);
        }
        AngleContextHandler angleContextHandler = this;
        Surface surface = angleContextHandler.getSurface();
        Intrinsics.checkNotNull((Object)surface);
        angleContextHandler.setCanvas(surface.getCanvas());
    }

    @Override
    public final String rendererInfo() {
        AngleApi angleApi = AngleApi.INSTANCE;
        AngleApi angleApi2 = AngleApi.INSTANCE;
        AngleApi angleApi3 = AngleApi.INSTANCE;
        return super.rendererInfo() + "Vendor: " + angleApi.glGetString(angleApi.getGL_VENDOR()) + "\nModel: " + angleApi2.glGetString(angleApi2.getGL_RENDERER()) + "\nVersion: " + angleApi3.glGetString(angleApi3.getGL_VERSION()) + '\n';
    }
}

