/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.ColorType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001c\u0018\u0000 -2\u00020\u0001:\u0001-B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0010R\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010%\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010)R\u0011\u0010,\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0010"}, d2={"Lorg/jetbrains/skia/ColorInfo;", "", "Lorg/jetbrains/skia/ColorType;", "colorType", "Lorg/jetbrains/skia/ColorAlphaType;", "alphaType", "Lorg/jetbrains/skia/ColorSpace;", "colorSpace", "<init>", "(Lorg/jetbrains/skia/ColorType;Lorg/jetbrains/skia/ColorAlphaType;Lorg/jetbrains/skia/ColorSpace;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "_alphaType", "withAlphaType", "(Lorg/jetbrains/skia/ColorAlphaType;)Lorg/jetbrains/skia/ColorInfo;", "_colorSpace", "withColorSpace", "(Lorg/jetbrains/skia/ColorSpace;)Lorg/jetbrains/skia/ColorInfo;", "_colorType", "withColorType", "(Lorg/jetbrains/skia/ColorType;)Lorg/jetbrains/skia/ColorInfo;", "Lorg/jetbrains/skia/ColorAlphaType;", "getAlphaType", "()Lorg/jetbrains/skia/ColorAlphaType;", "getBytesPerPixel", "bytesPerPixel", "Lorg/jetbrains/skia/ColorSpace;", "getColorSpace", "()Lorg/jetbrains/skia/ColorSpace;", "Lorg/jetbrains/skia/ColorType;", "getColorType", "()Lorg/jetbrains/skia/ColorType;", "isGammaCloseToSRGB", "()Z", "isOpaque", "getShiftPerPixel", "shiftPerPixel", "Companion"})
public final class ColorInfo {
    public static final Companion Companion = new Companion(null);
    private final ColorType colorType;
    private final ColorAlphaType alphaType;
    private final ColorSpace colorSpace;
    private static final ColorInfo DEFAULT = new ColorInfo(ColorType.UNKNOWN, ColorAlphaType.UNKNOWN, null);

    /*
     * WARNING - void declaration
     */
    public ColorInfo(ColorType colorType, ColorAlphaType alphaType, ColorSpace colorSpace) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"colorType");
        Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
        this.colorType = var1_1;
        this.alphaType = var2_2;
        this.colorSpace = var3_3;
    }

    public final ColorType getColorType() {
        return this.colorType;
    }

    public final ColorAlphaType getAlphaType() {
        return this.alphaType;
    }

    public final ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public final boolean isOpaque() {
        return this.alphaType == ColorAlphaType.OPAQUE || this.colorType.isAlwaysOpaque();
    }

    public final int getBytesPerPixel() {
        return this.colorType.getBytesPerPixel();
    }

    public final int getShiftPerPixel() {
        return this.colorType.getShiftPerPixel();
    }

    public final boolean isGammaCloseToSRGB() {
        return this.colorSpace != null && this.colorSpace.isGammaCloseToSRGB();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (other == this) {
            return true;
        }
        if (!(other instanceof ColorInfo)) {
            return false;
        }
        if (this.colorType != ((ColorInfo)other).colorType) {
            return false;
        }
        if (this.alphaType != ((ColorInfo)other).alphaType) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.colorSpace, (Object)((ColorInfo)var1_1).colorSpace);
    }

    public final int hashCode() {
        int n = 59 + this.colorType.hashCode();
        n = n * 59 + this.alphaType.hashCode();
        ColorSpace colorSpace = this.colorSpace;
        n = n * 59 + (colorSpace != null ? ((Object)colorSpace).hashCode() : 0);
        return n;
    }

    public final String toString() {
        return "ColorInfo(_colorType=" + (Object)((Object)this.colorType) + ", _alphaType=" + (Object)((Object)this.alphaType) + ", _colorSpace=" + this.colorSpace + ')';
    }

    /*
     * WARNING - void declaration
     */
    public final ColorInfo withColorType(ColorType _colorType) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)_colorType), (String)"_colorType");
        if (this.colorType == _colorType) {
            return this;
        }
        return new ColorInfo((ColorType)var1_1, this.alphaType, this.colorSpace);
    }

    /*
     * WARNING - void declaration
     */
    public final ColorInfo withAlphaType(ColorAlphaType _alphaType) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)_alphaType), (String)"_alphaType");
        if (this.alphaType == _alphaType) {
            return this;
        }
        return new ColorInfo(this.colorType, (ColorAlphaType)var1_1, this.colorSpace);
    }

    /*
     * WARNING - void declaration
     */
    public final ColorInfo withColorSpace(ColorSpace _colorSpace) {
        void var1_1;
        if (this.colorSpace == _colorSpace) {
            return this;
        }
        return new ColorInfo(this.colorType, this.alphaType, (ColorSpace)var1_1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/skia/ColorInfo$Companion;", "", "<init>", "()V", "Lorg/jetbrains/skia/ColorInfo;", "DEFAULT", "Lorg/jetbrains/skia/ColorInfo;", "getDEFAULT", "()Lorg/jetbrains/skia/ColorInfo;"})
    public static final class Companion {
        private Companion() {
        }

        public final ColorInfo getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

