/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.selector;

import io.ktor.network.selector.InterestSuspensionsMap;
import io.ktor.network.selector.SelectInterest;
import io.ktor.network.selector.Selectable;
import io.ktor.network.selector.SelectorManager;
import io.ktor.network.selector.SelectorManagerSupport;
import io.ktor.network.selector.SelectorManagerSupportKt;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0010\b'\u0018\u00002\u00020\u0001:\u00018B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H$\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0086@\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\u0012\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u000eH\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u001eH\u0004\u00a2\u0006\u0004\b \u0010!J!\u0010 \u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0004\u00a2\u0006\u0004\b \u0010\"R\u0017\u0010$\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\"\u0010)\u001a\u00020(8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\"\u0010/\u001a\u00020(8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b/\u0010*\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R,\u00107\u001a\u0004\u0018\u00010\u0004*\u00020\u000e2\b\u00102\u001a\u0004\u0018\u00010\u00048B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b3\u00104\"\u0004\b5\u00106"}, d2={"Lio/ktor/network/selector/SelectorManagerSupport;", "Lio/ktor/network/selector/SelectorManager;", "<init>", "()V", "Lio/ktor/network/selector/Selectable;", "selectable", "", "publishInterest", "(Lio/ktor/network/selector/Selectable;)V", "Lio/ktor/network/selector/SelectInterest;", "interest", "select", "(Lio/ktor/network/selector/Selectable;Lio/ktor/network/selector/SelectInterest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "Ljava/nio/channels/SelectionKey;", "selectedKeys", "", "keys", "handleSelectedKeys", "(Ljava/util/Set;Ljava/util/Set;)V", "key", "handleSelectedKey", "(Ljava/nio/channels/SelectionKey;)V", "Ljava/nio/channels/Selector;", "selector", "applyInterest", "(Ljava/nio/channels/Selector;Lio/ktor/network/selector/Selectable;)V", "attachment", "notifyClosedImpl", "(Ljava/nio/channels/Selector;Ljava/nio/channels/SelectionKey;Lio/ktor/network/selector/Selectable;)V", "", "cause", "cancelAllSuspensions", "(Lio/ktor/network/selector/Selectable;Ljava/lang/Throwable;)V", "(Ljava/nio/channels/Selector;Ljava/lang/Throwable;)V", "Ljava/nio/channels/spi/SelectorProvider;", "provider", "Ljava/nio/channels/spi/SelectorProvider;", "getProvider", "()Ljava/nio/channels/spi/SelectorProvider;", "", "pending", "I", "getPending", "()I", "setPending", "(I)V", "cancelled", "getCancelled", "setCancelled", "newValue", "getSubject", "(Ljava/nio/channels/SelectionKey;)Lio/ktor/network/selector/Selectable;", "setSubject", "(Ljava/nio/channels/SelectionKey;Lio/ktor/network/selector/Selectable;)V", "subject", "ClosedSelectorCancellationException"})
@SourceDebugExtension(value={"SMAP\nSelectorManagerSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectorManagerSupport.kt\nio/ktor/network/selector/SelectorManagerSupport\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 InterestSuspensionsMap.kt\nio/ktor/network/selector/InterestSuspensionsMap\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n426#2,11:188\n32#3,8:199\n42#3,2:207\n45#3:210\n1#4:209\n1#4:212\n1863#5:211\n1864#5:213\n*S KotlinDebug\n*F\n+ 1 SelectorManagerSupport.kt\nio/ktor/network/selector/SelectorManagerSupport\n*L\n44#1:188,11\n86#1:199,8\n150#1:207,2\n150#1:210\n150#1:209\n161#1:211\n161#1:213\n*E\n"})
public abstract class SelectorManagerSupport
implements SelectorManager {
    private final SelectorProvider provider;
    private int pending;
    private int cancelled;

    public SelectorManagerSupport() {
        SelectorProvider selectorProvider = SelectorProvider.provider();
        Intrinsics.checkNotNullExpressionValue((Object)selectorProvider, (String)"provider(...)");
        this.provider = selectorProvider;
    }

    @Override
    public final SelectorProvider getProvider() {
        return this.provider;
    }

    protected final int getPending() {
        return this.pending;
    }

    /*
     * WARNING - void declaration
     */
    protected final void setPending(int n) {
        void var1_1;
        this.pending = var1_1;
    }

    protected final int getCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - void declaration
     */
    protected final void setCancelled(int n) {
        void var1_1;
        this.cancelled = var1_1;
    }

    protected abstract void publishInterest(Selectable var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object select(Selectable selectable, SelectInterest interest, Continuation<? super Unit> $completion) {
        void var2_2;
        int interestedOps = selectable.getInterestedOps();
        int flag = interest.getFlag();
        if (selectable.isClosed()) {
            SelectorManagerSupportKt.access$selectableIsClosed();
            throw new KotlinNothingValueException();
        }
        if ((interestedOps & flag) == 0) {
            SelectorManagerSupportKt.access$selectableIsInvalid(interestedOps, flag);
            throw new KotlinNothingValueException();
        }
        Continuation<? super Unit> uCont$iv = $completion;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        continuation.invokeOnCancellation((Function1)select.2.1.INSTANCE);
        selectable.getSuspensions().addSuspension((SelectInterest)var2_2, (CancellableContinuation<? super Unit>)continuation);
        if (!continuation.isCancelled()) {
            void var1_1;
            this.publishInterest((Selectable)var1_1);
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            void var3_3;
            DebugProbesKt.probeCoroutineSuspended((Continuation)var3_3);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    protected final void handleSelectedKeys(Set<SelectionKey> selectedKeys, Set<? extends SelectionKey> keys) {
        void var3_3;
        Intrinsics.checkNotNullParameter(selectedKeys, (String)"selectedKeys");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        int selectedCount = selectedKeys.size();
        this.pending = keys.size() - selectedCount;
        this.cancelled = 0;
        if (var3_3 <= 0) {
            return;
        }
        Iterator<SelectionKey> iter = selectedKeys.iterator();
        while (iter.hasNext()) {
            void var2_2;
            SelectionKey k = iter.next();
            this.handleSelectedKey((SelectionKey)var2_2);
            iter.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void handleSelectedKey(SelectionKey key) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            try {
                int readyOps = key.readyOps();
                int interestOps = key.interestOps();
                Selectable subject2 = this.getSubject(key);
                if (subject2 == null) {
                    key.cancel();
                    int subject2 = this.cancelled;
                    this.cancelled = subject2 + 1;
                    return;
                }
                InterestSuspensionsMap this_$iv = subject2.getSuspensions();
                int[] flags$iv = SelectInterest.Companion.getFlags();
                int n = flags$iv.length;
                for (int ordinal$iv = 0; ordinal$iv < n; ++ordinal$iv) {
                    CancellableContinuation<Unit> cancellableContinuation;
                    if ((flags$iv[ordinal$iv] & readyOps) == 0 || this_$iv.removeSuspension(ordinal$iv) == null) continue;
                    ((Continuation)cancellableContinuation).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
                }
                int newOps = interestOps & ~readyOps;
                if (newOps != interestOps) {
                    key.interestOps(newOps);
                }
                if (newOps != 0) {
                    readyOps = this.pending;
                    this.pending = readyOps + 1;
                    return;
                }
            }
            catch (Throwable cause) {
                void var1_1;
                void var3_5;
                void var2_3;
                key.cancel();
                int n = this.cancelled;
                this.cancelled = n + 1;
                Selectable selectable = this.getSubject(key);
                if (selectable == null) break block6;
                Selectable subject = selectable;
                this.cancelAllSuspensions((Selectable)var2_3, (Throwable)var3_5);
                this.setSubject((SelectionKey)var1_1, null);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void applyInterest(Selector selector, Selectable selectable) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)selectable, (String)"selectable");
        try {
            SelectableChannel channel2 = selectable.getChannel();
            SelectionKey key = channel2.keyFor(selector);
            int ops = selectable.getInterestedOps();
            if (key == null) {
                if (ops != 0) {
                    channel2.register(selector, ops, selectable);
                }
            } else if (key.interestOps() != ops) {
                key.interestOps(ops);
            }
            if (ops != 0) {
                int channel2 = this.pending;
                this.pending = channel2 + 1;
                return;
            }
        }
        catch (Throwable cause) {
            void var3_5;
            void var2_2;
            void var1_1;
            SelectionKey selectionKey = selectable.getChannel().keyFor((Selector)var1_1);
            if (selectionKey != null) {
                selectionKey.cancel();
            }
            this.cancelAllSuspensions((Selectable)var2_2, (Throwable)var3_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void notifyClosedImpl(Selector selector, SelectionKey key, Selectable attachment) {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        this.cancelAllSuspensions((Selectable)var3_3, (Throwable)new ClosedChannelException());
        this.setSubject((SelectionKey)var2_2, null);
        var1_1.wakeup();
    }

    protected final void cancelAllSuspensions(Selectable attachment, Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        InterestSuspensionsMap this_$iv = attachment.getSuspensions();
        for (SelectInterest interest$iv : SelectInterest.Companion.getAllInterests()) {
            CancellableContinuation<Unit> cancellableContinuation = this_$iv.removeSuspension(interest$iv);
            if (cancellableContinuation == null) continue;
            CancellableContinuation<Unit> cancellableContinuation2 = cancellableContinuation;
            cancellableContinuation2 = cancellableContinuation;
            ((Continuation)cancellableContinuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)cause)));
        }
    }

    protected final void cancelAllSuspensions(Selector selector, Throwable cause) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Throwable throwable = cause;
        if (throwable == null) {
            throwable = new ClosedSelectorCancellationException();
        }
        Throwable currentCause = throwable;
        Set<SelectionKey> set = ((Selector)object).keys();
        Intrinsics.checkNotNullExpressionValue(set, (String)"keys(...)");
        object = set;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2;
            Object e = object.next();
            SelectionKey key = (SelectionKey)e;
            try {
                if (key.isValid()) {
                    key.interestOps(0);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {}
            if (((object2 = key.attachment()) instanceof Selectable ? (Selectable)object2 : null) != null) {
                Selectable it;
                it = it;
                this.cancelAllSuspensions(it, currentCause);
            }
            ((SelectionKey)e).cancel();
        }
    }

    private final Selectable getSubject(SelectionKey $this$subject) {
        Object object = $this$subject.attachment();
        if (object instanceof Selectable) {
            return (Selectable)object;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void setSubject(SelectionKey $this$subject, Selectable newValue) {
        void var2_2;
        $this$subject.attach(var2_2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004"}, d2={"Lio/ktor/network/selector/SelectorManagerSupport$ClosedSelectorCancellationException;", "Ljava/util/concurrent/CancellationException;", "Lkotlinx/coroutines/CancellationException;", "<init>", "()V"})
    public static final class ClosedSelectorCancellationException
    extends CancellationException {
        public ClosedSelectorCancellationException() {
            super("Closed selector");
        }
    }
}

